/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.jms;

import jakarta.jms.TextMessage;
import java.util.Map;
import org.flowable.eventregistry.api.OutboundEventChannelAdapter;
import org.flowable.eventregistry.spring.jms.JmsMessageCreator;
import org.springframework.jms.core.JmsOperations;

public class JmsOperationsOutboundEventChannelAdapter
implements OutboundEventChannelAdapter<String> {
    protected JmsOperations jmsOperations;
    protected String destination;
    protected JmsMessageCreator<String> messageCreator;

    public JmsOperationsOutboundEventChannelAdapter(JmsOperations jmsOperations, String destination) {
        this(jmsOperations, destination, (event, headerMap, session) -> {
            TextMessage textMessage = session.createTextMessage(event);
            for (String headerKey : headerMap.keySet()) {
                textMessage.setObjectProperty(headerKey, headerMap.get(headerKey));
            }
            return textMessage;
        });
    }

    public JmsOperationsOutboundEventChannelAdapter(JmsOperations jmsOperations, String destination, JmsMessageCreator<String> messageCreator) {
        this.jmsOperations = jmsOperations;
        this.destination = destination;
        this.messageCreator = messageCreator;
    }

    public void sendEvent(String rawEvent, Map<String, Object> headerMap) {
        this.jmsOperations.send(this.destination, session -> this.getMessageCreator().toMessage(rawEvent, headerMap, session));
    }

    public JmsOperations getJmsOperations() {
        return this.jmsOperations;
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.jmsOperations = jmsOperations;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public JmsMessageCreator<String> getMessageCreator() {
        return this.messageCreator;
    }

    public void setMessageCreator(JmsMessageCreator<String> messageCreator) {
        this.messageCreator = messageCreator;
    }
}

