/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata.generator;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.CoreSamlMetadataProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataCustomizer;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public abstract class BaseSamlIdPMetadataGenerator
implements SamlIdPMetadataGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSamlIdPMetadataGenerator.class);
    protected final SamlIdPMetadataGeneratorConfigurationContext configurationContext;

    @Override
    public SamlIdPMetadataDocument generate(Optional<SamlRegisteredService> registeredService) throws Throwable {
        SamlIdPProperties idp = this.configurationContext.getCasProperties().getAuthn().getSamlIdp();
        LOGGER.debug("Preparing to generate metadata for entity id [{}]", (Object)idp.getCore().getEntityId());
        if (!this.doesMetadataExistFor(registeredService)) {
            String owner = this.getAppliesToFor(registeredService);
            LOGGER.trace("Metadata does not exist for [{}]", (Object)owner);
            if (this.shouldGenerateMetadata(registeredService)) {
                LOGGER.trace("Creating metadata artifacts for [{}]...", (Object)owner);
                SamlIdPMetadataDocument doc = this.newSamlIdPMetadataDocument();
                try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                    Callable signingCertTask = Unchecked.callable(() -> {
                        LOGGER.info("Creating self-signed certificate for signing...");
                        return this.buildSelfSignedSigningCert(registeredService);
                    });
                    Callable encryptionCertTask = Unchecked.callable(() -> {
                        LOGGER.info("Creating self-signed certificate for encryption...");
                        return this.buildSelfSignedEncryptionCert(registeredService);
                    });
                    Future signingFuture = executor.submit(signingCertTask);
                    Future encryptionFuture = executor.submit(encryptionCertTask);
                    Pair signing = (Pair)signingFuture.get();
                    Pair encryption = (Pair)encryptionFuture.get();
                    LOGGER.info("Creating SAML2 metadata for identity provider...");
                    String metadata = this.buildMetadataGeneratorParameters((Pair<String, String>)signing, (Pair<String, String>)encryption, registeredService);
                    doc.setEncryptionCertificate((String)encryption.getKey());
                    doc.setEncryptionKey((String)encryption.getValue());
                    doc.setSigningCertificate((String)signing.getKey());
                    doc.setSigningKey((String)signing.getValue());
                    doc.setMetadata(metadata);
                }
                return this.finalizeMetadataDocument(doc, registeredService);
            }
            LOGGER.debug("Skipping metadata generation process for [{}]", (Object)owner);
        }
        SamlIdPMetadataLocator samlIdPMetadataLocator = this.configurationContext.getSamlIdPMetadataLocator();
        return samlIdPMetadataLocator.fetch(registeredService);
    }

    protected boolean doesMetadataExistFor(Optional<SamlRegisteredService> registeredService) throws Throwable {
        SamlIdPMetadataLocator samlIdPMetadataLocator = this.configurationContext.getSamlIdPMetadataLocator();
        return samlIdPMetadataLocator.exists(registeredService);
    }

    protected boolean shouldGenerateMetadata(Optional<SamlRegisteredService> registeredService) {
        SamlIdPMetadataLocator samlIdPMetadataLocator = this.configurationContext.getSamlIdPMetadataLocator();
        return samlIdPMetadataLocator.shouldGenerateMetadataFor(registeredService);
    }

    public abstract Pair<String, String> buildSelfSignedEncryptionCert(Optional<SamlRegisteredService> var1) throws Throwable;

    public abstract Pair<String, String> buildSelfSignedSigningCert(Optional<SamlRegisteredService> var1) throws Throwable;

    protected SamlIdPMetadataDocument newSamlIdPMetadataDocument() {
        return new SamlIdPMetadataDocument();
    }

    protected SamlIdPMetadataDocument finalizeMetadataDocument(SamlIdPMetadataDocument doc, Optional<SamlRegisteredService> registeredService) throws Throwable {
        return doc;
    }

    protected String writeMetadata(String metadata, Optional<SamlRegisteredService> registeredService) throws Throwable {
        return metadata;
    }

    protected Pair<String, String> generateCertificateAndKey() throws Exception {
        try (StringWriter certWriter = new StringWriter();){
            Pair pair;
            try (StringWriter keyWriter = new StringWriter();){
                this.configurationContext.getSamlIdPCertificateAndKeyWriter().writeCertificateAndKey(keyWriter, certWriter);
                String encryptionKey = (String)this.configurationContext.getMetadataCipherExecutor().encode((Object)keyWriter.toString());
                pair = Pair.of((Object)certWriter.toString(), (Object)encryptionKey);
            }
            return pair;
        }
    }

    private String getIdPEndpointUrl() {
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        return resolver.resolve(this.configurationContext.getCasProperties().getServer().getPrefix().concat("/idp"));
    }

    private String buildMetadataGeneratorParameters(Pair<String, String> signing, Pair<String, String> encryption, Optional<SamlRegisteredService> registeredService) throws Throwable {
        String signingCert = SamlIdPMetadataGenerator.cleanCertificate((String)signing.getKey());
        String encryptionCert = SamlIdPMetadataGenerator.cleanCertificate((String)encryption.getKey());
        SamlIdPProperties idp = this.configurationContext.getCasProperties().getAuthn().getSamlIdp();
        try (StringWriter writer = new StringWriter();){
            SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
            String entityId = resolver.resolve(idp.getCore().getEntityId());
            String scope = resolver.resolve(this.configurationContext.getCasProperties().getServer().getScope());
            CoreSamlMetadataProperties metadataCore = idp.getMetadata().getCore();
            Object context = ((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)((IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder)IdPMetadataTemplateContext.builder().encryptionCertificate(encryptionCert)).signingCertificate(signingCert)).entityId(entityId)).scope(scope)).endpointUrl(this.getIdPEndpointUrl())).ssoServicePostBindingEnabled(metadataCore.isSsoServicePostBindingEnabled())).ssoServicePostSimpleSignBindingEnabled(metadataCore.isSsoServicePostSimpleSignBindingEnabled())).ssoServiceRedirectBindingEnabled(metadataCore.isSsoServiceRedirectBindingEnabled())).ssoServiceSoapBindingEnabled(metadataCore.isSsoServiceSoapBindingEnabled())).sloServicePostBindingEnabled(metadataCore.isSloServicePostBindingEnabled())).sloServiceRedirectBindingEnabled(metadataCore.isSloServiceRedirectBindingEnabled())).errorUrl(StringUtils.appendIfMissing((String)this.getIdPEndpointUrl(), (CharSequence)"/error", (CharSequence[])new CharSequence[0]))).build();
            Template template = this.configurationContext.getVelocityEngine().getTemplate("/template-idp-metadata.vm", StandardCharsets.UTF_8.name());
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("context", context);
            template.merge((Context)velocityContext, (Writer)writer);
            String metadata = writer.toString();
            Collection customizers = this.configurationContext.getApplicationContext().getBeansOfType(SamlIdPMetadataCustomizer.class).values();
            if (!customizers.isEmpty()) {
                OpenSamlConfigBean openSamlConfigBean = this.configurationContext.getOpenSamlConfigBean();
                EntityDescriptor entityDescriptor = (EntityDescriptor)SamlUtils.transformSamlObject((OpenSamlConfigBean)openSamlConfigBean, (String)metadata, EntityDescriptor.class);
                customizers.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).forEach(customizer -> customizer.customize(entityDescriptor, registeredService));
                metadata = SamlUtils.transformSamlObject((OpenSamlConfigBean)openSamlConfigBean, (XMLObject)entityDescriptor).toString();
            }
            this.writeMetadata(metadata, registeredService);
            String string = metadata;
            return string;
        }
    }

    @Generated
    protected BaseSamlIdPMetadataGenerator(SamlIdPMetadataGeneratorConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public SamlIdPMetadataGeneratorConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public static class IdPMetadataTemplateContext
    implements Serializable {
        private static final long serialVersionUID = -8084689071916142718L;
        private final String entityId;
        private final String scope;
        private final String endpointUrl;
        private final String errorUrl;
        private final String encryptionCertificate;
        private final String signingCertificate;
        private final boolean ssoServicePostBindingEnabled;
        private final boolean ssoServicePostSimpleSignBindingEnabled;
        private final boolean ssoServiceRedirectBindingEnabled;
        private final boolean ssoServiceSoapBindingEnabled;
        private final boolean sloServicePostBindingEnabled;
        private final boolean sloServiceRedirectBindingEnabled;

        @Generated
        protected IdPMetadataTemplateContext(IdPMetadataTemplateContextBuilder<?, ?> b) {
            this.entityId = b.entityId;
            this.scope = b.scope;
            this.endpointUrl = b.endpointUrl;
            this.errorUrl = b.errorUrl;
            this.encryptionCertificate = b.encryptionCertificate;
            this.signingCertificate = b.signingCertificate;
            this.ssoServicePostBindingEnabled = b.ssoServicePostBindingEnabled;
            this.ssoServicePostSimpleSignBindingEnabled = b.ssoServicePostSimpleSignBindingEnabled;
            this.ssoServiceRedirectBindingEnabled = b.ssoServiceRedirectBindingEnabled;
            this.ssoServiceSoapBindingEnabled = b.ssoServiceSoapBindingEnabled;
            this.sloServicePostBindingEnabled = b.sloServicePostBindingEnabled;
            this.sloServiceRedirectBindingEnabled = b.sloServiceRedirectBindingEnabled;
        }

        @Generated
        public static IdPMetadataTemplateContextBuilder<?, ?> builder() {
            return new IdPMetadataTemplateContextBuilderImpl();
        }

        @Generated
        public String getEntityId() {
            return this.entityId;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public String getEndpointUrl() {
            return this.endpointUrl;
        }

        @Generated
        public String getErrorUrl() {
            return this.errorUrl;
        }

        @Generated
        public String getEncryptionCertificate() {
            return this.encryptionCertificate;
        }

        @Generated
        public String getSigningCertificate() {
            return this.signingCertificate;
        }

        @Generated
        public boolean isSsoServicePostBindingEnabled() {
            return this.ssoServicePostBindingEnabled;
        }

        @Generated
        public boolean isSsoServicePostSimpleSignBindingEnabled() {
            return this.ssoServicePostSimpleSignBindingEnabled;
        }

        @Generated
        public boolean isSsoServiceRedirectBindingEnabled() {
            return this.ssoServiceRedirectBindingEnabled;
        }

        @Generated
        public boolean isSsoServiceSoapBindingEnabled() {
            return this.ssoServiceSoapBindingEnabled;
        }

        @Generated
        public boolean isSloServicePostBindingEnabled() {
            return this.sloServicePostBindingEnabled;
        }

        @Generated
        public boolean isSloServiceRedirectBindingEnabled() {
            return this.sloServiceRedirectBindingEnabled;
        }

        @Generated
        public static abstract class IdPMetadataTemplateContextBuilder<C extends IdPMetadataTemplateContext, B extends IdPMetadataTemplateContextBuilder<C, B>> {
            @Generated
            private String entityId;
            @Generated
            private String scope;
            @Generated
            private String endpointUrl;
            @Generated
            private String errorUrl;
            @Generated
            private String encryptionCertificate;
            @Generated
            private String signingCertificate;
            @Generated
            private boolean ssoServicePostBindingEnabled;
            @Generated
            private boolean ssoServicePostSimpleSignBindingEnabled;
            @Generated
            private boolean ssoServiceRedirectBindingEnabled;
            @Generated
            private boolean ssoServiceSoapBindingEnabled;
            @Generated
            private boolean sloServicePostBindingEnabled;
            @Generated
            private boolean sloServiceRedirectBindingEnabled;

            @Generated
            public B entityId(String entityId) {
                this.entityId = entityId;
                return this.self();
            }

            @Generated
            public B scope(String scope) {
                this.scope = scope;
                return this.self();
            }

            @Generated
            public B endpointUrl(String endpointUrl) {
                this.endpointUrl = endpointUrl;
                return this.self();
            }

            @Generated
            public B errorUrl(String errorUrl) {
                this.errorUrl = errorUrl;
                return this.self();
            }

            @Generated
            public B encryptionCertificate(String encryptionCertificate) {
                this.encryptionCertificate = encryptionCertificate;
                return this.self();
            }

            @Generated
            public B signingCertificate(String signingCertificate) {
                this.signingCertificate = signingCertificate;
                return this.self();
            }

            @Generated
            public B ssoServicePostBindingEnabled(boolean ssoServicePostBindingEnabled) {
                this.ssoServicePostBindingEnabled = ssoServicePostBindingEnabled;
                return this.self();
            }

            @Generated
            public B ssoServicePostSimpleSignBindingEnabled(boolean ssoServicePostSimpleSignBindingEnabled) {
                this.ssoServicePostSimpleSignBindingEnabled = ssoServicePostSimpleSignBindingEnabled;
                return this.self();
            }

            @Generated
            public B ssoServiceRedirectBindingEnabled(boolean ssoServiceRedirectBindingEnabled) {
                this.ssoServiceRedirectBindingEnabled = ssoServiceRedirectBindingEnabled;
                return this.self();
            }

            @Generated
            public B ssoServiceSoapBindingEnabled(boolean ssoServiceSoapBindingEnabled) {
                this.ssoServiceSoapBindingEnabled = ssoServiceSoapBindingEnabled;
                return this.self();
            }

            @Generated
            public B sloServicePostBindingEnabled(boolean sloServicePostBindingEnabled) {
                this.sloServicePostBindingEnabled = sloServicePostBindingEnabled;
                return this.self();
            }

            @Generated
            public B sloServiceRedirectBindingEnabled(boolean sloServiceRedirectBindingEnabled) {
                this.sloServiceRedirectBindingEnabled = sloServiceRedirectBindingEnabled;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "BaseSamlIdPMetadataGenerator.IdPMetadataTemplateContext.IdPMetadataTemplateContextBuilder(entityId=" + this.entityId + ", scope=" + this.scope + ", endpointUrl=" + this.endpointUrl + ", errorUrl=" + this.errorUrl + ", encryptionCertificate=" + this.encryptionCertificate + ", signingCertificate=" + this.signingCertificate + ", ssoServicePostBindingEnabled=" + this.ssoServicePostBindingEnabled + ", ssoServicePostSimpleSignBindingEnabled=" + this.ssoServicePostSimpleSignBindingEnabled + ", ssoServiceRedirectBindingEnabled=" + this.ssoServiceRedirectBindingEnabled + ", ssoServiceSoapBindingEnabled=" + this.ssoServiceSoapBindingEnabled + ", sloServicePostBindingEnabled=" + this.sloServicePostBindingEnabled + ", sloServiceRedirectBindingEnabled=" + this.sloServiceRedirectBindingEnabled + ")";
            }
        }

        @Generated
        private static final class IdPMetadataTemplateContextBuilderImpl
        extends IdPMetadataTemplateContextBuilder<IdPMetadataTemplateContext, IdPMetadataTemplateContextBuilderImpl> {
            @Generated
            private IdPMetadataTemplateContextBuilderImpl() {
            }

            @Override
            @Generated
            protected IdPMetadataTemplateContextBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public IdPMetadataTemplateContext build() {
                return new IdPMetadataTemplateContext(this);
            }
        }
    }
}

