/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.form.button;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.kendo.ui.form.button.AjaxButton;
import org.wicketstuff.kendo.ui.form.button.AjaxIndicatingButtonBehavior;
import org.wicketstuff.kendo.ui.form.button.ButtonBehavior;
import org.wicketstuff.kendo.ui.form.button.IIndicatingButton;

public class IndicatingAjaxButton
extends AjaxButton
implements IIndicatingButton {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(IndicatingAjaxButton.class);

    public IndicatingAjaxButton(String id) {
        super(id);
    }

    public IndicatingAjaxButton(String id, IModel<String> model) {
        super(id, model);
    }

    @Override
    public boolean isDisabledOnClick() {
        return false;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!"button".equalsIgnoreCase(tag.getName())) {
            LOG.warn("IndicatingAjaxButton should be applied on a 'button' tag");
        }
    }

    @Override
    public ButtonBehavior newWidgetBehavior(String selector) {
        return new AjaxIndicatingButtonBehavior(selector);
    }
}

