/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.integration.channel.AbstractExecutorChannel;
import org.springframework.integration.channel.ChannelUtils;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.integration.dispatcher.PartitionedDispatcher;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class PartitionedChannel
extends AbstractExecutorChannel {
    @Nullable
    private ThreadFactory threadFactory;

    public PartitionedChannel(int partitionCount) {
        this(partitionCount, message -> message.getHeaders().get((Object)"correlationId"));
    }

    public PartitionedChannel(int partitionCount, Function<Message<?>, Object> partitionKeyFunction) {
        super(null);
        this.dispatcher = new PartitionedDispatcher(partitionCount, partitionKeyFunction);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        Assert.notNull((Object)threadFactory, (String)"'threadFactory' must not be null");
        this.threadFactory = threadFactory;
    }

    public void setFailover(boolean failover) {
        this.getDispatcher().setFailover(failover);
    }

    public void setFailoverStrategy(Predicate<Exception> failoverStrategy) {
        this.getDispatcher().setFailoverStrategy(failoverStrategy);
    }

    public void setLoadBalancingStrategy(@Nullable LoadBalancingStrategy loadBalancingStrategy) {
        this.getDispatcher().setLoadBalancingStrategy(loadBalancingStrategy);
    }

    @Override
    protected PartitionedDispatcher getDispatcher() {
        return (PartitionedDispatcher)this.dispatcher;
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.threadFactory == null) {
            this.threadFactory = new CustomizableThreadFactory(this.getComponentName() + "-partition-thread-");
        }
        PartitionedDispatcher partitionedDispatcher = this.getDispatcher();
        partitionedDispatcher.setThreadFactory(this.threadFactory);
        if (this.maxSubscribers == null) {
            partitionedDispatcher.setMaxSubscribers(this.getIntegrationProperties().getChannelsMaxUnicastSubscribers());
        }
        partitionedDispatcher.setErrorHandler(ChannelUtils.getErrorHandler(this.getBeanFactory()));
        partitionedDispatcher.setMessageHandlingTaskDecorator(task -> {
            if (this.executorInterceptorsSize > 0) {
                return new AbstractExecutorChannel.MessageHandlingTask(this, task);
            }
            return task;
        });
    }

    @Override
    public void destroy() {
        super.destroy();
        this.getDispatcher().shutdown();
    }
}

