/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.impl.test;

import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class CleanTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanTestExecutionListener.class);

    public void afterTestClass(TestContext testContext) throws Exception {
        RepositoryService repositoryService = (RepositoryService)testContext.getApplicationContext().getBean(RepositoryService.class);
        for (Deployment deployment : repositoryService.createDeploymentQuery().list()) {
            try {
                repositoryService.deleteDeployment(deployment.getId(), true);
            }
            catch (FlowableOptimisticLockingException flowableOptimisticLockingException) {
                LOGGER.warn("Caught exception, retrying", (Throwable)flowableOptimisticLockingException);
                repositoryService.deleteDeployment(deployment.getId(), true);
            }
        }
    }
}

