/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.Message;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;

public class SignalAndMessageDefinitionExport
implements BpmnXMLConstants {
    public static void writeSignalsAndMessages(BpmnModel model, XMLStreamWriter xtw) throws Exception {
        for (Process process : model.getProcesses()) {
            for (Object flowElement : process.findFlowElementsOfType(Event.class)) {
                MessageEventDefinition messageEvent;
                Event event = (Event)flowElement;
                if (event.getEventDefinitions().isEmpty()) continue;
                EventDefinition eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
                if (eventDefinition instanceof SignalEventDefinition) {
                    SignalEventDefinition signalEvent = (SignalEventDefinition)eventDefinition;
                    if (!StringUtils.isNotEmpty((CharSequence)signalEvent.getSignalRef()) || model.containsSignalId(signalEvent.getSignalRef())) continue;
                    Signal signal = new Signal(signalEvent.getSignalRef(), signalEvent.getSignalRef());
                    model.addSignal(signal);
                    continue;
                }
                if (!(eventDefinition instanceof MessageEventDefinition) || !StringUtils.isNotEmpty((CharSequence)(messageEvent = (MessageEventDefinition)eventDefinition).getMessageRef()) || model.containsMessageId(messageEvent.getMessageRef())) continue;
                Message message = new Message(messageEvent.getMessageRef(), messageEvent.getMessageRef(), null);
                model.addMessage(message);
            }
        }
        for (Signal signal : model.getSignals()) {
            xtw.writeStartElement("signal");
            xtw.writeAttribute("id", signal.getId());
            xtw.writeAttribute("name", signal.getName());
            if (signal.getScope() != null) {
                xtw.writeAttribute("http://flowable.org/bpmn", "scope", signal.getScope());
            }
            xtw.writeEndElement();
        }
        for (Message message : model.getMessages()) {
            xtw.writeStartElement("message");
            Object messageId = message.getId();
            if (model.getTargetNamespace() != null && ((String)messageId).startsWith(model.getTargetNamespace())) {
                messageId = ((String)messageId).replace(model.getTargetNamespace(), "");
                messageId = ((String)messageId).replaceFirst(":", "");
            } else {
                for (String prefix : model.getNamespaces().keySet()) {
                    String namespace = model.getNamespace(prefix);
                    if (!((String)messageId).startsWith(namespace)) continue;
                    messageId = ((String)messageId).replace(model.getTargetNamespace(), "");
                    messageId = prefix + (String)messageId;
                }
            }
            xtw.writeAttribute("id", (String)messageId);
            if (StringUtils.isNotEmpty((CharSequence)message.getName())) {
                xtw.writeAttribute("name", message.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)message.getItemRef())) {
                String itemRef = message.getItemRef();
                for (String prefix : model.getNamespaces().keySet()) {
                    String namespace = model.getNamespace(prefix);
                    if (!itemRef.startsWith(namespace)) continue;
                    if (prefix.isEmpty()) {
                        itemRef = itemRef.replace(namespace + ":", "");
                        break;
                    }
                    itemRef = itemRef.replace(namespace, prefix);
                    break;
                }
                xtw.writeAttribute("itemRef", itemRef);
            }
            xtw.writeEndElement();
        }
    }
}

