/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wizards.any.ResultPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.panels.NotificationPanel;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AbstractWizardMgtPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public abstract class WizardMgtPanel<T extends Serializable>
extends AbstractWizardMgtPanel<T> {
    private static final long serialVersionUID = -4152438633429194882L;
    private boolean readOnly = false;
    protected final String actualId;
    private final WebMarkupContainer container;
    protected final Fragment initialFragment;
    protected final boolean wizardInModal;
    private boolean containerAutoRefresh = true;
    protected PageReference pageRef;
    protected final AjaxLink<?> addAjaxLink;
    protected Label utilityIcon;
    protected AjaxLink<?> utilityAjaxLink;
    protected ModalPanelBuilder<T> newItemPanelBuilder;
    protected NotificationPanel notificationPanel;
    protected boolean footerVisibility = false;
    protected boolean showResultPanel = false;
    private final List<Component> outerObjects = new ArrayList<Component>();
    protected final BaseModal<T> modal = new BaseModal<T>("outer"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(WizardMgtPanel.this.footerVisibility);
        }
    };

    protected WizardMgtPanel(String id) {
        this(id, false);
    }

    protected WizardMgtPanel(String id, boolean wizardInModal) {
        super(id);
        this.setOutputMarkupId(true);
        this.actualId = wizardInModal ? "content" : "wizard";
        this.wizardInModal = wizardInModal;
        this.outerObjects.add((Component)this.modal);
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupPlaceholderTag(true).setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.initialFragment = new Fragment("content", "default", (MarkupContainer)this);
        this.container.addOrReplace(new Component[]{this.initialFragment});
        this.addAjaxLink = new AjaxLink<T>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)WizardMgtPanel.this, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
                this.send((IEventSink)WizardMgtPanel.this, Broadcast.EXACT, new AjaxWizard.NewItemActionEvent(null, target));
            }
        };
        this.addAjaxLink.setEnabled(false);
        this.addAjaxLink.setVisible(false);
        this.initialFragment.addOrReplace(new Component[]{this.addAjaxLink});
        this.utilityAjaxLink = new AjaxLink<T>("utility"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)WizardMgtPanel.this, Broadcast.EXACT, new ExitEvent(target));
            }
        };
        this.utilityAjaxLink.setEnabled(false);
        this.utilityAjaxLink.setVisible(false);
        this.initialFragment.addOrReplace(new Component[]{this.utilityAjaxLink});
        this.utilityIcon = new Label("utilityIcon");
        this.utilityAjaxLink.add(new Component[]{this.utilityIcon});
        this.add(new Component[]{new ListView<Component>("outerObjectsRepeater", this.outerObjects){
            private static final long serialVersionUID = -9180479401817023838L;

            protected void populateItem(ListItem<Component> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        }});
    }

    public String getActualId() {
        return this.actualId;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ExitEvent) {
            AjaxRequestTarget target = ((ExitEvent)ExitEvent.class.cast(event.getPayload())).getTarget();
            this.modal.close((IPartialPageRequestHandler)target);
        } else if (event.getPayload() instanceof AjaxWizard.NewItemEvent) {
            boolean modalPanelAvailable;
            AjaxWizard.NewItemEvent newItemEvent = (AjaxWizard.NewItemEvent)AjaxWizard.NewItemEvent.class.cast(event.getPayload());
            Optional target = newItemEvent.getTarget();
            Serializable item = newItemEvent.getItem();
            boolean bl = modalPanelAvailable = newItemEvent.getModalPanel() != null || this.newItemPanelBuilder != null;
            if (event.getPayload() instanceof AjaxWizard.NewItemActionEvent && modalPanelAvailable) {
                WizardModalPanel modalPanel;
                if (newItemEvent.getModalPanel() == null && this.newItemPanelBuilder != null) {
                    this.newItemPanelBuilder.setItem(item);
                    modalPanel = this.newItemPanelBuilder.build(this.actualId, ((AjaxWizard.NewItemActionEvent)newItemEvent).getIndex(), item != null ? (this.isReadOnly() ? AjaxWizard.Mode.READONLY : AjaxWizard.Mode.EDIT) : AjaxWizard.Mode.CREATE);
                } else {
                    modalPanel = newItemEvent.getModalPanel();
                }
                if (this.wizardInModal) {
                    this.modal.setFormModel(item);
                    target.ifPresent(t -> t.add(new Component[]{this.modal.setContent((ModalPanel)modalPanel)}));
                    this.modal.header(Optional.ofNullable(newItemEvent.getTitleModel()).orElseGet(() -> new StringResourceModel(String.format("any.%s", newItemEvent.getEventDescription()), (Component)this, (IModel)Model.of((Serializable)modalPanel.getItem()))));
                    this.modal.show(true);
                } else {
                    Fragment fragment = new Fragment("content", "wizard", (MarkupContainer)this);
                    fragment.add(new Component[]{new Label("title", Optional.ofNullable(newItemEvent.getTitleModel()).orElseGet(() -> Model.of((Serializable)((Object)""))))});
                    fragment.add(new Component[]{(Component)Component.class.cast(modalPanel)});
                    this.container.addOrReplace(new Component[]{fragment});
                }
                target.ifPresent(this::customActionCallback);
            } else if (event.getPayload() instanceof AjaxWizard.NewItemCancelEvent) {
                if (this.wizardInModal) {
                    target.ifPresent(arg_0 -> this.modal.close(arg_0));
                } else {
                    this.container.addOrReplace(new Component[]{this.initialFragment});
                }
                target.ifPresent(this::customActionOnCancelCallback);
            } else if (event.getPayload() instanceof AjaxWizard.NewItemFinishEvent) {
                SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                target.ifPresent(t -> ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)t));
                if (this.wizardInModal && this.showResultPanel) {
                    this.modal.setContent((ModalPanel)new ResultPanel<T, Serializable>(item, ((AjaxWizard.NewItemFinishEvent)AjaxWizard.NewItemFinishEvent.class.cast(newItemEvent)).getResult()){
                        private static final long serialVersionUID = -2630573849050255233L;

                        @Override
                        protected void closeAction(AjaxRequestTarget target) {
                            WizardMgtPanel.this.modal.close((IPartialPageRequestHandler)target);
                        }

                        protected Panel customResultBody(String panelId, T item, Serializable result) {
                            return WizardMgtPanel.this.customResultBody(panelId, item, result);
                        }
                    });
                    target.ifPresent(t -> t.add(new Component[]{this.modal.getForm()}));
                } else if (this.wizardInModal) {
                    target.ifPresent(arg_0 -> this.modal.close(arg_0));
                } else {
                    this.container.addOrReplace(new Component[]{this.initialFragment});
                }
                target.ifPresent(this::customActionOnFinishCallback);
            }
            if (this.containerAutoRefresh) {
                target.ifPresent(t -> t.add(new Component[]{this.container}));
            }
        }
        super.onEvent(event);
    }

    protected final WizardMgtPanel<T> disableContainerAutoRefresh() {
        this.containerAutoRefresh = false;
        return this;
    }

    protected Panel customResultBody(String panelId, T item, Serializable result) {
        return new Panel(panelId){
            private static final long serialVersionUID = 5538299138211283825L;
        };
    }

    protected final WizardMgtPanel<T> enableUtilityButton() {
        this.utilityAjaxLink.setEnabled(true);
        this.utilityAjaxLink.setVisible(true);
        return this;
    }

    public MarkupContainer addInnerObject(Component ... childs) {
        return this.initialFragment.add(childs);
    }

    public MarkupContainer addOrReplaceInnerObject(Component ... childs) {
        return this.initialFragment.addOrReplace(childs);
    }

    public final WizardMgtPanel<T> addOuterObject(Component ... childs) {
        this.outerObjects.addAll(List.of(childs));
        return this;
    }

    public <B extends ModalPanelBuilder<T>> WizardMgtPanel<T> setPageRef(PageReference pageRef) {
        this.pageRef = pageRef;
        return this;
    }

    public <B extends ModalPanelBuilder<T>> WizardMgtPanel<T> setShowResultPanel(boolean showResultPanel) {
        this.showResultPanel = showResultPanel;
        return this;
    }

    protected <B extends ModalPanelBuilder<T>> WizardMgtPanel<T> addNewItemPanelBuilder(B panelBuilder, boolean newItemDefaultButtonEnabled) {
        this.newItemPanelBuilder = panelBuilder;
        if (this.newItemPanelBuilder != null) {
            this.addAjaxLink.setEnabled(newItemDefaultButtonEnabled);
            this.addAjaxLink.setVisible(newItemDefaultButtonEnabled);
            this.newItemPanelBuilder.setEventSink((IEventSink)this);
        }
        return this;
    }

    protected WizardMgtPanel<T> addNotificationPanel(NotificationPanel notificationPanel) {
        this.notificationPanel = notificationPanel;
        return this;
    }

    public WizardMgtPanel<T> setFooterVisibility(boolean footerVisibility) {
        this.footerVisibility = footerVisibility;
        return this;
    }

    protected void setWindowClosedReloadCallback(BaseModal<?> modal) {
        modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> modal.show(false));
    }

    protected void customActionCallback(AjaxRequestTarget target) {
    }

    protected void customActionOnFinishCallback(AjaxRequestTarget target) {
    }

    protected void customActionOnCancelCallback(AjaxRequestTarget target) {
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public static class ExitEvent {
        private final AjaxRequestTarget target;

        public ExitEvent(AjaxRequestTarget target) {
            this.target = target;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }

    public static abstract class Builder<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1908836274665387084L;
        protected final PageReference pageRef;
        private ModalPanelBuilder<T> newItemPanelBuilder;
        private boolean newItemDefaultButtonEnabled = true;
        private NotificationPanel notificationPanel;
        private boolean showResultPage = false;
        private boolean wizardInModal = false;

        protected Builder(PageReference pageRef) {
            this.pageRef = pageRef;
        }

        protected abstract WizardMgtPanel<T> newInstance(String var1, boolean var2);

        public WizardMgtPanel<T> build(String id) {
            return this.newInstance(id, this.wizardInModal).setPageRef(this.pageRef).setShowResultPanel(this.showResultPage).addNewItemPanelBuilder(this.newItemPanelBuilder, this.newItemDefaultButtonEnabled).addNotificationPanel(this.notificationPanel);
        }

        public void setShowResultPage(boolean showResultPage) {
            this.showResultPage = showResultPage;
        }

        public Builder<T> addNewItemPanelBuilder(ModalPanelBuilder<T> panelBuilder) {
            this.newItemPanelBuilder = panelBuilder;
            return this;
        }

        public Builder<T> addNewItemPanelBuilder(ModalPanelBuilder<T> panelBuilder, boolean newItemDefaultButtonEnabled) {
            this.newItemDefaultButtonEnabled = newItemDefaultButtonEnabled;
            return this.addNewItemPanelBuilder(panelBuilder);
        }

        public Builder<T> addNotificationPanel(NotificationPanel notificationPanel) {
            this.notificationPanel = notificationPanel;
            return this;
        }

        public Builder<T> setWizardInModal(boolean wizardInModal) {
            this.wizardInModal = wizardInModal;
            return this;
        }
    }
}

