/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.DefaultAuthenticationResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.Ticket;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenPasswordGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenPasswordGrantRequestExtractor.class);

    public AccessTokenPasswordGrantRequestExtractor(OAuth20ConfigurationContext oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    @Override
    public AccessTokenRequestContext extractRequest(WebContext context) throws Throwable {
        CallContext callContext = new CallContext(context, this.getConfigurationContext().getSessionStore());
        String clientId = (String)this.getConfigurationContext().getRequestParameterResolver().resolveClientIdAndClientSecret(callContext).getKey();
        LOGGER.debug("Locating OAuth registered service by client id [{}]", (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), clientId);
        LOGGER.debug("Located OAuth registered service [{}]", (Object)registeredService);
        ProfileManager manager = new ProfileManager(context, this.getConfigurationContext().getSessionStore());
        UserProfile profile = (UserProfile)manager.getProfile().orElseThrow(() -> UnauthorizedServiceException.denied((String)"OAuth user profile cannot be determined"));
        LOGGER.debug("Creating matching service request based on [{}]", (Object)registeredService);
        boolean requireServiceHeader = this.getConfigurationContext().getCasProperties().getAuthn().getOauth().getGrants().getResourceOwner().isRequireServiceHeader();
        Service service = this.getConfigurationContext().getAuthenticationBuilder().buildService(registeredService, context, requireServiceHeader);
        LOGGER.debug("Authenticating the OAuth request indicated by [{}]", (Object)service);
        Authentication authentication = this.getConfigurationContext().getAuthenticationBuilder().build(profile, registeredService, context, service);
        AuditableContext audit = AuditableContext.builder().service(service).authentication(authentication).registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.getConfigurationContext().getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        DefaultAuthenticationResult result = new DefaultAuthenticationResult(authentication, (Service)(requireServiceHeader ? service : null));
        Ticket ticketGrantingTicket = this.getConfigurationContext().getCentralAuthenticationService().createTicketGrantingTicket((AuthenticationResult)result);
        Set scopes = this.getConfigurationContext().getRequestParameterResolver().resolveRequestScopes(context);
        scopes.retainAll(Objects.requireNonNull(registeredService).getScopes());
        return AccessTokenRequestContext.builder().scopes(scopes).service(service).authentication(authentication).registeredService(registeredService).grantType(this.getGrantType()).ticketGrantingTicket(ticketGrantingTicket).generateRefreshToken(registeredService.isGenerateRefreshToken()).build();
    }

    public boolean supports(WebContext context) {
        String grantType = this.getConfigurationContext().getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    public OAuth20ResponseTypes getResponseType() {
        return null;
    }

    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.PASSWORD;
    }

    public boolean requestMustBeAuthenticated() {
        return true;
    }
}

