/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.form.SyncopeForm;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.beans.ExecSpecs;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.persistence.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationReporter;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class TaskLogic
extends AbstractExecutableLogic<TaskTO> {
    protected final TaskDAO taskDAO;
    protected final TaskExecDAO taskExecDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final NotificationDAO notificationDAO;
    protected final TaskDataBinder binder;
    protected final PropagationTaskExecutor taskExecutor;
    protected final NotificationJobDelegate notificationJobDelegate;
    protected final TaskUtilsFactory taskUtilsFactory;

    public TaskLogic(JobManager jobManager, SyncopeTaskScheduler scheduler, JobStatusDAO jobStatusDAO, TaskDAO taskDAO, TaskExecDAO taskExecDAO, ExternalResourceDAO resourceDAO, NotificationDAO notificationDAO, TaskDataBinder binder, PropagationTaskExecutor taskExecutor, NotificationJobDelegate notificationJobDelegate, TaskUtilsFactory taskUtilsFactory) {
        super(jobManager, scheduler, jobStatusDAO);
        this.taskDAO = taskDAO;
        this.taskExecDAO = taskExecDAO;
        this.resourceDAO = resourceDAO;
        this.notificationDAO = notificationDAO;
        this.binder = binder;
        this.taskExecutor = taskExecutor;
        this.notificationJobDelegate = notificationJobDelegate;
        this.taskUtilsFactory = taskUtilsFactory;
    }

    protected void securityChecks(String entitlement, String realm) {
        block3: {
            block2: {
                Set authRealms = AuthContextUtils.getAuthorizations().getOrDefault(entitlement, Set.of());
                if (authRealms.isEmpty()) break block2;
                if (!authRealms.stream().noneMatch(realm::startsWith)) break block3;
            }
            throw new DelegatedAdministrationException(realm, MacroTask.class.getSimpleName(), null);
        }
    }

    @PreAuthorize(value="hasRole('TASK_CREATE')")
    public <T extends SchedTaskTO> T createSchedTask(TaskType type, T taskTO) {
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(taskTO);
        if (taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(type) + ", expected " + String.valueOf(taskUtils.getType()));
            throw sce;
        }
        if (taskUtils.getType() == TaskType.MACRO) {
            this.securityChecks("TASK_CREATE", ((MacroTaskTO)taskTO).getRealm());
        }
        SchedTask task = (SchedTask)this.taskDAO.save((Entity)this.binder.createSchedTask(taskTO, taskUtils));
        try {
            this.jobManager.register(task, AuthContextUtils.getUsername());
        }
        catch (Exception e) {
            LOG.error("While registering job for task {}", (Object)task.getKey(), (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return (T)((SchedTaskTO)this.binder.getTaskTO((Task)task, taskUtils, false));
    }

    @PreAuthorize(value="hasRole('TASK_UPDATE')")
    public <T extends SchedTaskTO> T updateSchedTask(TaskType type, SchedTaskTO taskTO) {
        SchedTask task = (SchedTask)this.taskDAO.findById(type, taskTO.getKey()).orElseThrow(() -> new NotFoundException("Task " + taskTO.getKey()));
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance((Task)task);
        if (taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(type) + ", expected " + String.valueOf(taskUtils.getType()));
            throw sce;
        }
        if (taskUtils.getType() == TaskType.MACRO) {
            this.securityChecks("TASK_UPDATE", ((MacroTask)task).getRealm().getFullPath());
            this.securityChecks("TASK_UPDATE", ((MacroTaskTO)taskTO).getRealm());
        }
        this.binder.updateSchedTask(task, taskTO, taskUtils);
        task = (SchedTask)this.taskDAO.save((Entity)task);
        try {
            if (task.isActive()) {
                this.jobManager.register(task, AuthContextUtils.getUsername());
            } else {
                this.jobManager.unregister((Task)task);
            }
        }
        catch (Exception e) {
            LOG.error("While (un)registering job for task {}", (Object)task.getKey(), (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return (T)((SchedTaskTO)this.binder.getTaskTO((Task)task, taskUtils, false));
    }

    @PreAuthorize(value="hasRole('TASK_LIST')")
    @Transactional(readOnly=true)
    public <T extends TaskTO> Page<T> search(TaskType type, String resource, String notification, AnyTypeKind anyTypeKind, String entityKey, Pageable pageable, boolean details) {
        try {
            if (type == null) {
                throw new IllegalArgumentException("type is required");
            }
            ExternalResource resourceObj = resource == null ? null : (ExternalResource)this.resourceDAO.findById(resource).orElseThrow(() -> new IllegalArgumentException("Missing ExternalResource: " + resource));
            Notification notificationObj = notification == null ? null : (Notification)this.notificationDAO.findById(notification).orElseThrow(() -> new IllegalArgumentException("Missing Notification: " + notification));
            long count = this.taskDAO.count(type, resourceObj, notificationObj, anyTypeKind, entityKey);
            List<TaskTO> result = this.taskDAO.findAll(type, resourceObj, notificationObj, anyTypeKind, entityKey, pageable).stream().map(task -> this.binder.getTaskTO(task, this.taskUtilsFactory.getInstance(type), details)).toList();
            return new SyncopePage(result, pageable, count);
        }
        catch (IllegalArgumentException | InvalidDataAccessApiUsageException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('TASK_READ')")
    @Transactional(readOnly=true)
    public <T extends TaskTO> T read(TaskType type, String key, boolean details) {
        Task task = (Task)this.taskDAO.findById(type, key).orElseThrow(() -> new NotFoundException("Task " + key));
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(task);
        if (type != null && taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(type) + ", expected " + String.valueOf(taskUtils.getType()));
            throw sce;
        }
        if (taskUtils.getType() == TaskType.MACRO) {
            this.securityChecks("TASK_READ", ((MacroTask)task).getRealm().getFullPath());
        }
        return (T)this.binder.getTaskTO(task, this.taskUtilsFactory.getInstance(task), details);
    }

    @PreAuthorize(value="hasRole('TASK_READ')")
    @Transactional(readOnly=true)
    public SyncopeForm getMacroTaskForm(String key, Locale locale) {
        MacroTask task = this.taskDAO.findById(TaskType.MACRO, key).filter(MacroTask.class::isInstance).map(MacroTask.class::cast).orElseThrow(() -> new NotFoundException("MacroTask " + key));
        this.securityChecks("TASK_READ", task.getRealm().getFullPath());
        return this.binder.getMacroTaskForm(task, locale);
    }

    protected ExecTO doExecute(Task<?> task, OffsetDateTime startAt, boolean dryRun, Map<String, Object> additionalDataMap) {
        if (startAt != null && startAt.isBefore(OffsetDateTime.now())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add("Cannot schedule in the past");
            throw sce;
        }
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(task);
        String executor = AuthContextUtils.getUsername();
        ExecTO result = null;
        switch (taskUtils.getType()) {
            case PROPAGATION: {
                PropagationTask propagationTask = (PropagationTask)task;
                PropagationTaskInfo taskInfo = new PropagationTaskInfo(propagationTask.getResource(), propagationTask.getOperation(), new ObjectClass(propagationTask.getObjectClassName()), propagationTask.getAnyTypeKind(), propagationTask.getAnyType(), propagationTask.getEntityKey(), propagationTask.getConnObjectKey(), propagationTask.getPropagationData());
                taskInfo.setKey(propagationTask.getKey());
                taskInfo.setOldConnObjectKey(propagationTask.getOldConnObjectKey());
                TaskExec propExec = this.taskExecutor.execute(taskInfo, (PropagationReporter)new DefaultPropagationReporter(), executor);
                result = this.binder.getExecTO(propExec);
                break;
            }
            case NOTIFICATION: {
                TaskExec notExec = this.notificationJobDelegate.executeSingle((NotificationTask)task, executor);
                result = this.binder.getExecTO(notExec);
                break;
            }
            case SCHEDULED: 
            case LIVE_SYNC: 
            case PULL: 
            case PUSH: 
            case MACRO: {
                if (!((SchedTask)task).isActive()) {
                    SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
                    sce.getElements().add("Task " + task.getKey() + " is not active");
                    throw sce;
                }
                if (taskUtils.getType() == TaskType.MACRO) {
                    this.securityChecks("TASK_EXECUTE", ((MacroTask)task).getRealm().getFullPath());
                }
                try {
                    this.jobManager.execute((SchedTask)task, Optional.ofNullable(startAt).orElseGet(OffsetDateTime::now), executor, dryRun, additionalDataMap);
                }
                catch (Exception e) {
                    LOG.error("While executing task {}", task, (Object)e);
                    SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
                    sce.getElements().add(e.getMessage());
                    throw sce;
                }
                result = new ExecTO();
                result.setJobType(JobType.TASK);
                result.setRefKey(task.getKey());
                result.setRefDesc(this.binder.buildRefDesc(task));
                result.setStart(OffsetDateTime.now());
                result.setExecutor(executor);
                result.setStatus("JOB_FIRED");
                result.setMessage("Job fired; waiting for results...");
                break;
            }
        }
        return result;
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public ExecTO execute(ExecSpecs specs) {
        Task task = (Task)this.taskDAO.findById(specs.getKey()).orElseThrow(() -> new NotFoundException("Task " + specs.getKey()));
        return this.doExecute(task, specs.getStartAt(), specs.getDryRun(), Map.of());
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public ExecTO execute(ExecSpecs specs, SyncopeForm macroTaskForm) {
        MacroTask task = this.taskDAO.findById(specs.getKey()).filter(MacroTask.class::isInstance).map(MacroTask.class::cast).orElseThrow(() -> new NotFoundException("MacroTask " + specs.getKey()));
        return this.doExecute((Task<?>)task, specs.getStartAt(), specs.getDryRun(), (Map<String, Object>)Map.of("macroTaskForm", macroTaskForm));
    }

    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public <T extends TaskTO> T delete(TaskType type, String key) {
        Task task = (Task)this.taskDAO.findById(type, key).orElseThrow(() -> new NotFoundException("Task " + key));
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(task);
        if (type != null && taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(type) + ", expected " + String.valueOf(taskUtils.getType()));
            throw sce;
        }
        if (taskUtils.getType() == TaskType.MACRO) {
            this.securityChecks("TASK_DELETE", ((MacroTask)task).getRealm().getFullPath());
        }
        TaskTO taskToDelete = this.binder.getTaskTO(task, taskUtils, true);
        if (TaskType.SCHEDULED == taskUtils.getType() || TaskType.LIVE_SYNC == taskUtils.getType() || TaskType.PULL == taskUtils.getType() || TaskType.PUSH == taskUtils.getType() || TaskType.MACRO == taskUtils.getType()) {
            this.jobManager.unregister(task);
        }
        this.taskDAO.delete((Entity)task);
        return (T)taskToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_READ')")
    public Page<ExecTO> listExecutions(String key, OffsetDateTime before, OffsetDateTime after, Pageable pageable) {
        Task task = (Task)this.taskDAO.findById(key).orElseThrow(() -> new NotFoundException("Task " + key));
        if (task instanceof MacroTask) {
            MacroTask macroTask = (MacroTask)task;
            this.securityChecks("TASK_READ", macroTask.getRealm().getFullPath());
        }
        long count = this.taskExecDAO.count(task, before, after);
        List<ExecTO> result = this.taskExecDAO.findAll(task, before, after, pageable).stream().map(arg_0 -> ((TaskDataBinder)this.binder).getExecTO(arg_0)).toList();
        return new SyncopePage(result, pageable, count);
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_LIST')")
    public List<ExecTO> listRecentExecutions(int max) {
        return this.taskExecDAO.findRecent(max).stream().map(exec -> {
            try {
                Task patt0$temp = exec.getTask();
                if (patt0$temp instanceof MacroTask) {
                    MacroTask macroTask = (MacroTask)patt0$temp;
                    this.securityChecks("TASK_DELETE", macroTask.getRealm().getFullPath());
                }
                return this.binder.getExecTO(exec);
            }
            catch (DelegatedAdministrationException e) {
                LOG.error("Skip executions for command task", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public ExecTO deleteExecution(String execKey) {
        TaskExec exec = (TaskExec)this.taskExecDAO.findById(execKey).orElseThrow(() -> new NotFoundException("Task execution " + execKey));
        Task task = exec.getTask();
        if (task instanceof MacroTask) {
            MacroTask macroTask = (MacroTask)task;
            this.securityChecks("TASK_DELETE", macroTask.getRealm().getFullPath());
        }
        ExecTO executionToDelete = this.binder.getExecTO(exec);
        this.taskExecDAO.delete((Entity)exec);
        return executionToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public List<BatchResponseItem> deleteExecutions(String key, OffsetDateTime before, OffsetDateTime after) {
        Task task = (Task)this.taskDAO.findById(key).orElseThrow(() -> new NotFoundException("Task " + key));
        ArrayList<BatchResponseItem> batchResponseItems = new ArrayList<BatchResponseItem>();
        this.taskExecDAO.findAll(task, before, after, Pageable.unpaged()).forEach(exec -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", List.of(exec.getKey()));
            batchResponseItems.add(item);
            try {
                Task patt0$temp = exec.getTask();
                if (patt0$temp instanceof MacroTask) {
                    MacroTask macroTask = (MacroTask)patt0$temp;
                    this.securityChecks("TASK_DELETE", macroTask.getRealm().getFullPath());
                }
                this.taskExecDAO.delete((Entity)exec);
                item.setStatus(Response.Status.OK.getStatusCode());
            }
            catch (Exception e) {
                LOG.error("Error deleting execution {} of task {}", new Object[]{exec.getKey(), key, e});
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setContent(ExceptionUtils2.getFullStackTrace((Throwable)e));
            }
        });
        return batchResponseItems;
    }

    @Override
    protected Triple<JobType, String, String> getReference(String jobName) {
        return JobNamer.getTaskKeyFromJobName((String)jobName).flatMap(arg_0 -> ((TaskDAO)this.taskDAO).findById(arg_0)).filter(SchedTask.class::isInstance).map(t -> Triple.of((Object)JobType.TASK, (Object)t.getKey(), (Object)this.binder.buildRefDesc(t))).orElse(null);
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_LIST')")
    public List<JobTO> listJobs() {
        return super.doListJobs(true);
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_READ')")
    public JobTO getJob(String key) {
        Task task = (Task)this.taskDAO.findById(key).orElseThrow(() -> new NotFoundException("Task " + key));
        if (task instanceof MacroTask) {
            MacroTask macroTask = (MacroTask)task;
            this.securityChecks("TASK_READ", macroTask.getRealm().getFullPath());
        }
        return this.getJobTO(JobNamer.getJobName((Task)task), false).orElseThrow(() -> new NotFoundException("Job for task " + key));
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public void actionJob(String key, JobAction action) {
        Task task = (Task)this.taskDAO.findById(key).orElseThrow(() -> new NotFoundException("Task " + key));
        if (task instanceof MacroTask) {
            MacroTask macroTask = (MacroTask)task;
            this.securityChecks("TASK_EXECUTE", macroTask.getRealm().getFullPath());
        }
        this.doActionJob(JobNamer.getJobName((Task)task), action);
    }

    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public List<PropagationTaskTO> purgePropagations(OffsetDateTime since, List<ExecStatus> statuses, List<String> resources) {
        return this.taskDAO.purgePropagations(since, statuses, resources);
    }

    @Override
    protected TaskTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args) && !"deleteExecution".equals(method.getName()) && !"readExecution".equals(method.getName())) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof TaskTO)) continue;
                TaskTO taskTO = (TaskTO)object;
                key = taskTO.getKey();
            }
        }
        if (key != null) {
            String taskKey = key;
            try {
                Task task = (Task)this.taskDAO.findById(taskKey).orElseThrow(() -> new NotFoundException("Task " + taskKey));
                return this.binder.getTaskTO(task, this.taskUtilsFactory.getInstance(task), false);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

