/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.jstl.fmt;

import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.jstl.fmt.JakartaInline;
import jakarta.servlet.jsp.jstl.fmt.LocalizationContext;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocaleSupport {
    public static String getLocalizedMessage(PageContext pageContext, String key) {
        return LocaleSupport.getLocalizedMessage(pageContext, key, null, null);
    }

    public static String getLocalizedMessage(PageContext pageContext, String key, String basename) {
        return LocaleSupport.getLocalizedMessage(pageContext, key, null, basename);
    }

    public static String getLocalizedMessage(PageContext pageContext, String key, Object[] args) {
        return LocaleSupport.getLocalizedMessage(pageContext, key, args, null);
    }

    public static String getLocalizedMessage(PageContext pageContext, String key, Object[] args, String basename) {
        ResourceBundle bundle;
        LocalizationContext locCtxt = null;
        String message = "???" + key + "???";
        locCtxt = basename != null ? JakartaInline.getLocalizationContext(pageContext, basename) : JakartaInline.getLocalizationContext(pageContext);
        if (locCtxt != null && (bundle = locCtxt.getResourceBundle()) != null) {
            try {
                message = bundle.getString(key);
                if (args != null) {
                    MessageFormat formatter = new MessageFormat("");
                    if (locCtxt.getLocale() != null) {
                        formatter.setLocale(locCtxt.getLocale());
                    }
                    formatter.applyPattern(message);
                    message = formatter.format(args);
                }
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        return message;
    }
}

