/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared;

import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.myfaces.core.api.shared.ParametrizableFacesMessage;
import org.apache.myfaces.core.api.shared.lang.ClassUtils;

public class MessageUtils {
    private static final String DETAIL_SUFFIX = "_detail";

    public static void addErrorMessage(FacesContext facesContext, UIComponent component, String messageId) {
        facesContext.addMessage(component.getClientId(facesContext), MessageUtils.getMessage(facesContext, facesContext.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, messageId, null));
    }

    public static void addErrorMessage(FacesContext facesContext, UIComponent component, String messageId, Object[] args) {
        facesContext.addMessage(component.getClientId(facesContext), MessageUtils.getMessage(facesContext, facesContext.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, messageId, args));
    }

    public static void addErrorMessage(FacesContext facesContext, UIComponent component, Throwable cause) {
        facesContext.addMessage(component.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_ERROR, cause.getLocalizedMessage(), cause.getLocalizedMessage()));
    }

    public static FacesMessage getErrorMessage(FacesContext facesContext, String messageId, Object[] args) {
        return MessageUtils.getMessage(facesContext, facesContext.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, messageId, args);
    }

    public static FacesMessage getMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId, Object[] args) {
        String detail;
        ResourceBundle appBundle;
        String summary;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((summary = MessageUtils.getBundleString(appBundle = MessageUtils.getApplicationBundle(facesContext, locale), messageId)) != null) {
            detail = MessageUtils.getBundleString(appBundle, messageId + DETAIL_SUFFIX);
        } else {
            ResourceBundle defBundle = MessageUtils.getDefaultBundle(facesContext, locale);
            summary = MessageUtils.getBundleString(defBundle, messageId);
            if (summary != null) {
                detail = MessageUtils.getBundleString(defBundle, messageId + DETAIL_SUFFIX);
            } else {
                detail = MessageUtils.getBundleString(appBundle, messageId + DETAIL_SUFFIX);
                if (detail != null) {
                    summary = null;
                } else {
                    detail = MessageUtils.getBundleString(defBundle, messageId + DETAIL_SUFFIX);
                    if (detail != null) {
                        summary = null;
                    } else {
                        facesContext.getExternalContext().log("No message with id " + messageId + " found in any bundle");
                        return new FacesMessage(severity, messageId, null);
                    }
                }
            }
        }
        if (args != null && args.length > 0) {
            return new ParametrizableFacesMessage(severity, summary, detail, args, locale);
        }
        return new FacesMessage(severity, summary, detail);
    }

    private static String getBundleString(ResourceBundle bundle, String key) {
        try {
            if (bundle != null && bundle.containsKey(key)) {
                return bundle.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    private static ResourceBundle getApplicationBundle(FacesContext facesContext, Locale locale) {
        String bundleName = facesContext.getApplication().getMessageBundle();
        return bundleName != null ? MessageUtils.getBundle(facesContext, locale, bundleName) : null;
    }

    private static ResourceBundle getDefaultBundle(FacesContext facesContext, Locale locale) {
        return MessageUtils.getBundle(facesContext, locale, "jakarta.faces.Messages");
    }

    private static ResourceBundle getBundle(FacesContext facesContext, Locale locale, String bundleName) {
        ResourceBundle.Control bundleControl = (ResourceBundle.Control)facesContext.getExternalContext().getApplicationMap().get("org.apache.myfaces.RESOURCE_BUNDLE_CONTROL");
        try {
            if (bundleControl == null) {
                return ResourceBundle.getBundle(bundleName, locale, facesContext.getClass().getClassLoader());
            }
            return ResourceBundle.getBundle(bundleName, locale, facesContext.getClass().getClassLoader(), bundleControl);
        }
        catch (MissingResourceException ignore1) {
            try {
                if (bundleControl == null) {
                    return ResourceBundle.getBundle(bundleName, locale, MessageUtils.class.getClassLoader());
                }
                return ResourceBundle.getBundle(bundleName, locale, MessageUtils.class.getClassLoader(), bundleControl);
            }
            catch (MissingResourceException ignore2) {
                try {
                    ClassLoader cl = ClassUtils.getContextClassLoader();
                    if (bundleControl == null) {
                        return ResourceBundle.getBundle(bundleName, locale, cl);
                    }
                    return ResourceBundle.getBundle(bundleName, locale, cl, bundleControl);
                }
                catch (MissingResourceException damned) {
                    facesContext.getExternalContext().log("resource bundle " + bundleName + " could not be found");
                    return null;
                }
            }
        }
    }

    public static Object getLabel(FacesContext facesContext, UIComponent component) {
        Object label = component.getAttributes().get("label");
        ValueExpression expression = null;
        if (label != null && label instanceof String && ((String)label).length() == 0 && (expression = component.getValueExpression("label")) != null) {
            label = null;
        }
        if (label != null) {
            return label;
        }
        ValueExpression valueExpression = expression = expression == null ? component.getValueExpression("label") : expression;
        if (expression != null) {
            return expression;
        }
        return component.getClientId(facesContext);
    }
}

