/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.tomitribe.swizzle.stream.FilteredInputStream;
import org.tomitribe.swizzle.stream.ScanBuffer;

public class DelimitedTokenWatchInputStream
extends FilteredInputStream {
    private final Consumer<String> consumer;
    private final String begin;
    private final String end;
    private final boolean caseSensitive;
    private final boolean includeDelimiters;
    private Strategy strategy;

    public DelimitedTokenWatchInputStream(InputStream in, String begin, String end, Runnable runnable) {
        this(in, begin, end, (String s) -> runnable.run());
    }

    public DelimitedTokenWatchInputStream(InputStream in, String begin, String end, boolean caseSensitive, boolean includeDelimiters, Runnable runnable) {
        this(in, begin, end, caseSensitive, includeDelimiters, (String s) -> runnable.run());
    }

    public DelimitedTokenWatchInputStream(InputStream in, String begin, String end, Consumer<String> consumer) {
        this(in, begin, end, true, false, consumer);
    }

    public DelimitedTokenWatchInputStream(InputStream in, String begin, String end, boolean caseSensitive, boolean includeDelimiters, Consumer<String> consumer) {
        super(in);
        this.caseSensitive = caseSensitive;
        this.consumer = consumer;
        this.begin = begin;
        this.end = end;
        this.includeDelimiters = includeDelimiters;
        this.strategy = new FindStart();
    }

    @Override
    public int read() throws IOException {
        return this.strategy.read();
    }

    private int superRead() throws IOException {
        return super.read();
    }

    public int done() {
        this.strategy = () -> -1;
        return -1;
    }

    private class FindEnd
    implements Strategy {
        final StringBuilder token = new StringBuilder();
        private final ScanBuffer endBuffer = new ScanBuffer(DelimitedTokenWatchInputStream.access$500(DelimitedTokenWatchInputStream.this), DelimitedTokenWatchInputStream.access$200(DelimitedTokenWatchInputStream.this));

        public FindEnd() {
            this.endBuffer.flush();
        }

        @Override
        public int read() throws IOException {
            int stream = DelimitedTokenWatchInputStream.this.superRead();
            if (stream == -1) {
                return DelimitedTokenWatchInputStream.this.done();
            }
            this.token.append((char)stream);
            this.endBuffer.append(stream);
            if (this.endBuffer.match()) {
                DelimitedTokenWatchInputStream.this.strategy = new FindStart();
                String substring = this.token.substring(0, this.token.length() - this.endBuffer.size());
                if (DelimitedTokenWatchInputStream.this.includeDelimiters) {
                    DelimitedTokenWatchInputStream.this.consumer.accept(DelimitedTokenWatchInputStream.this.begin + substring + DelimitedTokenWatchInputStream.this.end);
                } else {
                    DelimitedTokenWatchInputStream.this.consumer.accept(substring);
                }
            }
            return stream;
        }
    }

    private class FindStart
    implements Strategy {
        private final ScanBuffer beginBuffer;

        private FindStart() {
            this.beginBuffer = new ScanBuffer(DelimitedTokenWatchInputStream.this.begin, DelimitedTokenWatchInputStream.this.caseSensitive);
        }

        @Override
        public int read() throws IOException {
            if (this.beginBuffer.size() == 0) {
                DelimitedTokenWatchInputStream.this.strategy = new FindEnd();
                return DelimitedTokenWatchInputStream.this.strategy.read();
            }
            int stream = DelimitedTokenWatchInputStream.this.superRead();
            if (stream == -1) {
                return DelimitedTokenWatchInputStream.this.done();
            }
            this.beginBuffer.append(stream);
            if (this.beginBuffer.match()) {
                DelimitedTokenWatchInputStream.this.strategy = new FindEnd();
            }
            return stream;
        }
    }

    @FunctionalInterface
    static interface Strategy {
        public int read() throws IOException;
    }
}

