/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.security;

import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.ServletContext;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Container;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.openejb.assembler.classic.PolicyContext;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomee.catalina.security.HTTPMethods;
import org.apache.tomee.catalina.security.URLPattern;
import org.apache.tomee.catalina.security.UncheckedItem;

public class TomcatSecurityConstaintsToJaccPermissionsTransformer {
    final StandardContext standardContext;
    private final List<SecurityConstraint> constraints;
    private final List<String> declaredRoles;
    private final boolean isDenyUncoveredHttpMethods;
    private final PolicyContext policyContext;
    private final Set<String> securityRoles = new HashSet<String>();
    private final Map<String, URLPattern> uncheckedPatterns = new HashMap<String, URLPattern>();
    private final Map<UncheckedItem, HTTPMethods> uncheckedResourcePatterns = new HashMap<UncheckedItem, HTTPMethods>();
    private final Map<UncheckedItem, HTTPMethods> uncheckedUserPatterns = new HashMap<UncheckedItem, HTTPMethods>();
    private final Map<String, URLPattern> excludedPatterns = new HashMap<String, URLPattern>();
    private final Map<String, Map<String, URLPattern>> rolesPatterns = new HashMap<String, Map<String, URLPattern>>();
    private final Set<URLPattern> allSet = new HashSet<URLPattern>();
    private final Map<String, URLPattern> allMap = new HashMap<String, URLPattern>();

    public TomcatSecurityConstaintsToJaccPermissionsTransformer(StandardContext standardContext) {
        this.standardContext = standardContext;
        this.constraints = new ArrayList<SecurityConstraint>(Arrays.asList(standardContext.findConstraints()));
        this.declaredRoles = Arrays.asList(standardContext.findSecurityRoles());
        this.isDenyUncoveredHttpMethods = standardContext.getDenyUncoveredHttpMethods();
        ServletContext servletContext = standardContext.getServletContext();
        String id = servletContext.getVirtualServerName() + " " + servletContext.getContextPath();
        this.policyContext = new PolicyContext(id);
    }

    public PolicyContext createResourceAndDataPermissions() {
        this.securityRoles.addAll(this.declaredRoles);
        for (Container container : this.standardContext.findChildren()) {
            if (!(container instanceof Wrapper)) continue;
            this.processRoleRefPermissions((Wrapper)container);
        }
        this.addUnmappedJSPPermissions();
        this.analyzeSecurityConstraints();
        this.removeExcludedDups();
        this.buildPermissions();
        return this.policyContext;
    }

    private void analyzeSecurityConstraints() {
        for (SecurityConstraint securityConstraint : this.constraints) {
            boolean isRoleBasedPattern;
            Map<String, URLPattern> currentPatterns = null;
            HashSet<String> roleNames = null;
            if (securityConstraint.getAuthConstraint()) {
                if (securityConstraint.findAuthRoles().length == 0) {
                    currentPatterns = this.excludedPatterns;
                } else {
                    roleNames = new HashSet<String>(Arrays.asList(securityConstraint.findAuthRoles()));
                    if (roleNames.remove("*")) {
                        roleNames.addAll(this.securityRoles);
                    }
                }
            } else {
                currentPatterns = this.uncheckedPatterns;
            }
            String transport = securityConstraint.getUserConstraint() == null ? "NONE" : securityConstraint.getUserConstraint();
            boolean bl = isRoleBasedPattern = currentPatterns == null;
            if (securityConstraint.findCollections() == null) continue;
            for (SecurityCollection webResourceCollection : securityConstraint.findCollections()) {
                for (String urlPattern : webResourceCollection.findPatterns()) {
                    String[] httpMethods;
                    boolean omission;
                    if (isRoleBasedPattern) {
                        for (String roleName : roleNames) {
                            Map<String, URLPattern> currentRolePatterns = this.rolesPatterns.get(roleName);
                            if (currentRolePatterns == null) {
                                currentRolePatterns = new HashMap<String, URLPattern>();
                                this.rolesPatterns.put(roleName, currentRolePatterns);
                            }
                            boolean omission2 = false;
                            String[] httpMethods2 = webResourceCollection.findMethods();
                            if (httpMethods2.length == 0) {
                                omission2 = true;
                                httpMethods2 = webResourceCollection.findOmittedMethods();
                            }
                            this.analyzeURLPattern(urlPattern, new HashSet<String>(Arrays.asList(httpMethods2)), omission2, transport, currentRolePatterns);
                        }
                    } else {
                        boolean omission3 = false;
                        String[] httpMethods3 = webResourceCollection.findMethods();
                        if (httpMethods3.length == 0) {
                            omission3 = true;
                            httpMethods3 = webResourceCollection.findOmittedMethods();
                        }
                        this.analyzeURLPattern(urlPattern, new HashSet<String>(Arrays.asList(httpMethods3)), omission3, transport, currentPatterns);
                    }
                    URLPattern allPattern = this.allMap.get(urlPattern);
                    if (allPattern == null) {
                        omission = false;
                        httpMethods = webResourceCollection.findMethods();
                        if (httpMethods.length == 0) {
                            omission = true;
                            httpMethods = webResourceCollection.findOmittedMethods();
                        }
                        allPattern = new URLPattern(urlPattern, new HashSet<String>(Arrays.asList(httpMethods)), omission);
                        this.allSet.add(allPattern);
                        this.allMap.put(urlPattern, allPattern);
                        continue;
                    }
                    omission = false;
                    httpMethods = webResourceCollection.findMethods();
                    if (httpMethods.length == 0) {
                        omission = true;
                        httpMethods = webResourceCollection.findOmittedMethods();
                    }
                    allPattern.addMethods(new HashSet<String>(Arrays.asList(httpMethods)), omission);
                }
            }
        }
    }

    private void analyzeURLPattern(String urlPattern, Set<String> httpMethods, boolean omission, String transport, Map<String, URLPattern> currentPatterns) {
        URLPattern pattern = currentPatterns.get(urlPattern);
        if (pattern == null) {
            pattern = new URLPattern(urlPattern, httpMethods, omission);
            currentPatterns.put(urlPattern, pattern);
        } else {
            pattern.addMethods(httpMethods, omission);
        }
        pattern.setTransport(transport);
    }

    private void removeExcludedDups() {
        for (Map.Entry<String, URLPattern> excluded : this.excludedPatterns.entrySet()) {
            String url = excluded.getKey();
            URLPattern pattern = excluded.getValue();
            this.removeExcluded(url, pattern, this.uncheckedPatterns);
            for (Map<String, URLPattern> rolePatterns : this.rolesPatterns.values()) {
                this.removeExcluded(url, pattern, rolePatterns);
            }
        }
    }

    private void removeExcluded(String url, URLPattern pattern, Map<String, URLPattern> patterns) {
        URLPattern testPattern = patterns.get(url);
        if (testPattern != null && !testPattern.removeMethods(pattern)) {
            patterns.remove(url);
        }
    }

    private void buildPermissions() {
        HTTPMethods methods;
        Object actions;
        String name;
        for (URLPattern uRLPattern : this.excludedPatterns.values()) {
            name = uRLPattern.getQualifiedPattern(this.allSet);
            actions = uRLPattern.getMethods();
            this.policyContext.getExcludedPermissions().add((Permission)new WebResourcePermission(name, (String)actions));
            this.policyContext.getExcludedPermissions().add((Permission)new WebUserDataPermission(name, (String)actions));
        }
        for (Map.Entry entry : this.rolesPatterns.entrySet()) {
            HashSet<URLPattern> currentRolePatterns = new HashSet<URLPattern>(((Map)entry.getValue()).values());
            for (URLPattern pattern : ((Map)entry.getValue()).values()) {
                String name2 = pattern.getQualifiedPattern(currentRolePatterns);
                String actions2 = pattern.getMethods();
                WebResourcePermission permission = new WebResourcePermission(name2, actions2);
                this.policyContext.addRole((String)entry.getKey(), (Permission)permission);
                HTTPMethods methods3 = pattern.getHTTPMethods();
                int transportType = pattern.getTransport();
                this.addOrUpdatePattern(this.uncheckedUserPatterns, name2, methods3, transportType);
            }
        }
        for (URLPattern uRLPattern : this.uncheckedPatterns.values()) {
            name = uRLPattern.getQualifiedPattern(this.allSet);
            HTTPMethods methods2 = uRLPattern.getHTTPMethods();
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, name, methods2, 0);
            int transportType = uRLPattern.getTransport();
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name, methods2, transportType);
        }
        for (URLPattern uRLPattern : this.allSet) {
            name = uRLPattern.getQualifiedPattern(this.allSet);
            HTTPMethods methods2 = uRLPattern.getComplementedHTTPMethods();
            if (methods2.isNone()) continue;
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, name, methods2, 0);
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name, methods2, 0);
        }
        if (!this.allMap.containsKey("/")) {
            URLPattern pattern = new URLPattern("/", Collections.emptySet(), false);
            String string = pattern.getQualifiedPattern(this.allSet);
            methods = pattern.getComplementedHTTPMethods();
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, string, methods, 0);
            this.addOrUpdatePattern(this.uncheckedUserPatterns, string, methods, 0);
        }
        for (UncheckedItem uncheckedItem : this.uncheckedResourcePatterns.keySet()) {
            methods = this.uncheckedResourcePatterns.get(uncheckedItem);
            actions = URLPattern.getMethodsWithTransport(methods, uncheckedItem.getTransportType());
            this.policyContext.getUncheckedPermissions().add((Permission)new WebResourcePermission(uncheckedItem.getName(), (String)actions));
        }
        for (UncheckedItem uncheckedItem : this.uncheckedUserPatterns.keySet()) {
            methods = this.uncheckedUserPatterns.get(uncheckedItem);
            actions = URLPattern.getMethodsWithTransport(methods, uncheckedItem.getTransportType());
            this.policyContext.getUncheckedPermissions().add((Permission)new WebUserDataPermission(uncheckedItem.getName(), (String)actions));
        }
    }

    private void addOrUpdatePattern(Map<UncheckedItem, HTTPMethods> patternMap, String name, HTTPMethods actions, int transportType) {
        UncheckedItem item = new UncheckedItem(name, transportType);
        HTTPMethods existingActions = patternMap.get(item);
        if (existingActions != null) {
            patternMap.put(item, existingActions.add(actions));
        } else {
            patternMap.put(item, new HTTPMethods(actions, false));
        }
    }

    protected void processRoleRefPermissions(Wrapper servlet) {
        String servletName = servlet.getName();
        HashSet<String> unmappedRoles = new HashSet<String>(this.securityRoles);
        for (String securityRoleRef : servlet.findSecurityReferences()) {
            this.policyContext.addRole(servlet.findSecurityReference(securityRoleRef), (Permission)new WebRoleRefPermission(servletName, securityRoleRef));
            unmappedRoles.remove(securityRoleRef);
        }
        for (String roleName : unmappedRoles) {
            this.policyContext.addRole(roleName, (Permission)new WebRoleRefPermission(servletName, roleName));
        }
    }

    protected void addUnmappedJSPPermissions() {
        for (String roleName : this.securityRoles) {
            this.policyContext.addRole(roleName, (Permission)new WebRoleRefPermission("", roleName));
        }
    }
}

