/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security;

import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.CertStoreCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.callback.PrivateKeyCallback;
import jakarta.security.auth.message.callback.SecretKeyCallback;
import jakarta.security.auth.message.callback.TrustStoreCallback;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;

public class ConnectorCallbackHandler
implements CallbackHandler {
    private Principal callerPrincipal;
    private String[] groupsArray;
    private final String securityRealmName;

    public ConnectorCallbackHandler(String securityRealmName) {
        this.securityRealmName = securityRealmName;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof CallerPrincipalCallback) {
                this.callerPrincipal = ((CallerPrincipalCallback)callback).getPrincipal();
                continue;
            }
            if (callback instanceof GroupPrincipalCallback) {
                this.groupsArray = ((GroupPrincipalCallback)callback).getGroups();
                continue;
            }
            if (callback instanceof PasswordValidationCallback) {
                PasswordValidationCallback passwordValidationCallback = (PasswordValidationCallback)callback;
                String userName = passwordValidationCallback.getUsername();
                char[] password = passwordValidationCallback.getPassword();
                SecurityService securityService = SystemInstance.get().getComponent(SecurityService.class);
                try {
                    Object loginObj = securityService.login(this.securityRealmName, userName, password == null ? "" : new String(password));
                    securityService.associate(loginObj);
                    this.callerPrincipal = securityService.getCallerPrincipal();
                    passwordValidationCallback.setResult(true);
                }
                catch (LoginException e) {
                    passwordValidationCallback.setResult(false);
                }
                continue;
            }
            if (callback instanceof CertStoreCallback || callback instanceof PrivateKeyCallback || callback instanceof SecretKeyCallback || callback instanceof TrustStoreCallback) continue;
            throw new UnsupportedCallbackException(callback);
        }
    }

    public Principal getCallerPrincipal() {
        return this.callerPrincipal;
    }

    public List<String> getGroups() {
        return this.groupsArray == null ? null : Arrays.asList(this.groupsArray);
    }
}

