/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.List;
import org.apache.wicket.core.request.handler.ListenerRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.mapper.AbstractComponentMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.ComponentInfo;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.info.PageInfo;

public class PageInstanceMapper
extends AbstractComponentMapper {
    @Override
    public IRequestHandler mapRequest(Request request) {
        Url url;
        PageComponentInfo info;
        if (this.matches(request) && (info = this.getPageComponentInfo(url = request.getUrl())) != null && info.getPageInfo().getPageId() != null) {
            Integer renderCount;
            Integer n = renderCount = info.getComponentInfo() != null ? info.getComponentInfo().getRenderCount() : null;
            if (info.getComponentInfo() == null) {
                PageProvider provider = new PageProvider(info.getPageInfo().getPageId(), renderCount);
                provider.setPageSource(this.getContext());
                return new RenderPageRequestHandler(provider);
            }
            ComponentInfo componentInfo = info.getComponentInfo();
            PageAndComponentProvider provider = new PageAndComponentProvider((int)info.getPageInfo().getPageId(), renderCount, componentInfo.getComponentPath());
            provider.setPageSource(this.getContext());
            return new ListenerRequestHandler(provider, componentInfo.getBehaviorId());
        }
        return null;
    }

    @Override
    public Url mapHandler(IRequestHandler requestHandler) {
        PageComponentInfo info = null;
        if (requestHandler instanceof RenderPageRequestHandler) {
            IRequestablePage page = ((RenderPageRequestHandler)requestHandler).getPage();
            PageInfo i = new PageInfo(page.getPageId());
            info = new PageComponentInfo(i, null);
        } else if (requestHandler instanceof ListenerRequestHandler) {
            ListenerRequestHandler handler = (ListenerRequestHandler)requestHandler;
            IRequestablePage page = handler.getPage();
            String componentPath = handler.getComponentPath();
            Integer renderCount = null;
            if (handler.includeRenderCount()) {
                renderCount = page.getRenderCount();
            }
            PageInfo pageInfo = new PageInfo(page.getPageId());
            ComponentInfo componentInfo = new ComponentInfo(renderCount, componentPath, handler.getBehaviorIndex());
            info = new PageComponentInfo(pageInfo, componentInfo);
        }
        if (info != null) {
            Url url = new Url();
            url.getSegments().add(this.getContext().getNamespace());
            url.getSegments().add(this.getContext().getPageIdentifier());
            this.encodePageComponentInfo(url, info);
            return url;
        }
        return null;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        int score = 0;
        if (this.matches(request)) {
            score = Integer.MAX_VALUE;
        }
        return score;
    }

    private boolean matches(Request request) {
        boolean matches = false;
        Url url = request.getUrl();
        Url baseUrl = request.getClientUrl();
        String namespace = this.getContext().getNamespace();
        String pageIdentifier = this.getContext().getPageIdentifier();
        List<String> segments = url.getSegments();
        if (this.isNotPageInstanceUrl(segments, pageIdentifier)) {
            return false;
        }
        if (this.urlStartsWith(url, namespace, pageIdentifier)) {
            matches = true;
        } else if (this.urlStartsWith(baseUrl, namespace, pageIdentifier) && this.urlStartsWith(url, pageIdentifier)) {
            matches = true;
        } else if (this.urlStartsWith(baseUrl, pageIdentifier) && this.urlStartsWith(url, pageIdentifier)) {
            matches = true;
        }
        return matches;
    }

    private boolean isNotPageInstanceUrl(List<String> segments, String pageIdentifier) {
        if (segments.size() > 2) {
            return true;
        }
        int pageIdIndex = segments.indexOf(pageIdentifier);
        return pageIdIndex < 0 || segments.size() - 1 > pageIdIndex;
    }
}

