/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import org.apache.wicket.Component;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.IPageRendererProvider;
import org.apache.wicket.IRequestCycleProvider;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.BookmarkableListenerRequestHandler;
import org.apache.wicket.core.request.handler.BookmarkablePageRequestHandler;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.ListenerRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.feedback.ExactLevelFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackCollector;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupParser;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.internal.Enclosure;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.mock.MockApplication;
import org.apache.wicket.mock.MockPageManager;
import org.apache.wicket.mock.MockRequestParameters;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.protocol.http.AjaxEnclosureListener;
import org.apache.wicket.protocol.http.IMetaDataBufferingWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.mock.CookieCollection;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.protocol.http.mock.MockHttpServletResponse;
import org.apache.wicket.protocol.http.mock.MockHttpSession;
import org.apache.wicket.protocol.http.mock.MockServletContext;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebResponse;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.request.handler.render.PageRenderer;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.IRequestMapperDelegate;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.tester.ComponentInPage;
import org.apache.wicket.util.tester.DiffUtil;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.Result;
import org.apache.wicket.util.tester.TagTester;
import org.apache.wicket.util.tester.WicketTesterHelper;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWicketTester {
    private static final Logger log = LoggerFactory.getLogger(BaseWicketTester.class);
    private final ServletContext servletContext;
    private final WebApplication application;
    private final List<MockHttpServletRequest> previousRequests = Generics.newArrayList();
    private final List<MockHttpServletResponse> previousResponses = Generics.newArrayList();
    private MockHttpSession httpSession;
    private boolean followRedirects = true;
    private int redirectCount;
    private MockHttpServletRequest lastRequest;
    private MockHttpServletResponse lastResponse;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private Session session;
    private RequestCycle requestCycle;
    private Page lastRenderedPage;
    private boolean exposeExceptions = true;
    private boolean useRequestUrlAsBase = true;
    private IRequestHandler forcedHandler;
    private IFeedbackMessageFilter originalFeedbackMessageCleanupFilter;
    private ComponentInPage componentInPage;
    private Map<String, String> preHeader;

    public BaseWicketTester() {
        this(new MockApplication());
    }

    public <C extends Page> BaseWicketTester(final Class<C> homePage) {
        this(new MockApplication(){

            @Override
            public Class<? extends Page> getHomePage() {
                return homePage;
            }
        });
    }

    public BaseWicketTester(WebApplication application) {
        this(application, (ServletContext)null);
    }

    public BaseWicketTester(WebApplication application, String servletContextBasePath) {
        this(application, new MockServletContext(application, servletContextBasePath));
    }

    public BaseWicketTester(WebApplication application, ServletContext servletCtx) {
        this(application, servletCtx, true);
    }

    public BaseWicketTester(WebApplication application, boolean init) {
        this(application, null, init);
    }

    public BaseWicketTester(WebApplication application, ServletContext servletCtx, boolean init) {
        if (!init) {
            Args.notNull(application, "application");
        }
        ServletContext servletContext = servletCtx != null ? servletCtx : (this.servletContext = !init && application.getServletContext() != null ? application.getServletContext() : new MockServletContext(application, null));
        if (application.getWicketFilter() == null) {
            final TestFilterConfig filterConfig = new TestFilterConfig();
            WicketFilter filter = new WicketFilter(){

                @Override
                public FilterConfig getFilterConfig() {
                    return filterConfig;
                }
            };
            application.setWicketFilter(filter);
        }
        this.httpSession = new MockHttpSession(this.servletContext);
        ThreadContext.detach();
        this.application = application;
        ThreadContext.setApplication(application);
        if (init) {
            if (application.getName() == null) {
                application.setName("WicketTesterApplication-" + UUID.randomUUID());
            }
            application.setServletContext(this.servletContext);
            application.initApplication();
        }
        application.getResourceSettings().setResourcePollFrequency(this.getResourcePollFrequency());
        application.setPageRendererProvider(new LastPageRecordingPageRendererProvider(application.getPageRendererProvider()));
        application.setRequestCycleProvider(new TestRequestCycleProvider(application.getRequestCycleProvider()));
        this.originalFeedbackMessageCleanupFilter = application.getApplicationSettings().getFeedbackMessageCleanupFilter();
        application.getApplicationSettings().setFeedbackMessageCleanupFilter(IFeedbackMessageFilter.NONE);
        IPageManagerProvider pageManagerProvider = this.newTestPageManagerProvider();
        if (pageManagerProvider != null) {
            application.setPageManagerProvider(pageManagerProvider);
        }
        application.getSessionStore().registerUnboundListener(sessionId -> this.newSession());
        this.setupNextRequestCycle();
    }

    protected Duration getResourcePollFrequency() {
        return null;
    }

    protected IPageManagerProvider newTestPageManagerProvider() {
        return new TestPageManagerProvider();
    }

    public Page getLastRenderedPage() {
        return this.lastRenderedPage;
    }

    private void setupNextRequestCycle() {
        boolean assignBaseLocation;
        this.request = new MockHttpServletRequest(this.application, this.httpSession, this.servletContext, this.servletRequestLocale());
        this.request.setURL(this.request.getContextPath() + this.request.getServletPath() + "/");
        boolean bl = assignBaseLocation = this.lastRequest != null && this.lastRequest.getHeader("Wicket-Ajax") == null;
        if (assignBaseLocation) {
            this.request.setScheme(this.lastRequest.getScheme());
            this.request.setSecure(this.lastRequest.isSecure());
            this.request.setServerName(this.lastRequest.getServerName());
            this.request.setServerPort(this.lastRequest.getServerPort());
        }
        this.response = new MockHttpServletResponse(this.request);
        if (this.lastResponse != null) {
            List<Cookie> lastResponseCookies = this.lastResponse.getCookies();
            if (this.lastResponse.isRedirect()) {
                CookieCollection responseCookies = new CookieCollection();
                responseCookies.addAll(lastResponseCookies);
                for (Cookie cookie : responseCookies.allAsList()) {
                    this.response.addCookie(cookie);
                }
                if (this.lastRequest != null) {
                    CookieCollection requestCookies = new CookieCollection();
                    requestCookies.addAll(this.lastRequest.getCookies());
                    this.request.addCookies(requestCookies.asList());
                }
            } else {
                CookieCollection cookies = new CookieCollection();
                if (this.lastRequest != null) {
                    cookies.addAll(this.lastRequest.getCookies());
                }
                cookies.addAll(lastResponseCookies);
                this.request.addCookies(cookies.asList());
            }
        }
        ServletWebRequest servletWebRequest = this.newServletWebRequest();
        this.requestCycle = this.application.createRequestCycle(servletWebRequest, this.newServletWebResponse(servletWebRequest));
        ThreadContext.setRequestCycle(this.requestCycle);
        if (this.session == null) {
            this.newSession();
        }
    }

    protected Locale servletRequestLocale() {
        return Locale.getDefault();
    }

    public void cleanupFeedbackMessages() {
        this.cleanupFeedbackMessages(this.originalFeedbackMessageCleanupFilter);
    }

    public void clearFeedbackMessages() {
        this.cleanupFeedbackMessages(IFeedbackMessageFilter.ALL);
    }

    protected void cleanupFeedbackMessages(final IFeedbackMessageFilter filter) {
        IVisitor<Component, Void> clearer = new IVisitor<Component, Void>(){

            @Override
            public void component(Component component, IVisit<Void> visit) {
                if (component.hasFeedbackMessage()) {
                    component.getFeedbackMessages().clear(filter);
                }
            }
        };
        clearer.component(this.getLastRenderedPage(), null);
        this.getLastRenderedPage().visitChildren(clearer);
        this.getSession().getFeedbackMessages().clear(filter);
    }

    protected Response newServletWebResponse(ServletWebRequest servletWebRequest) {
        return new WicketTesterServletWebResponse(servletWebRequest, this.response);
    }

    private ServletWebRequest newServletWebRequest() {
        return (ServletWebRequest)this.application.newWebRequest(this.request, this.request.getFilterPrefix());
    }

    private void newSession() {
        ThreadContext.setSession(null);
        this.session = Session.get();
    }

    public MockHttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(MockHttpServletRequest request) {
        this.request = request;
        this.applyRequest();
    }

    public void setLastResponse(MockHttpServletResponse response) {
        this.lastResponse = response;
    }

    public Session getSession() {
        return this.session;
    }

    public MockHttpSession getHttpSession() {
        return this.httpSession;
    }

    public WebApplication getApplication() {
        return this.application;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void destroy() {
        try {
            ThreadContext.setApplication(this.application);
            this.application.internalDestroy();
        }
        finally {
            ThreadContext.detach();
        }
    }

    public boolean processRequest() {
        return this.processRequest(null, null);
    }

    public boolean processRequest(MockHttpServletRequest request) {
        return this.processRequest(request, null);
    }

    public boolean processRequest(MockHttpServletRequest request, IRequestHandler forcedRequestHandler) {
        return this.processRequest(request, forcedRequestHandler, false);
    }

    public boolean processRequest(IRequestHandler forcedRequestHandler) {
        return this.processRequest(null, forcedRequestHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRequest(MockHttpServletRequest forcedRequest, IRequestHandler forcedRequestHandler, boolean redirect) {
        if (forcedRequest != null) {
            this.request = forcedRequest;
        }
        this.forcedHandler = forcedRequestHandler;
        if (!redirect && this.getRequest().getHeader("Wicket-Ajax") == null) {
            this.lastRenderedPage = null;
        }
        if (this.request != null && this.preHeader != null) {
            for (Map.Entry<String, String> entry : this.preHeader.entrySet()) {
                if (Strings.isEmpty(entry.getKey())) continue;
                this.request.setHeader(entry.getKey(), entry.getValue());
            }
            this.preHeader = null;
        }
        this.applyRequest();
        this.requestCycle.scheduleRequestHandlerAfterCurrent(null);
        try {
            if (!this.requestCycle.processRequestAndDetach()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.recordRequestResponse();
            this.setupNextRequestCycle();
        }
        try {
            if (this.isFollowRedirects() && this.lastResponse.isRedirect()) {
                if (this.redirectCount++ >= 100) {
                    throw new AssertionError((Object)"Possible infinite redirect detected. Bailing out.");
                }
                Url newUrl = Url.parse(this.lastResponse.getRedirectLocation(), Charset.forName(this.request.getCharacterEncoding()));
                if (this.isExternalRedirect(this.lastRequest.getUrl(), newUrl)) {
                    boolean entry = true;
                    return entry;
                }
                if (newUrl.isFull() || newUrl.isContextAbsolute()) {
                    this.request.setUrl(newUrl);
                    String protocol = newUrl.getProtocol();
                    if (protocol != null) {
                        this.request.setScheme(protocol);
                    }
                    this.request.setSecure("https".equals(protocol));
                    if (newUrl.getHost() != null) {
                        this.request.setServerName(newUrl.getHost());
                    }
                    if (newUrl.getPort() != null) {
                        this.request.setServerPort(newUrl.getPort());
                    }
                } else {
                    Url mergedURL = new Url(this.lastRequest.getUrl().getSegments(), newUrl.getQueryParameters());
                    mergedURL.concatSegments(newUrl.getSegments());
                    this.request.setUrl(mergedURL);
                }
                this.processRequest(null, null, true);
                --this.redirectCount;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.redirectCount = 0;
        }
    }

    private boolean isExternalRedirect(Url requestUrl, Url newUrl) {
        String originalHost = requestUrl.getHost();
        String redirectHost = newUrl.getHost();
        Integer originalPort = requestUrl.getPort();
        Integer newPort = newUrl.getPort();
        if (originalHost.equals(redirectHost)) {
            return false;
        }
        if (redirectHost == null) {
            return false;
        }
        if (!originalPort.equals(newPort)) {
            return true;
        }
        return !redirectHost.equals(originalHost);
    }

    public final void addRequestHeader(String key, String value) {
        Args.notEmpty(key, "key");
        if (this.preHeader == null) {
            this.preHeader = Generics.newHashMap();
        }
        this.preHeader.put(key, value);
    }

    private void recordRequestResponse() {
        this.lastRequest = this.request;
        this.setLastResponse(this.response);
        this.previousRequests.add(this.request);
        this.previousResponses.add(this.response);
    }

    public Page startPage(IPageProvider pageProvider) {
        this.componentInPage = null;
        this.request.setURL(this.request.getContextPath() + this.request.getServletPath() + "/");
        RenderPageRequestHandler handler = new RenderPageRequestHandler(pageProvider);
        this.processRequest(this.request, handler);
        return this.getLastRenderedPage();
    }

    public <T extends Page> T startPage(T page) {
        return (T)this.startPage(new PageProvider(page));
    }

    public ResourceReference startResource(final IResource resource) {
        return this.startResourceReference(new ResourceReference("testResourceReference"){
            private static final long serialVersionUID = 1L;

            @Override
            public IResource getResource() {
                return resource;
            }
        });
    }

    public ResourceReference startResourceReference(ResourceReference reference) {
        return this.startResourceReference(reference, null);
    }

    public ResourceReference startResourceReference(ResourceReference reference, PageParameters pageParameters) {
        this.request.setURL(this.request.getContextPath() + this.request.getServletPath() + "/");
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(reference, pageParameters);
        this.processRequest(this.request, handler);
        return reference;
    }

    public MockHttpServletResponse getLastResponse() {
        return this.lastResponse;
    }

    public String getLastResponseAsString() {
        String response = this.lastResponse.getDocument();
        if (this.componentInPage == null) {
            return response;
        }
        int end = response.lastIndexOf("</body>");
        if (end > -1) {
            int start = response.indexOf("<body>") + "<body>".length();
            response = response.substring(start, end);
        }
        return response;
    }

    public String getWicketAjaxBaseUrlEncodedInLastResponse() throws IOException, ParseException {
        XmlTag tag;
        XmlPullParser parser = new XmlPullParser();
        parser.parse(this.getLastResponseAsString());
        while ((tag = parser.nextTag()) != null) {
            if (!tag.isOpen() || !tag.getName().equals("script") || !"wicket-ajax-base-url".equals(tag.getAttribute("id"))) continue;
            parser.next();
            return parser.getString().toString().split("\\\"")[1];
        }
        Assertions.fail((String)"Last response has no AJAX base URL set by AbstractDefaultAjaxBehavior.");
        return null;
    }

    public List<MockHttpServletRequest> getPreviousRequests() {
        return this.previousRequests;
    }

    public List<MockHttpServletResponse> getPreviousResponses() {
        return this.previousResponses;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public Url urlFor(IRequestHandler handler) {
        Url url = this.application.getRootRequestMapper().mapHandler(handler);
        return this.transform(url);
    }

    public String urlFor(Link<?> link) {
        Args.notNull(link, "link");
        Url url = Url.parse(link.urlForListener(new PageParameters()).toString());
        return this.transform(url).toString();
    }

    public void executeListener(Component component) {
        Args.notNull(component, "component");
        Page page = component.getPage();
        PageAndComponentProvider pageAndComponentProvider = new PageAndComponentProvider((IRequestablePage)page, component);
        IPageRequestHandler handler = null;
        handler = page.isPageStateless() || page.isBookmarkable() && page.wasCreatedBookmarkable() ? new BookmarkableListenerRequestHandler(pageAndComponentProvider) : new ListenerRequestHandler(pageAndComponentProvider);
        Url url = this.urlFor(handler);
        this.request.setUrl(url);
        this.processRequest(this.request, null);
    }

    public void invokeListener(Component component) {
        Args.notNull(component, "component");
        ListenerRequestHandler handler = new ListenerRequestHandler(new PageAndComponentProvider((IRequestablePage)component.getPage(), component));
        this.processRequest(handler);
    }

    public void invokeListener(Component component, Behavior behavior) {
        Args.notNull(component, "component");
        Args.notNull(behavior, "behavior");
        ListenerRequestHandler handler = new ListenerRequestHandler(new PageAndComponentProvider((IRequestablePage)component.getPage(), component), component.getBehaviorId(behavior));
        this.processRequest(handler);
    }

    public void executeBehavior(AbstractAjaxBehavior behavior) {
        Args.notNull(behavior, "behavior");
        Url url = Url.parse(behavior.getCallbackUrl().toString(), Charset.forName(this.request.getCharacterEncoding()));
        this.transform(url);
        this.request.setUrl(url);
        this.request.addHeader("Origin", this.createOriginHeader());
        this.request.addHeader("Wicket-Ajax-BaseURL", url.toString());
        this.request.addHeader("Wicket-Ajax", "true");
        if (behavior instanceof AjaxFormSubmitBehavior) {
            AjaxFormSubmitBehavior formSubmitBehavior = (AjaxFormSubmitBehavior)behavior;
            Form<?> form = formSubmitBehavior.getForm();
            this.getRequest().setUseMultiPartContentType(form.isMultiPart());
            this.serializeFormToRequest(form);
            String name = Form.getRootFormRelativeId((Component)new PropertyModel(behavior, "component").getObject());
            if (!this.request.getPostParameters().getParameterNames().contains(name)) {
                this.request.getPostParameters().setParameterValue(name, "marked");
            }
        }
        this.processRequest();
    }

    protected String createOriginHeader() {
        Url url = RequestCycle.get().getRequest().getUrl();
        return url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
    }

    public Url urlFor(AjaxLink<?> link) {
        AjaxEventBehavior behavior = WicketTesterHelper.findAjaxEventBehavior(link, "click");
        Url url = Url.parse(behavior.getCallbackUrl().toString(), Charset.forName(this.request.getCharacterEncoding()));
        return this.transform(url);
    }

    public void executeAjaxUrl(Url url) {
        Args.notNull(url, "url");
        this.transform(url);
        this.request.setUrl(url);
        this.request.addHeader("Wicket-Ajax-BaseURL", url.toString());
        this.request.addHeader("Wicket-Ajax", "true");
        this.processRequest();
    }

    public final <C extends Page> C startPage(Class<C> pageClass) {
        return this.startPage(pageClass, null);
    }

    public final <C extends Page> C startPage(Class<C> pageClass, PageParameters parameters) {
        Args.notNull(pageClass, "pageClass");
        this.componentInPage = null;
        this.request.setUrl(this.application.getRootRequestMapper().mapHandler(new BookmarkablePageRequestHandler(new PageProvider(pageClass, parameters))));
        this.processRequest();
        return (C)this.getLastRenderedPage();
    }

    public FormTester newFormTester(String path) {
        return this.newFormTester(path, true);
    }

    public FormTester newFormTester(String path, boolean fillBlankString) {
        return new FormTester(path, (Form)this.getComponentFromLastRenderedPage(path), this, fillBlankString);
    }

    public final <C extends Component> C startComponentInPage(Class<C> componentClass) {
        return (C)this.startComponentInPage((C)((Object)componentClass), null);
    }

    public final <C extends Component> C startComponentInPage(Class<C> componentClass, IMarkupFragment pageMarkup) {
        Args.notNull(componentClass, "componentClass");
        Component comp = null;
        try {
            Constructor<C> c = componentClass.getConstructor(String.class);
            comp = (Component)c.newInstance("testObject");
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            Assertions.fail((String)String.format("Cannot instantiate component with type '%s' because of '%s'", componentClass.getName(), e.getMessage()));
        }
        Component started = this.startComponentInPage(comp, pageMarkup);
        this.componentInPage.isInstantiated = true;
        return (C)started;
    }

    public final <C extends Component> C startComponentInPage(C component) {
        return this.startComponentInPage(component, null);
    }

    public final <C extends Component> C startComponentInPage(C component, IMarkupFragment pageMarkup) {
        Args.notNull(component, "component");
        Page page = this.createPage();
        if (page == null) {
            Assertions.fail((String)"The automatically created page should not be null.");
        }
        if (pageMarkup == null) {
            String markup = this.createPageMarkup(component.getId());
            if (markup == null) {
                Assertions.fail((String)"The markup for the automatically created page should not be null.");
            }
            try {
                ContainerInfo containerInfo = new ContainerInfo(page);
                MarkupResourceStream markupResourceStream = new MarkupResourceStream(new StringResourceStream((CharSequence)markup), containerInfo, page.getClass());
                MarkupParser markupParser = this.getApplication().getMarkupSettings().getMarkupFactory().newMarkupParser(markupResourceStream);
                pageMarkup = markupParser.parse();
            }
            catch (Exception e) {
                String errorMessage = "Error while parsing the markup for the autogenerated page: " + e.getMessage();
                log.error(errorMessage, e);
                Assertions.fail((String)errorMessage);
            }
        }
        if (page instanceof StartComponentInPage) {
            ((StartComponentInPage)page).setPageMarkup(pageMarkup);
        } else {
            page.setMarkup(pageMarkup);
        }
        page.add(component);
        this.startPage(page);
        this.componentInPage = new ComponentInPage();
        this.componentInPage.component = component;
        return component;
    }

    protected String createPageMarkup(String componentId) {
        return "<html><head></head><body><span wicket:id='" + componentId + "'></span></body></html>";
    }

    protected Page createPage() {
        return new StartComponentInPage();
    }

    public Component getComponentFromLastRenderedPage(String path, boolean wantVisibleInHierarchy) {
        return this.getComponentFromLastRenderedPage(path, wantVisibleInHierarchy, true);
    }

    public Component getComponentFromLastRenderedPage(String path, boolean wantVisibleInHierarchy, boolean failOnAbsent) {
        Component component;
        String componentIdPageId;
        if (this.componentInPage != null && this.componentInPage.isInstantiated && !((String)path).startsWith(componentIdPageId = this.componentInPage.component.getId() + ":")) {
            path = componentIdPageId + (String)path;
        }
        if ((component = this.getLastRenderedPage().get((String)path)) == null) {
            if (failOnAbsent) {
                Assertions.fail((String)("path: '" + (String)path + "' does not exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())));
            }
            return null;
        }
        if (!wantVisibleInHierarchy || component.isVisibleInHierarchy()) {
            return component;
        }
        return null;
    }

    public Component getComponentFromLastRenderedPage(String path) {
        return this.getComponentFromLastRenderedPage(path, true);
    }

    public Result hasLabel(String path, String expectedLabelText) {
        Label label = (Label)this.getComponentFromLastRenderedPage(path);
        return this.isEqual(expectedLabelText, label.getDefaultModelObjectAsString());
    }

    public <C extends Component> Result isComponent(String path, Class<C> expectedComponentClass) {
        Component component = this.assertExists(path);
        return this.isTrue("component '" + Classes.name(component.getClass()) + "' is not of type: " + Classes.name(expectedComponentClass), expectedComponentClass.isAssignableFrom(component.getClass()));
    }

    public Result isVisible(String path) {
        Component component = this.getComponentFromLastRenderedPage(path, false);
        Result result = component == null ? Result.fail("path: '" + path + "' does not exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())) : this.isTrue("component '" + path + "' is not visible", component.isVisibleInHierarchy());
        return result;
    }

    public Result isInvisible(String path) {
        Component component = this.getComponentFromLastRenderedPage(path, false);
        Result result = component == null ? Result.fail("path: '" + path + "' does not exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())) : this.isFalse("component '" + path + "' is visible", component.isVisibleInHierarchy());
        return result;
    }

    public Result isEnabled(String path) {
        Component component = this.assertExists(path);
        return this.isTrue("component '" + path + "' is disabled", component.isEnabledInHierarchy());
    }

    public Result isDisabled(String path) {
        Component component = this.assertExists(path);
        return this.isFalse("component '" + path + "' is enabled", component.isEnabledInHierarchy());
    }

    public Component assertExists(String path) {
        Component component = this.getComponentFromLastRenderedPage(path);
        if (component == null) {
            Assertions.fail((String)("path: '" + path + "' does not exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())));
            return null;
        }
        return component;
    }

    public void assertNotExists(String path) {
        Component component = this.getComponentFromLastRenderedPage(path, true, false);
        if (component != null) {
            Assertions.fail((String)("path: '" + path + "' does exists for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())));
        }
    }

    private FormComponent<?> assertFormComponent(String path) {
        Component component = this.assertExists(path);
        if (!(component instanceof FormComponent)) {
            Assertions.fail((String)("path: '" + path + "' is not a form component"));
            return null;
        }
        return (FormComponent)component;
    }

    public Result isRequired(String path) {
        FormComponent<?> formComponent = this.assertFormComponent(path);
        return this.isRequired(formComponent);
    }

    public Result isRequired(FormComponent<?> component) {
        return this.isTrue("component '" + component + "' is not required", component.isRequired());
    }

    public Result isNotRequired(String path) {
        FormComponent<?> formComponent = this.assertFormComponent(path);
        return this.isNotRequired(formComponent);
    }

    public Result isNotRequired(FormComponent<?> component) {
        return this.isFalse("component '" + component + "' is required", component.isRequired());
    }

    public Result ifContains(String pattern) {
        return this.isTrue("pattern '" + pattern + "' not found in:\n" + this.getLastResponseAsString(), this.getLastResponseAsString().matches("(?s).*" + pattern + ".*"));
    }

    public Result ifContainsNot(String pattern) {
        return this.isFalse("pattern '" + pattern + "' found", this.getLastResponseAsString().matches("(?s).*" + pattern + ".*"));
    }

    public void clickLink(String path) {
        this.clickLink(path, true);
    }

    public void clickLink(String path, boolean isAjax) {
        Component linkComponent = this.getComponentFromLastRenderedPage(path);
        this.checkUsability(linkComponent, true);
        if (linkComponent instanceof AjaxLink) {
            if (!isAjax) {
                Assertions.fail((String)("Link " + path + "is an AjaxLink and will not be invoked when AJAX (javascript) is disabled."));
            }
            List<AjaxEventBehavior> behaviors = WicketTesterHelper.findAjaxEventBehaviors(linkComponent, "click");
            for (AjaxEventBehavior behavior : behaviors) {
                this.executeBehavior(behavior);
            }
        } else if (linkComponent instanceof AjaxSubmitLink) {
            if (!isAjax) {
                Assertions.fail((String)("Link " + path + " is an AjaxSubmitLink and will not be invoked when AJAX (javascript) is disabled."));
            }
            AjaxSubmitLink link = (AjaxSubmitLink)linkComponent;
            String pageRelativePath = link.getInputName();
            this.request.getPostParameters().setParameterValue(pageRelativePath, "x");
            this.submitAjaxFormSubmitBehavior(link, (AjaxFormSubmitBehavior)WicketTesterHelper.findAjaxEventBehavior(link, "click"));
        } else if (isAjax && (linkComponent instanceof IAjaxLink || linkComponent instanceof AjaxFallbackLink)) {
            List<AjaxEventBehavior> behaviors = WicketTesterHelper.findAjaxEventBehaviors(linkComponent, "click");
            for (AjaxEventBehavior behavior : behaviors) {
                this.executeBehavior(behavior);
            }
        } else if (linkComponent instanceof SubmitLink) {
            SubmitLink submitLink = (SubmitLink)linkComponent;
            String pageRelativePath = submitLink.getInputName();
            this.request.getPostParameters().setParameterValue(pageRelativePath, "x");
            this.serializeFormToRequest(submitLink.getForm());
            this.submitForm(submitLink.getForm().getPageRelativePath());
        } else if (linkComponent instanceof ExternalLink) {
            ExternalLink externalLink = (ExternalLink)linkComponent;
            String href = externalLink.getDefaultModelObjectAsString();
            try {
                this.getResponse().sendRedirect(href);
                this.recordRequestResponse();
                this.setupNextRequestCycle();
            }
            catch (IOException iox) {
                throw new WicketRuntimeException("An error occurred while redirecting to: " + href, iox);
            }
        } else if (linkComponent instanceof AbstractLink) {
            AbstractLink link = (AbstractLink)linkComponent;
            if (link instanceof BookmarkablePageLink) {
                BookmarkablePageLink bookmarkablePageLink = (BookmarkablePageLink)link;
                try {
                    Method getParametersMethod = BookmarkablePageLink.class.getDeclaredMethod("getPageParameters", null);
                    getParametersMethod.setAccessible(true);
                    PageParameters parameters = (PageParameters)getParametersMethod.invoke((Object)bookmarkablePageLink, (Object[])null);
                    this.startPage(bookmarkablePageLink.getPageClass(), parameters);
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Internal error in WicketTester. Please report this in Wicket's Issue Tracker.", e);
                }
            } else if (link instanceof ResourceLink) {
                try {
                    Method getURL = ResourceLink.class.getDeclaredMethod("getURL", new Class[0]);
                    getURL.setAccessible(true);
                    CharSequence url = (CharSequence)getURL.invoke((Object)link, new Object[0]);
                    this.executeUrl(url.toString());
                }
                catch (Exception x) {
                    throw new RuntimeException("An error occurred while clicking on a ResourceLink", x);
                }
            } else {
                this.executeListener(link);
            }
        } else if (linkComponent instanceof IAjaxLink && !isAjax) {
            Assertions.fail((String)("Link " + path + "is an IAjaxLink and will not be invoked when AJAX (javascript) is disabled."));
        } else {
            Assertions.fail((String)("Link " + path + " is not an instance of AbstractLink or IAjaxLink"));
        }
    }

    public void submitForm(Form<?> form) {
        this.submitForm(form.getPageRelativePath());
    }

    public void submitForm(String path) {
        Form form = (Form)this.getComponentFromLastRenderedPage(path);
        Url url = Url.parse(form.getRootForm().urlForListener(new PageParameters()).toString(), Charset.forName(this.request.getCharacterEncoding()));
        this.transform(url);
        this.request.setUrl(url);
        this.processRequest();
    }

    private Url transform(Url url) {
        while (url.getSegments().size() > 0 && (url.getSegments().get(0).equals("..") || url.getSegments().get(0).equals("."))) {
            url.getSegments().remove(0);
        }
        return url;
    }

    public <C extends Page> Result isRenderedPage(Class<C> expectedRenderedPageClass) {
        Args.notNull(expectedRenderedPageClass, "expectedRenderedPageClass");
        Page page = this.getLastRenderedPage();
        if (page == null) {
            return Result.fail("page was null");
        }
        if (!expectedRenderedPageClass.isAssignableFrom(page.getClass())) {
            return Result.fail(String.format("classes not the same, expected '%s', current '%s'", expectedRenderedPageClass, page.getClass()));
        }
        return Result.pass();
    }

    public void assertResultPage(Class<?> pageClass, String filename) throws Exception {
        String document = this.getLastResponseAsString();
        DiffUtil.validatePage(document, pageClass, filename, true);
    }

    public Result isResultPage(String expectedDocument) {
        String document = this.getLastResponseAsString();
        return this.isTrue("expected rendered page equals", document.equals(expectedDocument));
    }

    public Result hasNoErrorMessage() {
        return this.hasNoFeedbackMessage(400);
    }

    public Result hasNoInfoMessage() {
        return this.hasNoFeedbackMessage(200);
    }

    public Result hasNoFeedbackMessage(int level) {
        List<Serializable> messages = this.getMessages(level);
        return this.isTrue(String.format("expected no %s message, but contains\n%s", new FeedbackMessage(null, (Serializable)((Object)""), level).getLevelAsString().toLowerCase(Locale.ROOT), WicketTesterHelper.asLined(messages)), messages.isEmpty());
    }

    public List<Serializable> getMessages(int level) {
        List<FeedbackMessage> messages = this.getFeedbackMessages(new ExactLevelFeedbackMessageFilter(level));
        ArrayList<Serializable> actualMessages = Generics.newArrayList();
        for (FeedbackMessage message : messages) {
            actualMessages.add(message.getMessage());
        }
        return actualMessages;
    }

    public List<FeedbackMessage> getFeedbackMessages(IFeedbackMessageFilter filter) {
        return new FeedbackCollector(this.getLastRenderedPage(), true).collect(filter);
    }

    public void dumpPage() {
        log.info(this.getLastResponseAsString());
    }

    public void debugComponentTrees() {
        this.debugComponentTrees("");
    }

    public void debugComponentTrees(String filter) {
        log.info("debugging ----------------------------------------------");
        for (WicketTesterHelper.ComponentData obj : WicketTesterHelper.getComponentData(this.getLastRenderedPage())) {
            if (!obj.path.matches(".*" + filter + ".*")) continue;
            log.info("[{}{}] path\t" + obj.path + " \t" + obj.type + " \t[" + obj.value + "]", (Object)(obj.isEnabled ? "E" : "-"), (Object)(obj.isVisible ? "V" : "-"));
        }
    }

    public Result isComponentOnAjaxResponse(Component component) {
        Result result;
        Object failMessage = "A component which is null could not have been added to the AJAX response";
        this.notNull((String)failMessage, component);
        String componentInfo = component.toString();
        if (!component.isVisible() && (result = this.isTrue((String)(failMessage = "A component which is invisible and doesn't render a placeholder tag will not be rendered at all and thus won't be accessible for subsequent AJAX interaction. " + componentInfo), component.getOutputMarkupPlaceholderTag())).wasFailed()) {
            return result;
        }
        String ajaxResponse = this.getLastResponseAsString();
        failMessage = "The previous response was not an AJAX response. You need to execute an AJAX event, using #clickLink() or #executeAjaxEvent(), before using this assertion method";
        boolean isAjaxResponse = Pattern.compile("^<\\?xml version=\"1.0\" encoding=\".*?\"\\?><ajax-response>").matcher(ajaxResponse).find();
        result = this.isTrue((String)failMessage, isAjaxResponse);
        if (result.wasFailed()) {
            return result;
        }
        String markupId = component.getMarkupId();
        failMessage = "The component doesn't have a markup id, which means that it can't have been added to the AJAX response. " + componentInfo;
        result = this.isTrue((String)failMessage, !Strings.isEmpty(markupId));
        if (result.wasFailed()) {
            return result;
        }
        boolean isComponentInAjaxResponse = ajaxResponse.matches("(?s).*<component id=\"" + markupId + "\"[^>]*?>.*");
        failMessage = "Component wasn't found in the AJAX response. " + componentInfo;
        result = this.isTrue((String)failMessage, isComponentInAjaxResponse);
        if (!result.wasFailed()) {
            return result;
        }
        Enclosure enclosure = (Enclosure)this.getLastRenderedPage().visitChildren(Enclosure.class, (enc, visit) -> {
            if (AjaxEnclosureListener.isControllerOfEnclosure(component, enc)) {
                visit.stop(enc);
            }
        });
        if (enclosure == null) {
            return result;
        }
        failMessage = "Component's enclosure was not found in the AJAX response. " + enclosure;
        boolean isEnclosureInAjaxResponse = !this.isComponentOnAjaxResponse(enclosure).wasFailed();
        return this.isTrue((String)failMessage, isEnclosureInAjaxResponse);
    }

    public void executeAjaxEvent(String componentPath, String event) {
        Component component = this.getComponentFromLastRenderedPage(componentPath);
        this.executeAjaxEvent(component, event);
    }

    public void executeAllTimerBehaviors(MarkupContainer page) {
        this.internalExecuteAllTimerBehaviors(page);
        page.visitChildren(Component.class, new IVisitor<Component, Void>(){

            @Override
            public void component(Component component, IVisit<Void> visit) {
                BaseWicketTester.this.internalExecuteAllTimerBehaviors(component);
            }
        });
    }

    private void internalExecuteAllTimerBehaviors(Component component) {
        List<AbstractAjaxTimerBehavior> behaviors = component.getBehaviors(AbstractAjaxTimerBehavior.class);
        for (AbstractAjaxTimerBehavior timer : behaviors) {
            this.checkUsability(component, true);
            if (timer.isStopped()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Triggering AjaxSelfUpdatingTimerBehavior: {}", (Object)component.getClassRelativePath());
            }
            this.executeBehavior(timer);
        }
    }

    public void executeAjaxEvent(Component component, String event) {
        Args.notNull(component, "component");
        Args.notNull(event, "event");
        this.checkUsability(component, true);
        List<AjaxEventBehavior> ajaxEventBehaviors = WicketTesterHelper.findAjaxEventBehaviors(component, event);
        for (AjaxEventBehavior ajaxEventBehavior : ajaxEventBehaviors) {
            this.executeBehavior(ajaxEventBehavior);
        }
    }

    public TagTester getTagByWicketId(String wicketId) {
        return TagTester.createTagByAttribute(this.getLastResponseAsString(), "wicket:id", wicketId);
    }

    public List<TagTester> getTagsByWicketId(String wicketId) {
        return TagTester.createTagsByAttribute(this.getLastResponseAsString(), "wicket:id", wicketId, false);
    }

    public TagTester getTagById(String id) {
        return TagTester.createTagByAttribute(this.getLastResponseAsString(), "id", id);
    }

    private void submitAjaxFormSubmitBehavior(Component component, AjaxFormSubmitBehavior behavior) {
        Form<?> form = behavior.getForm();
        Assertions.assertNotNull(form, (String)"No form attached to the submitlink.");
        this.checkUsability(form, true);
        this.serializeFormToRequest(form);
        this.executeBehavior(behavior);
    }

    private void serializeFormToRequest(Form<?> form) {
        final MockRequestParameters postParameters = this.request.getPostParameters();
        final Set<String> currentParameterNamesSet = postParameters.getParameterNames();
        form.visitFormComponents(new IVisitor<FormComponent<?>, Void>(){

            @Override
            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                String inputName = formComponent.getInputName();
                if (!currentParameterNamesSet.contains(inputName)) {
                    String[] values;
                    for (String value : values = FormTester.getInputValue(formComponent)) {
                        postParameters.addParameterValue(inputName, value);
                    }
                }
            }
        });
    }

    public String getContentTypeFromResponseHeader() {
        String contentType = this.getLastResponse().getContentType();
        Assertions.assertNotNull((Object)contentType, (String)"No Content-Type header found");
        return contentType;
    }

    public int getContentLengthFromResponseHeader() {
        String contentLength = this.getLastResponse().getHeader("Content-Length");
        Assertions.assertNotNull((Object)contentLength, (String)"No Content-Length header found");
        return Integer.parseInt(contentLength);
    }

    public String getLastModifiedFromResponseHeader() {
        return this.getLastResponse().getHeader("Last-Modified");
    }

    public String getContentDispositionFromResponseHeader() {
        return this.getLastResponse().getHeader("Content-Disposition");
    }

    public void applyRequest() {
        ServletWebRequest req = this.newServletWebRequest();
        this.requestCycle.setRequest(req);
        if (this.useRequestUrlAsBase) {
            this.requestCycle.getUrlRenderer().setBaseUrl(((Request)req).getUrl());
        }
    }

    private Result isTrue(String message, boolean condition) {
        if (condition) {
            return Result.pass();
        }
        return Result.fail(message);
    }

    private Result isFalse(String message, boolean condition) {
        if (!condition) {
            return Result.pass();
        }
        return Result.fail(message);
    }

    protected final Result isEqual(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return Result.pass();
        }
        if (expected != null && expected.equals(actual)) {
            return Result.pass();
        }
        String message = "expected:<" + expected + "> but was:<" + actual + ">";
        return Result.fail(message);
    }

    private void notNull(String message, Object object) {
        if (object == null) {
            Assertions.fail((String)message);
        }
    }

    protected Result checkUsability(Component component, boolean throwException) {
        Result res = Result.pass();
        if (!component.isVisibleInHierarchy()) {
            res = Result.fail("The component is currently not visible in the hierarchy and thus you can not be used. Component: " + component);
        }
        if (!component.isEnabledInHierarchy()) {
            res = Result.fail("The component is currently not enabled in the hierarchy and thus you can not be used. Component: " + component);
        }
        if (throwException && res.wasFailed()) {
            throw new AssertionError((Object)res.getMessage());
        }
        return res;
    }

    public RequestCycle getRequestCycle() {
        return this.requestCycle;
    }

    public MockHttpServletResponse getResponse() {
        return this.response;
    }

    public MockHttpServletRequest getLastRequest() {
        return this.lastRequest;
    }

    public boolean isExposeExceptions() {
        return this.exposeExceptions;
    }

    public void setExposeExceptions(boolean exposeExceptions) {
        this.exposeExceptions = exposeExceptions;
    }

    public boolean isUseRequestUrlAsBase() {
        return this.useRequestUrlAsBase;
    }

    public void setUseRequestUrlAsBase(boolean setBaseUrl) {
        this.useRequestUrlAsBase = setBaseUrl;
    }

    public void executeUrl(String _url) {
        Url url = Url.parse(_url, Charset.forName(this.request.getCharacterEncoding()));
        this.transform(url);
        this.getRequest().setUrl(url);
        this.processRequest();
    }

    public class TestFilterConfig
    implements FilterConfig {
        private final Map<String, String> initParameters = new HashMap<String, String>();

        private TestFilterConfig() {
            this.initParameters.put("filterMappingUrlPattern", "/servlet/*");
        }

        @Override
        public String getFilterName() {
            return this.getClass().getName();
        }

        @Override
        public ServletContext getServletContext() {
            return BaseWicketTester.this.servletContext;
        }

        @Override
        public String getInitParameter(String s) {
            return this.initParameters.get(s);
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private class TestRequestMapper
    implements IRequestMapperDelegate {
        private final IRequestMapper delegate;

        private TestRequestMapper(IRequestMapper delegate) {
            this.delegate = delegate;
        }

        @Override
        public IRequestMapper getDelegateMapper() {
            return this.delegate;
        }

        @Override
        public int getCompatibilityScore(Request request) {
            return this.delegate.getCompatibilityScore(request);
        }

        @Override
        public Url mapHandler(IRequestHandler requestHandler) {
            return this.delegate.mapHandler(requestHandler);
        }

        @Override
        public IRequestHandler mapRequest(Request request) {
            if (BaseWicketTester.this.forcedHandler != null) {
                IRequestHandler handler = BaseWicketTester.this.forcedHandler;
                BaseWicketTester.this.forcedHandler = null;
                return handler;
            }
            return this.delegate.mapRequest(request);
        }
    }

    private class TestRequestCycleProvider
    implements IRequestCycleProvider {
        private final IRequestCycleProvider delegate;

        private TestRequestCycleProvider(IRequestCycleProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public RequestCycle apply(RequestCycleContext context) {
            context.setRequestMapper(new TestRequestMapper(context.getRequestMapper()));
            BaseWicketTester.this.forcedHandler = null;
            context.setExceptionMapper(new TestExceptionMapper(context.getExceptionMapper()));
            return (RequestCycle)this.delegate.apply(context);
        }
    }

    private class TestExceptionMapper
    implements IExceptionMapper {
        private final IExceptionMapper delegate;

        private TestExceptionMapper(IExceptionMapper delegate) {
            this.delegate = delegate;
        }

        @Override
        public IRequestHandler map(Exception e) {
            if (BaseWicketTester.this.exposeExceptions) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new WicketRuntimeException(e);
            }
            return this.delegate.map(e);
        }
    }

    private class LastPageRecordingPageRendererProvider
    implements IPageRendererProvider {
        private final IPageRendererProvider delegate;
        private Page lastPage;

        private LastPageRecordingPageRendererProvider(IPageRendererProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public PageRenderer apply(final RenderPageRequestHandler handler) {
            return new PageRenderer(handler){

                @Override
                public void respond(RequestCycle requestCycle) {
                    ((PageRenderer)LastPageRecordingPageRendererProvider.this.delegate.apply(handler)).respond(requestCycle);
                    if (handler.getPageProvider().hasPageInstance()) {
                        Page renderedPage = (Page)handler.getPageProvider().getPageInstance();
                        if (BaseWicketTester.this.componentInPage != null && LastPageRecordingPageRendererProvider.this.lastPage != null && renderedPage != null && LastPageRecordingPageRendererProvider.this.lastPage.getPageClass() != renderedPage.getPageClass()) {
                            BaseWicketTester.this.componentInPage = null;
                        }
                        BaseWicketTester.this.lastRenderedPage = LastPageRecordingPageRendererProvider.this.lastPage = renderedPage;
                    } else {
                        BaseWicketTester.this.lastRenderedPage = null;
                    }
                }
            };
        }
    }

    private static class WicketTesterServletWebResponse
    extends ServletWebResponse
    implements IMetaDataBufferingWebResponse {
        private List<Cookie> cookies = new ArrayList<Cookie>();

        private WicketTesterServletWebResponse(ServletWebRequest request, MockHttpServletResponse response) {
            super(request, response);
        }

        @Override
        public void addCookie(Cookie cookie) {
            super.addCookie(cookie);
            this.cookies.add(cookie);
        }

        @Override
        public void writeMetaData(WebResponse webResponse) {
            for (Cookie cookie : this.cookies) {
                webResponse.addCookie(cookie);
            }
        }

        @Override
        public void sendRedirect(String url) {
            super.sendRedirect(url);
            try {
                this.getContainerResponse().sendRedirect(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TestPageManagerProvider
    implements IPageManagerProvider {
        private TestPageManagerProvider() {
        }

        @Override
        public IPageManager get() {
            return new MockPageManager();
        }
    }

    public static class StartComponentInPage
    extends WebPage {
        private transient IMarkupFragment pageMarkup = null;

        public StartComponentInPage() {
            this.setStatelessHint(false);
        }

        @Override
        public IMarkupFragment getMarkup() {
            IMarkupFragment calculatedMarkup = null;
            if (this.pageMarkup == null) {
                IMarkupFragment markup = super.getMarkup();
                if (markup != null && markup != Markup.NO_MARKUP) {
                    calculatedMarkup = markup;
                    this.pageMarkup = markup;
                }
            } else {
                calculatedMarkup = this.pageMarkup;
            }
            return calculatedMarkup;
        }

        public void setPageMarkup(IMarkupFragment markup) {
            this.setMarkup(markup);
            this.pageMarkup = markup;
        }
    }
}

