/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.media;

import org.zmpp.base.Interruptable;
import org.zmpp.media.SoundEffect;
import org.zmpp.media.SoundStopListener;

public class PlaySoundTask
implements Runnable,
SoundStopListener {
    private int resourceNum;
    private SoundEffect sound;
    private int repeats;
    private int volume;
    private boolean played;
    private Interruptable interruptable;
    private int routine;
    private boolean stopped;

    public PlaySoundTask(int n, SoundEffect soundEffect, int n2, int n3) {
        this(n, soundEffect, n2, n3, null, 0);
    }

    public PlaySoundTask(int n, SoundEffect soundEffect, int n2, int n3, Interruptable interruptable, int n4) {
        this.resourceNum = n;
        this.sound = soundEffect;
        this.repeats = n3;
        this.volume = n2;
        this.interruptable = interruptable;
        this.routine = n4;
    }

    public int getResourceNumber() {
        return this.resourceNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.sound.addSoundStopListener(this);
        this.sound.play(this.repeats, this.volume);
        PlaySoundTask playSoundTask = this;
        synchronized (playSoundTask) {
            while (!this.wasPlayed()) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
        this.sound.removeSoundStopListener(this);
        if (!this.wasStopped() && this.interruptable != null && this.routine > 0) {
            this.interruptable.setInterruptRoutine(this.routine);
        }
    }

    public synchronized boolean wasPlayed() {
        return this.played;
    }

    private synchronized void setPlayed(boolean bl) {
        this.played = bl;
        this.notifyAll();
    }

    private synchronized boolean wasStopped() {
        return this.stopped;
    }

    private synchronized void setStopped(boolean bl) {
        this.stopped = bl;
        this.notifyAll();
    }

    public synchronized void stop() {
        if (!this.wasPlayed()) {
            this.setStopped(true);
            this.sound.stop();
        }
    }

    public synchronized void waitUntilDone() {
        while (!this.wasPlayed()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public void soundStopped(SoundEffect soundEffect) {
        this.setPlayed(true);
    }
}

