#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

frontBedroom: Room 'Front Bedroom'
    "This boxy room is mostly unfurnished. <<(pot.location == self) ? 'Its
        most interesting feature is a
    large pot or planter --- the sort of thing you\'d expect to see a potted
    palm growing in. In this pot, however, is a small brownish-green
        person.<.p>' : ''>>
    
    The door is to the north, and there\'s a window in the opposite wall. "
       
    north = fbDoor
    out asExit(north)
    south: NoTravelMessage { "You could easily break an ankle jumping out
        the window. " }
    enteringRoom(traveler)
    {
        if(traveler == me)
            achievement.awardPointsOnce();        
    }
    achievement: Achievement { +3 "getting into the front bedroom" }
    
    vocabWords = 'boxy front bedroom/room'
    
    brightness = (fbCurtains.isOpen ? 3 : 2)
;

+ fbWindow: RoomPartItem, Openable, CustomFixture 'narrow wooden
    window/pane/(glass)/frame' 
    'narrow window'
    "The window is narrow, consisting of a single pane of glass in a wooden
    frame. Curtains hang beside it. "
    initiallyOpen = nil    
    specialNominalRoomPartLocation = defaultSouthWall
    specialDesc = "There's a narrow window in the south wall. "
    cannotEnterMsg = 'The window is too high up from the ground to use as an
        exit from the bedroom. '
    cannotGoThroughMsg = (cannotEnterMsg)
    cannotTakeMsg = 'The window is firmly embedded in the wall. '
    nothingThroughMsg = 'The window affords a view over the front yard and the
        busy street beyond. '
;

+ fbCurtains: Openable, Fixture 
    'thin chintzy blue printed curtains/material/pattern' 'curtains'
    "The curtains are made of some thin material printed in a predominantly
    blue chintzy pattern. "
    isPlural = true
    initiallyOpen = true
    beforeAction()
    {
        if(!isOpen && gDobj == fbWindow || gIobj == fbWindow)
            tryImplicitAction(Open, self);
    }
    dobjFor(Pull)
    {
        remap = [isOpen ? CloseAction : OpenAction, self]
    }
    okayOpenMsg = 'You pull the curtains open, letting light flood back into the
        room. '
    okayCloseMsg = 'You pull the curtains closed, thereby shutting out much of
        the light. '
    cannotTakeMsg = 'Taking the curtains down would be tedious and time-wasting.
        '
    cannotMoveMsg = 'The curtains flap around uselessly. '
    cannotJumpOverMsg = &mustBeJokingMsg
;

+ Hidden, Distant 'front yard' 'front yard'
    "The front yard looks no better kept from up here than it does from down
    there. "
    discovered  = (fbCurtains.isOpen)
;

+ Hidden, Distant 'busy street/traffic' 'busy street'
    "It looks like it must be building up to rush hour; the traffic has almost
    ground to a halt. At least that should delay Mrs. Pepper\'s return. "
    discovered  = (fbCurtains.isOpen)
;


+ pamphlet: Readable '(garden) pamphlet/booklet/habits/elves' 'pamphlet'
    "The pamphlet is slim and well-thumbed. It\'s entitled <.q>The Habits of
    Garden Elves.<./q> "
    initSpecialDesc = "A pamphlet is lying on the floor. "
    readDesc = "You flip through the pamphlet. A lot of it is both boring and
        unlikely, but you manage to pick up one or two tidbits of information
        that might somehow be useful. First, the odd-looking little man in the
        pot is undoubtedly a garden elf, and not a pixie, leprechaun, or
        hobbit. The illustrations, though crudely drawn, make that pretty
        clear. Second, garden elves are reputed to be a type of plant, not an
        animal at all, though they look like little people. In the wild
        they\'re quite mobile: They can pop up out of the soil, duck down, and
        pop up again a hundred yards away in the blink of an eye --- but they
        can never venture more than a step or two away from the soil, as they
        have roots, not feet. <<elf.identifyAsElf>>"
    bulk = 8
    isPaper = true
    dobjFor(Read) { preCond = inherited + objHeld }
;

+ pot: Booth 'large fat earthenware brown heavy pot/planter' 'heavy pot'
    desc = "The fat brown pot looks to be made of earthenware. It\'s full of
        dirt, and a small, wrinkled, brownish-green person is <<elf.isWatered ?
          'standing' : 'lying curled up'>> in it. "
    bulk = 210
    bulkCapacity = 30
    maxSingleBulk = 30
    sightSize = medium
    isListed = (location != frontBedroom && !(isIn(skateboard) &&
                                              elf.isIn(self)))
    
    /* The noElfName is called by the happyEnding in the elf: */
    noElfName {  name = 'heavy pot';  }
    
    beforeTravel(traveler, connector)
    {
        if(isIn(me))
            failCheck('The pot is far too heavy for you to carry any distance.
                ');
    }
    roomListActorPosture(actor) {}
    /* 
     *   Allow PUSH POT dir to mean PUSH SKATEBOARD dir when the pot is on 
     *   the skateboard.
     */
    dobjFor(PushTravel)
    {
        verify()
        {
            if(isIn(skateboard))
                skateboard.verifyDobjPushTravel();
            else
                /* copied from verbs.t and modified: */
            {
                if(isIn(gActor))
                    illogical('Since you\'re carrying {it dobj/him} that seems
                        rather pointless. ');
                else
                    illogical('You give the pot an experimental shove, but
                        it\'s far too heavy for you to push it across the floor
                        unaided --- if only there were a way to help it move a
                        bit more easily. ');
            
            }
        }
        action()
        {
            if(isIn(skateboard))
                skateboard.actionDobjPushTravel();
            else
                inherited;
        }
    }
    dobjFor(Take) 
    {
        verify() {}
        check() 
        {
            local c = me.countHeld();
            if (c > 0) 
                failCheck ('To pick up the pot, you\'ll need both hands free. ');
        }
    }
    dobjFor(Push) asDobjFor(Move)
    dobjFor(Pull) asDobjFor(Move)
    
    dobjFor(Move) 
    {
        verify() {}
        check() 
        {
            if(isIn(gActor)) 
                failCheck('You have your hands full just holding it. ');
            else if (!isIn(skateboard)) 
                failCheck('You push and tug at the pot, but it fails to scoot
                    more than an inch or so across the floor. It\'s too heavy
                    to slide so easily. ');
        }
        
        /* In the action block, it has to be on the skateboard, right? */
        action() 
        {
            "You roll the pot aimlessly around in circles for a minute.
            Possibly pushing it in some specific direction would be more
            useful. ";
        }
    }
            
    dobjFor(Water)
    {
        verify() {}
        check() 
        {
            if ((chippedGlass.location != me) || (chippedGlass.getState == glassEmpty))
                failCheck ('But you don\'t have any water!' );
        }
        action() {   replaceAction (PourInto, chippedGlass, self);  }
    }
    iobjFor(PourOnto) asIobjFor(PourInto)
    iobjFor(PourInto)
    {
        verify() {}
        check() {
            if (gDobj != chippedGlass) 
                failCheck('You can\'t pour that into the pot. ');
            
            if (elf.isWatered && (elf.location == pot))
                failCheck ('<.q>Oh, I don\'t need any more water,<./q>
                    {the elf/he} assures you. <.q>I\'m fine now, thanks to your
                    very kind help!<./q> ');
            
            if (chippedGlass.waterType == tapWater)
            {
                gReveal('need-water');
                failCheck('When you lean over the pot and start to tip the
                    glass of tap water into it, {the elf/he} writhes and
                    convulses as if an electrical current were shooting through
                    him. <.q>Nooooo!<./q> he cries in a quivering little voice.
                    <.q>Nasty chemicals! Nooo, please. Need nice fresh water,
                    not nasty chemical water.<./q> He falls back, sobbing. ');
            }
        }
    }
;

++ potDirt: Component, Decoration 'dirt/soil' 'dirt in the pot'
    "Surely you\'ve seen dirt before. "
    iobjFor(PourOnto) asIobjFor(PourInto)
    iobjFor(PourInto) remapTo (PourInto, DirectObject, pot)
;

+ fbDoor:  Door 'door' 'door'
    initiallyLocked = nil
    initiallyMagicallyLocked = true
;

//------------------------------------------------------------------------------

landing: Room 'Landing'
    "The landing runs north-south past <<liftDoorUp.aName>> to the west. A
    staircase leads down to the floor below, and there's a black button low on
    the west wall. Immediately to the south the bedroom door is
    <<landingDoor.openDesc>>. "
    south = landingDoor
    north = backBedroom
    down = landingStairs
    west = liftDoorUp
    east asExit(down)
    in asExit(west)
    yellCheck()
    {
        if(me.hasSeen(elf))
            inherited;
    }
    yellDesc = "You try shouting through the bedroom door, and think you just
        make out a faint answering croak from the other side. "
    
    vocabWords = 'landing/passage/room'
;

+ landingDoor: Door ->fbDoor 'front bedroom door*doors' 'bedroom door'
    vocabLikelihood = 10
    dobjFor(KnockOn)
    {
        action()
        {
            if(elf.isIn(frontBedroom))
                "<<elf.isWatered ? 'A voice from the other side of the door
                    calls, <.q>Come in!<./q>' : 'You think you hear a faint
                        answering croak on the other side of the door, but you
                        can\'t be quite sure'>>. ";            
            else
                inherited;
        }
    }
;

+ landingStairs: StairwayDown ->hallStairsUp 
    'narrow steep stairway/steps/stairs/flight/staircase' 'staircase'
    "The stairway is narrow and steep. "    
; 

+ liftDoorUp: LiftDoor     
;

+ LiftButton
    myDoor = liftDoorUp
;

//------------------------------------------------------------------------------

backBedroom: Room 'Back Bedroom'
    "This small, square room is furnished in a plain, unattractive style.
    Opposite the bed stands a dressing table, on which is a row of styrofoam
    heads. <<mentionWigs>>The way out is to the south, and there\'s a bathroom to the east. "
    
    mentionWigs {
        local w = styrofoamHeads.countWigsOnHeads;
        switch(w) {
            case 0: break;
            case 1: "On one of the heads is a rather ugly wig. ";
            break;
            case 4: "Arranged on the heads are some rather ugly wigs. ";
            break;
            default: "On some of the heads are rather ugly wigs. ";
        }
    }

    east = bathroomDoorOutside
    south = landing
    out asExit(south)
    vocabWords = 'small square back bedroom/room'
;

+ bathroomDoorOutside: Door ->bathroomDoorInside
    'plain white bathroom single panel single-panel door*door' 'bathroom door'
    "It's just a plain white single-panel door. "
    cannotLockMsg = 'There\'s no lock on this side of the door. '
    cannotUnlockMsg = (cannotLockMsg)
;

+ RoomPartItem, EntryPortal, Exitable ->landing 
    'way (door) plain doorless (screw) out/exit/frame/doorway/holes' 'doorway'
    "It's a plain frame, with no door. The screw holes suggest that a door once
    hung here, but both it and the hinges have been removed. "
    specialNominalRoomPartLocation = defaultSouthWall
    specialDesc = "A doorway leads out through the south wall. "
;

+ pepperBed: Bed, Heavy 'king size king-size bed' 'bed'
    "The king-size bed is covered with a brown comforter. "
    bulkCapacity = 200
    maxSingleBulk = 200
    nothingUnderMsg = 'You peer under the bed and see nothing but the floor. '
    cannotJumpOverMsg = 'It\'s a bit too wide for that. '
    dobjFor(JumpOff) asDobjFor(GetOffOf)
; 

+ Immovable 'brown comforter/quilt/counterpane/coverlet/duvet/blanket' 'comforter'
    "It's a brown quilted coverlet. "
    dobjFor(LieOn) remapTo(LieOn, pepperBed)
    dobjFor(SitOn) remapTo(SitOn, pepperBed)
    dobjFor(StandOn) remapTo(StandOn, pepperBed)
    dobjFor(Board) remapTo(LieOn, pepperBed)
    dobjFor(GoUnder) 
    {
        verify() {}
        check() 
        {
            failCheck('The day is too warm for curling up under a blanket,
                and anyway you\'re not sleepy. Besides which, the possibility
                that you might accidentally fall asleep in Mrs.\ Pepper\'s bed
                is pretty scary. ');
        }
    }
    nothingUnderMsg = 'You lift each corner of the comforter in turn, but find
        nothing beneath it but the bed. '
    cannotTakeMsg = 'You don\'t want to encumber yourself with the thing. '
    cannotMoveMsg = (nothingUnderMsg)
;

+ mirror: CustomImmovable 'smudged flyspecked oval mirror' 'mirror'
    "The oval mirror on the wall behind the dressing table is rather smudged
    and flyspecked. "
    dobjFor(LookIn) 
    {
        verify() {}
        check() {}
        action() 
        {
            local wornWig = gActor.contents.valWhich({x: x.ofKind(Wig) &&
                x.isWornBy(gActor)});
            
            if (wornWig != nil)                
                "<<wornWig.desc>> You look pretty silly wearing it!";
            else
                "You look almost exactly the same as the last time
                you looked in a mirror. ";
        }
    }
    
    cannotTakeMsg = 'The mirror is firmly attached to the wall. '
    cannotJumpOverMsg = &mustBeJokingMsg
    nothingBehindMsg = 'You peer behind the mirror; there\'s nothing there but
        the wall. '
;

/* 
 *   Note that there is no period at the end of this desc by design. That's 
 *   so we'll see proper punctuation in response to the openStatus printing.
 */
+ dressingTable: ComplexContainer, Fixture 'dressing dresser/table' 'dressing table'
    "The dressing table is unusually large. A mirror is mounted above it, and a
    single drawer is tucked away beneath. A row of white styrofoam heads stands
    on the table"
    
    dobjFor(Open) remapTo(Open, subContainer)
    dobjFor(Close) remapTo(Close, subContainer)
    dobjFor(LookIn) remapTo(LookIn, subContainer)
    
    subSurface: ComplexComponent, Surface 
    {
        contentsListed = nil
        bulkCapacity = 60
        maxSingleBulk = 60
    }
    
    subContainer: ComplexComponent, OpenableContainer 
    {
        vocabWords = '(small) (dressing) (table) drawer*drawers'
        name = 'drawer'
        // Here again, there's no trailing period.
        desc = "It\'s an ordinary small drawer";
        openStatus { if (isOpen) ". The drawer is open"; }
        dobjFor(Pull) asDobjFor(Open)
        dobjFor(Push) asDobjFor(Close)
        bulkCapacity = 30
        maxSingleBulk = 30
    }
    cannotJumpOverMsg = &mustBeJokingMsg
    nothingUnderMsg = 'Apart from the floor, there\'s nothing under the mirror
        but air. '
    nothingBehindMsg = 'Even without moving the dressing-table to check,
        you\'re pretty sure that there\'s nothing behind it but the wall. '
;

++ musicScore: Underside, Readable 
    'musical complex zauberokarina/score/music/libretto/trazom' 
    'musical score'
    "It appears to be the score for an opera called <i>Die Zauberokarina</i> by
    A.W. Trazom. "
    readDesc = "The score looks pretty complex and you don't read music that
        well. The libretto seems to be in German, a language you don't know at
        all. A note on the last page indicates that the orchestration for this
        edition was throroughly revised by one Ireilas Oinotna. Underneath his
        name are some hand-drawn wavy lines. "
    isPaper = true
    subLocation = &subContainer
    dobjFor(Play)
    {
        verify() {}
        check()
        {
            failCheck('The score is far too complex for you to cope with ---
                hemisemidemiquavers by the bushel! ');
        }
    }
    
    dobjFor(PlayOn) 
    {
        verify() {}
        check() {
            if (gIobj != ocarina) failCheck ('That would be difficult, since
                {the iobj/he} is not a musical instrument. ');
        }
        action () {
            replaceAction (Play, self);
        }
    }
    
    dobjFor(LookThrough) asDobjFor(Read)
    dobjFor(LookIn) asDobjFor(Read)
    dobjFor(Move) maybeRemapTo(!moved, Take, self)
    bulkCapacity = 8
    allowPutUnder = (!isIn(me))
    
    /* 
     *   So that if it's in scope, it will be preferred to the component of 
     *   the ocarina:
     */
    vocabLikelihood = 10
;

+++ Component '(hand) drawn purple hand-drawn wavy lines' 'wavy lines'
    "They're drawn in purple ink. The longer you stare at them, the giddier you
    feel, until you're finally forced to look away; but just before you do, you
    sense that the wavy lines somehow convey a sense of <i>swerving</i>. "
    isPlural = true
;

+++ ocarina: Hidden
    'small plastic round hollow brown potato/ocarina/mouthpiece/holes/hole'
    'ocarina'
    "The plastic ocarina is about the shape and color of a potato. There are a
    few holes across the top, and a sort of mouthpiece at one side for blowing
    into. "

    bulk = 7
    dobjFor(Play) 
    {
        preCond = [objHeld]
        verify() {}
        check() {}
        action() 
        {
            /* 
             *   Register for summarizing reports of reactions to playing the
             *   ocarina in afterActionMain()
             */
            gAction.callAfterActionMain(self); 
            
            "You tootle a few sour notes on the ocarina. ";
            
            //  ECSE: I'm moving this code to an afterAction method on Mrs
            //  Pepper, where it really belons.
//            if ((me.getOutermostRoom == backYard) &&
//                (neighbour.location == nextDoorGarden))
//                "<<(neighbour.name == 'neighbor') ? 'The woman in the garden
//                    next door' : 'Mrs.\ Dogwood'>> clamps her hands over her
//                ears. <.q>My goodness, what an awful racket!<./q> ";
        }
    }
    iobjFor(PlayOn) 
    {
        preCond = [objHeld]
        verify() {}
        check() {}
        action() 
        {
            if (gDobj == musicScore) 
                replaceAction (Play, musicScore);
            else 
                replaceAction (Play, self);
        }
    }

    /* 
     *   Various objects might respond to the playing of the ocarina. This 
     *   routine summarizes the reports of them so we see, e.g., "The stove, 
     *   the drawer and the cabinet slam shut" rather than "The stove slams 
     *   shut. The drawer slams shut. The cabinet slams shut. "
     */
    afterActionMain()
    {
        /* 
         *   First sort the reports in the transcript relating to reactions 
         *   to the ocarina so that like reports (slamming, shimmering, 
         *   etc.) occur together.
         */
        local cmdVec = gTranscript.reports_.subset({x: x.sortOrder !=nil });
        cmdVec.sort(nil, {a, b: a.sortOrder - b.sortOrder});

        local firstIdx = gTranscript.reports_.indexWhich({x: x.sortOrder !=
            nil});

        if(firstIdx)
        {
            gTranscript.reports_.copyFrom(cmdVec, 1, firstIdx, cmdVec.length());
        }

        /* The summarize each kind of action report. */
        gTranscript.summarizeAction(
            {x: x.ofKind(SlamShutReport) },
            new function(vec)
        {
            local str = '\^' + buildList(vec, &slamObj);

            str += (vec.length == 2 ?  ' both' : ' all');

            return str + ' slam shut. ';
        }
            );

        gTranscript.summarizeAction(
            {x: x.ofKind(SlamShutInDarkReport) },
            { vec: 'You hear a number of things slam shut nearby. ' }
            );           
        
        
        gTranscript.summarizeAction(
            {x: x.ofKind(VibrateReport) },
            new function(vec)
        {
            local str = '\^' + buildList(vec, &vibObj);

            str += (vec.length == 2 ?  'both' : ' all');

            return str + ' vibrate for a moment in a dull, heavy way,
            as if they\'re becoming darker and more massive. ';
        }
            );

        gTranscript.summarizeAction(
            {x: x.ofKind(ShimmerReport) },
            new function(vec)
        {
            local str = '\^' + buildList(vec, &vibObj);

            str += (vec.length == 2 ?  'both' : ' all');

            return str + ' shimmer pleasantly for a moment, as if a
            rainbow of light is passing across them. ';
        }
            );

        gTranscript.summarizeAction(
            {x: x.ofKind(MomentaryShimmerReport) },
            new function(vec)
        {
            return 'You fancy you detect a momentary shimmering across the
            surface of ' + buildList(vec, &vibObj) + ', as if a rainbow of
                light is passing across them. ';

        }
            );
    } // end of ocarina.afterActionMain

    /* 
     *   Given a vector of objects, construct a properly formatted list of 
     *   their names, e.g. 'the stove, the drawer and the cabinet'
     *
     *   Note that in future versions of TADS 3 it should be possible to do 
     *   this simply by calling objectLister.makeSimpleList(vec); or 
     *   something similar. 
     */
    buildList(vec, prop)
    {
        local str = '';
        for(local i=1; i<=vec.length(); i++)
            {
                str += vec[i].(prop).theName;
                if(i < vec.length() - 1)
                    str += ', ';
                if(i == vec.length - 1)
                    str += ' and ';
            }
        return str;
    }
;

++++ Component, Decoration 'melody/tune/song/air/notes/music' 'melody'
    "The melody is invisible, ineffable, inscrutable. "
    dobjFor(PlayOn) 
    {
        verify() {}
        check() {}
    }
    iobjFor(PlayOn) 
    {
        verify() {}
    }
    dobjFor(ListenTo) 
    {
        verify() {}
        check() {}
        action () 
        {
            "To hear the melody, you\'ll need to play the ocarina. ";
        }
    }
    // Less likely than the musicalScore, if the latter is in scope:
    vocabLikelihood = 5
;

++ brush: Thing '(hair) multi-colored multi-coloured cheap (black) plastic
    hairbrush/brush/strands/bristles/back' 
    'brush'
    "Judging from the multi-colored strands caught in its bristles, Mrs. Pepper
    uses this cheap black plastic brush on her wigs. There\'s some
    kind of emblem on the back of the brush. "
    canMatchThem = true
    subLocation = &subContainer
    iobjFor(BrushWith) { verify() {} }
    descPrinted = nil
    notifyDescPrinted { descPrinted = true; }
;

+++ Component 'red scarlet schematic fish/herring/emblem' 'scarlet fish'
    "It\'s fairly schematic, but it looks like a scarlet fish. Underneath it is
    some tiny lettering.<<brush.notifyDescPrinted>> "
;

+++ Component 'tiny arabic lettering/letters' 'tiny lettering'
    "You can't make it out. It appears to be in Arabic or some other alphabet
    you have no idea how to read. "
;

/* There is only one head, though it appears to the player as a set of four. */
styrofoamHeads: RestrictedSurface, Immovable
    'white styrofoam head*heads'
    'styrofoam heads'
    "The four white styrofoam heads stand stiffly on the dressing table. They
    look rather ominously ghostly, as they have no faces. "
    validContents = [auburnWig, blackWig, blondWig, greenWig]
    isPlural = true
    location = dressingTable.subSurface
    
    /* 
     *   We're going to keep a tally of how many wigs have been worn in a 
     *   central  place:
     */
    wigWornCount = 0
    
    countWigsOnHeads {
        return contents.length();
    }
    bulkCapacity = 50
    maxSingleBulk = 15
    
    cannotTakeMsg = 'You can\'t imagine a use for the styrofoam heads, so you
        decide to leave them where they are. '
    cannotMoveMsg = 'You consider rearranging the styrofoam heads, but the
        dressing table doesn\'t really have room for any pattern apart from the
        row they\'re already in. '
;

/* 
 *   The auburn wig makes vehicles swerve --- not used in game, only in 
 *   back-story.
 */
+ auburnWig: Wig 'auburn -' 'auburn wig'
    "The auburn wig is short and balloon-shaped. <<readTag>>"
    
    tagMessage = 'Attached to the elastic band at
    the back is a little hand-lettered cardboard tag, which reads: ZGBH
        YAHHKHU EHAQTKHX XYHFEH.<.reveal wig-tags> '
;

/*  The black wig is a magical lock locker/unlocker. */
+ blackWig: Wig 'long black -' 'black wig'
    "The black wig is very long, and the curls are tangled. <<readTag>>"
    
    tagMessage = 'Attached to the elastic band at
    the back is a little hand-lettered cardboard tag, which reads:
        ZGOQTGK KDTBQSO.<.reveal wig-tags> '
;

/* The blond wig summons rain. */
+ blondWig: Wig 'blond blonde -' 'blond wig'
    "The hair of the blond wig sticks straight out, as if it\'s made of clumps
    of straw. <<readTag>>"
    
    tagMessage = 'Attached to the elastic band at
    the back is a little hand-lettered cardboard tag, which reads: XPZZDS
        FGQS.<.reveal wig-tags> '
;

/* 
 *   The green wig allows the wearer to induce sleep in a victim --- not used
 *   in game, only in back-story.
 */
+ greenWig: Wig 'greasy green ringlets' 'green wig'
    "The green wig is a mass of greasy green ringlets. <<readTag>>"
    
    tagMessage = 'Attached to the elastic band at
    the back is a little hand-lettered cardboard tag, which reads: TGPXH
        XKHHW.<.reveal wig-tags> '      
;

class Wig: Wearable
    vocabWords = 'elastic hand-lettered cardboard synthetic coarse nylon 
        band/tag/wig/hairpiece/hat*wigs'
    /* 
     *   The purpose of the readTag method is to insure that the PC can't 
     *   read the tag while wearing the wig.
     */
    readTag 
    {
        if (isWorn) 
            return;
        
        gReveal('wearing-things');
        say(tagMessage);
    }
    tagMessage = 'dummy message'
    bulk = 12
    
    dobjFor(Wear) 
    {
        action() 
        {
            gReveal('worn-wig');
            /* 
             *   See if the actor is already wearing a wig; if so, doff it 
             *   before donning the new wig.
             */
            local alreadyWornWig = gActor.contents.valWhich({x: x.ofKind(Wig) &&
                x.isWornBy(gActor)});
            if(alreadyWornWig)
                tryImplicitAction(Doff, alreadyWornWig);    
                
                
            styrofoamHeads.wigWornCount++;
            if (styrofoamHeads.wigWornCount == 1) 
            {
                "After a quick glance
                <<(me.getOutermostRoom == backBedroom) ? 'at the bedroom window
                    to make sure none of your friends has crept up with a ladder
                    to watch you making ' : 'in all directions to make sure no
                    one is watching while you make '>> such a fool of yourself,
                you don the wig. ";
            }
            inherited;
        }
    }
    dobjFor(Doff) 
    {
        check() 
        {
            if (pot.location == me) 
                failCheck ('You\'re using both hands to carry the heavy pot. To
                    take off the wig, you\'ll need to set down the pot. ');
        }
    }

    
    dobjFor(BrushWith)
    {
        verify() { logicalRank(120, 'brushable'); }
        check() {}
        action()
        {
            "You apply the hairbrush to {the dobj/him}, but afterward it looks
                much the way it did before. ";
        }
    }
    
    listWith = [wigGroup]
    /* 
     *   A wig will get slightly damp if it's placed in the sink while the 
     *   faucet is running:
     */
    isDamp = nil
    makeDamp (obj) 
    {
        if (!isDamp) 
        {
            reportAfter(&becomingDampMsg, self);
            name = 'slightly damp ' + name;
            cmdDict.addWord(self, 'slightly', &adjective);
            cmdDict.addWord(self, 'damp', &adjective);            
        }
        isDamp = true;
    }
    
    examineStatus()
    {
        if(isDamp)
            "The wig is slightly damp. ";
        inherited();
    }
    
    feelDesc()
    {
        "The wig feels quite coarse, as if made of something quite synthetic,
        such as nylon. ";
        if(isDamp)
            "It also feels a little damp. ";
    }
;

wigGroup: ListGroupParen
    showGroupCountName(lst)
    {
        "<<spellInt(lst.length())>> wigs ";
    }
    showGroupItem(sublister, obj, options, pov, infoTab)
    {
         if ((options & ListTall) != 0)
            inherited(sublister, obj, options, pov, infoTab);
	
        else
           "one <<obj.name.substr(1, obj.name.length() - 4)>>";
    }
;


//------------------------------------------------------------------------------

bathroom: Room 'Bathroom'
    "The way out is to the west. The normal bathroom stuff is here, including
    a bath, a washbasin and a toilet. "
    west = bathroomDoorInside
    out asExit(west)
    vocabWords = 'bathroom/room'
;

+ bathroomDoorInside: Lockable, Door 'plain white (bathroom) door*doors'
    'bathroom door'
    "It's just a plain white door. "
    initiallyOpen = true
    initiallyLocked = nil;

// JA 26-Dec: Revised desc to mention faucet and remapped 'turn on basin'
+ basin: Container, CustomFixture 
    'plain white enamel wash basin/washbasin/sink' 'washbasin'
    "It's just a plain white enamel basin, matching the bath. A faucet is
    mounted above it. "
    bulkCapacity = 40
    maxSingleBulk = 40
    cannotEnterMsg = 'It\'s awkward to climb into and far too small to
        hold you. '
    cannotBoardMsg = (cannotEnterMsg)
    notifyInsert(obj, newCont) {
        if(bathroomTap.isOn)
            obj.makeDamp(self);
    }
    dobjFor(TurnOn) remapTo (TurnOn, bathroomTap)
    dobjFor(TurnOff) remapTo (TurnOff, bathroomTap)
;

++ bathroomTap: Faucet 'tap/faucet' 'faucet'
    wetLocation = basin
;

+ Booth, Fixture 'plain white off-white enamel bath/tub/bathtub' 'bath'
    "It's a plain white enamel bath, matching the sink; at least, it was white
    once, it's now mostly off-white with a number of distinctly brown stains. "
    bulkCapacity = 250
    maxSingleBulk = 250
;

+ Decoration 'brown stains' 'brown stains'
    "The brown stains cluster particularly round the plug-hole. "
    isPlural = true
;

+ Decoration 'plug hole/plughole/plug-hole/drain' 'plug-hole'
    "It\'s surrounded by brown stains. "
;

+ Decoration '(water) closet/wc/loo/bog/john/toilet' 'toilet'
    "It's a standard enough model. "
    notImportantMsg = 'You don\'t need to use it right now, and you\'re not so
        sure of Mrs.\ Pepper\'s standards of hygiene that you want to mess with
        this part of her plumbing. '
;