/* Copyright (c) 1999, 2000 by Kevin Forchione.  All Rights Reserved. */
/*
 *  TADS ADV.T/STD.T LIBRARY EXTENSION
 *  PPO.T				
 *  version 1.0
 *
 *	    This file implements the use of preparse objects. This allows 
 *      for the modularisation of preparse and eliminates overriding 
 *      preparse in separate modules.
 *
 *----------------------------------------------------------------------
 *  REQUIREMENTS
 *
 *      + HTML TADS 2.3.0 or later
 *      + Requires ADV.T and STD.T
 *      + Should be #included after ADV.T and STD.T.
 *
 *----------------------------------------------------------------------
 *  IMPORTANT LIBRARY INTERFACE AND MODIFICATION
 *
 *      This module replaces the preinit() and preparse() functions.
 *
 *----------------------------------------------------------------------
 *  COPYRIGHT NOTICE
 *
 *  	You may modify and use this file in any way you want, provided that
 *		if you redistribute modified copies of this file in source form, the
 *   	copies must include the original copyright notice (including this
 *   	paragraph), and must be clearly marked as modified from the original
 *   	version.
 *
 *------------------------------------------------------------------------------
 *  REVISION HISTORY
 *
 *		24-May-99:	Creation.
 */

#define __PPO_MODULE_

/*
 *  preparseObj: object
 *
 *  The preparse object is designed to allow for multiple occurrences
 *  of preparse(). Each instance of a preparse object should perform a
 *  unique function within your source. The ppomethod() should return
 *  either true, nil, or a new command string, as required by
 *  preparse().
 */
class preparseObj: object
	ispreparseObj = true
	ppomethod( cmd ) =
	{
		return( true );
	}
;

/*
 *  preparse: function( cmd )
 *
 *  This replacement implements the processing of preparse objects. It
 *  allows for the definition of multiple preparse routines and is an
 *  adjunct to ACTOR GRAMMAR.
 */
replace preparse: function( cmd ) 
{
	local o, p, ret;
	p := global.preparseObjList;
	o := car( p );
	while( o )
	{
		ret := o.ppomethod( cmd );
		if ( ret <> true ) return( ret );
		p := cdr( p );
		o := car( p );
	};
	return( true );
}
;

/*
 *  MODIFICATION: Add all preparse objects to global.preparseObjList.  
 *
 *   preinit() is called after compiling the game, before it is written
 *   to the binary game file.  It performs all the initialization that can
 *   be done statically before storing the game in the file, which speeds
 *   loading the game, since all this work has been done ahead of time.
 *
 *   This routine puts all lamp objects (those objects with islamp = true) into
 *   the list global.lamplist.  This list is consulted when determining whether
 *   a dark room contains any light sources.
 */
replace preinit: function
{
    local o;
    
    global.lamplist := [];
    o := firstobj();
    while( o )
    {
        if (o.islamp)
            global.lamplist := global.lamplist + o;
        if (o.ispreparseObj)
        	global.preparseObjList := global.preparseObjList + o;
        o := nextobj(o);
    }
    initSearch();
}
;

modify global
	preparseObjList = []
;
