/*
 * 	sample.t				version 1.1
 *	by Kevin Forchione		( Lysseus@msn.com )
 *	Copyright (c) 1999. 	All Rights Reserved.
 *
 *	This module demonstrates WYSIWYG.T, the TADS library extension that
 *	facilitates in implementing maps and signs.
 *
 *  Requires HTML TADS 2.2.6 or later.
 *
 *----------------------------------------------------------------------
 *
 *  You may modify and use this file in any way you want, provided 
 *  that if you redistribute modified copies of this file in source 
 *  form, the copies must include the original copyright notice 
 *  (including this paragraph), and must be clearly marked as 
 *  modified from the original version.
 *
 *----------------------------------------------------------------------
 *	Revision History
 *----------------------------------------------------------------------
 *		17-Jun-99:	Creation.
 *      03-Feb-00:  Fixed sdesc for maps.
 */

#define USE_HTML_STATUS
#include <adv.t>
#include <std.t>
#include <wysiwyg.t>

/*
 *	Just an ordinary startroom with nowhere to go...
 */
startroom: room
	sdesc = "Foyer"
	ldesc = "The foyer of the magnificent Museum of TADS. A flight of 
		stairs sweeps upward to Chapters IV and V, and corridors
		fan out on this level into Chapter III. These run:
		<br>\tnorth into Room 10 (the Halls of Sense and Direction),
		<br>\tsouth along Corridor 12 (doors) to Room 13 (switches),
		<br>\teast to Room 11 (the Wonderful World of Containers)
		<br>\twest to Room 14 (Large Exhibits Room)
		<br>\tand down to Room 15 (which houses larger exhibits).
		<P>\t(And a plain ladder descends into the basement; you can also
		step out onto a balcony.)
		<P>
		You notice a map along the west wall, and one along the east
		wall. There is a small sign nearby."
;

sign: wysiwyg, fixeditem
	location = startroom
	sdesc = "sign"
	noun = 'sign'
	bodyText =
	[
		'Museum Hours: 8:00 a.m. - 6:00 p.m.'
	]
;

mapW: wysiwyg, fixeditem
    sdesc = "west map"
    noun = 'map'
    adjective = 'west'
    location = startroom
    ldesc = 
    {
        "It's a large map that occupies one entire wall of the 
        foyer. It reads: ";
        pass ldesc;
    }
    headerText =
    [
        'MUSEUM MAP'
        'FIRST FLOOR'
    ]
    bodyText = 
    [
        '                                    (mirror)'
        'Weights          Room 10 ---------- Room 10a'
        ' Room             senses            directions'
        '   |                |'
        'Room 14 --------- Foyer ------------ Room 11'
        '(changing     (you are here)        containers'
        'character)          |'
        '   |                |'
        'Room 15 ------- Corridor 12'
        '(MS room)     (door, curator)'
        '(Bible)             |'
        '              Switches Hall 13'
        '                 (chasm)'  
        '                    |'
        '          Far Side of Room 13'
    ]
    footerText =
    [
        '(This Sign Demonstrates The WYSIWYG Class Object, now available with
        the TADS inform.t library extension.)'
    ]
;

mapE: wysiwygTable, fixeditem
    sdesc = "east map"
    noun = 'map'
    adjective = 'east'
    location = startroom
    ldesc = 
    {
        "It's a large map that occupies one entire wall of the 
        foyer. It reads: ";
        pass ldesc;
    }
    headerText =
    [
        'MUSEUM MAP'
        'FIRST FLOOR'
    ]
    bodyText = 
    [
        '                                    (mirror)'
        'Weights          Room 10 ---------- Room 10a'
        ' Room             senses            directions'
        '   |                |'
        'Room 14 --------- Foyer ------------ Room 11'
        '(changing     (you are here)        containers'
        'character)          |'
        '   |                |'
        'Room 15 ------- Corridor 12'
        '(MS room)     (door, curator)'
        '(Bible)             |'
        '              Switches Hall 13'
        '                 (chasm)'  
        '                    |'
        '          Far Side of Room 13'
    ]
    footerText =
    [
        '(This Sign Demonstrates The WYSIWYG Class Object, now available with
        the TADS inform.t library extension.)'
    ]
;

replace commonInit: function
{
	"\H+";
}
