/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public enum MariaDbType {
    OLDDECIMAL(0, 3, BigDecimal.class.getName()),
    TINYINT(1, 5, Integer.class.getName()),
    SMALLINT(2, 5, Integer.class.getName()),
    INTEGER(3, 4, Integer.class.getName()),
    FLOAT(4, 7, Float.class.getName()),
    DOUBLE(5, 8, Double.class.getName()),
    NULL(6, 0, String.class.getName()),
    TIMESTAMP(7, 93, Timestamp.class.getName()),
    BIGINT(8, -5, Long.class.getName()),
    MEDIUMINT(9, 4, Integer.class.getName()),
    DATE(10, 91, Date.class.getName()),
    TIME(11, 92, Time.class.getName()),
    DATETIME(12, 93, Timestamp.class.getName()),
    YEAR(13, 5, Short.class.getName()),
    NEWDATE(14, 91, Date.class.getName()),
    VARCHAR(15, 12, String.class.getName()),
    BIT(16, -7, "[B"),
    DECIMAL(246, 3, BigDecimal.class.getName()),
    ENUM(247, 12, String.class.getName()),
    SET(248, 12, String.class.getName()),
    TINYBLOB(249, -3, "[B"),
    MEDIUMBLOB(250, -3, "[B"),
    LONGBLOB(251, -4, "[B"),
    BLOB(252, -4, "[B"),
    VARSTRING(253, 12, String.class.getName()),
    STRING(254, 12, String.class.getName()),
    GEOMETRY(255, -3, "[B");

    static MariaDbType[] typeMap;
    private final int javaType;
    private final int mysqlType;
    private final String className;

    private MariaDbType(int mysqlType, int javaType, String className) {
        this.javaType = javaType;
        this.mysqlType = mysqlType;
        this.className = className;
    }

    public static boolean isNumeric(MariaDbType type) {
        switch (type) {
            case OLDDECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case BIGINT: 
            case MEDIUMINT: 
            case BIT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public static String getClassName(MariaDbType type, int len, boolean signed, boolean binary, int flags) {
        switch (type) {
            case TINYINT: {
                if (len == 1 && (flags & 1) != 0) {
                    return Boolean.class.getName();
                }
                return Integer.class.getName();
            }
            case INTEGER: {
                return signed ? Integer.class.getName() : Long.class.getName();
            }
            case BIGINT: {
                return signed ? Long.class.getName() : BigInteger.class.getName();
            }
            case YEAR: {
                if ((flags & 2) != 0) {
                    return Date.class.getName();
                }
                return Short.class.getName();
            }
            case BIT: {
                return len == 1 ? Boolean.class.getName() : "[B";
            }
            case STRING: 
            case VARCHAR: 
            case VARSTRING: {
                return binary ? "[B" : String.class.getName();
            }
        }
        return type.getClassName();
    }

    public static String getColumnTypeName(MariaDbType type, long len, boolean signed, boolean binary) {
        switch (type) {
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case MEDIUMINT: {
                if (!signed) {
                    return type.getTypeName() + " UNSIGNED";
                }
                return type.getTypeName();
            }
            case BLOB: {
                if (len < 0L) {
                    return "LONGBLOB";
                }
                if (len <= 255L) {
                    return "TINYBLOB";
                }
                if (len <= 65535L) {
                    return "BLOB";
                }
                if (len <= 0xFFFFFFL) {
                    return "MEDIUMBLOB";
                }
                return "LONGBLOB";
            }
            case VARCHAR: 
            case VARSTRING: {
                if (binary) {
                    return "VARBINARY";
                }
                return "VARCHAR";
            }
            case STRING: {
                if (binary) {
                    return "BINARY";
                }
                return "CHAR";
            }
        }
        return type.getTypeName();
    }

    public static MariaDbType fromServer(int typeValue) {
        MariaDbType mariaDbType = typeMap[typeValue];
        if (mariaDbType == null) {
            mariaDbType = BLOB;
        }
        return mariaDbType;
    }

    public static MariaDbType toServer(int javaType) {
        for (MariaDbType v : MariaDbType.values()) {
            if (v.javaType != javaType) continue;
            return v;
        }
        return BLOB;
    }

    public int getSqlType() {
        return this.javaType;
    }

    public String getTypeName() {
        return this.name();
    }

    public int getType() {
        return this.mysqlType;
    }

    static {
        typeMap = new MariaDbType[256];
        MariaDbType[] mariaDbTypeArray = MariaDbType.values();
        int n2 = mariaDbTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MariaDbType v;
            MariaDbType.typeMap[v.mysqlType] = v = mariaDbTypeArray[i2];
        }
    }
}

