/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

public class FrequencyDistribution {
    private double binSize;
    private double start = 0.0;
    private double smaller;
    private double larger;
    private int[] bins;

    public FrequencyDistribution(double d, int n, double d2) {
        this.init(d, n, d2);
    }

    public FrequencyDistribution(int n, double d) {
        this.init(0.0, n, d);
    }

    public FrequencyDistribution(double[] dArray, int n, double d) {
        this.init(0.0, n, d);
        for (double d2 : dArray) {
            this.addValue(d2);
        }
    }

    public int getBinCount() {
        return this.bins.length;
    }

    public double getBinSize() {
        return this.binSize;
    }

    public double getLowerBound() {
        return this.start;
    }

    public int getFrequency(int n) {
        return this.bins[n];
    }

    public double getProbability(int n) {
        int n2 = 0;
        for (int n3 : this.bins) {
            n2 += n3;
        }
        if (n2 == 0) {
            return 0.0;
        }
        return (double)this.bins[n] / (double)n2;
    }

    public void addValue(double d) {
        double d2 = d - this.start;
        int n = (int)(d2 / this.binSize);
        if (n < 0) {
            this.smaller += 1.0;
        } else if (n >= this.bins.length) {
            this.larger += 1.0;
        } else {
            int n2 = n;
            this.bins[n2] = this.bins[n2] + 1;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("< ").append(this.start).append("\t").append(this.smaller).append("\n");
        for (int i = 0; i < this.bins.length; ++i) {
            double d = this.start + this.binSize * ((double)i + 0.5);
            stringBuffer.append(d).append("\t").append(this.bins[i]).append("\n");
        }
        double d = this.start + this.binSize * (double)this.bins.length;
        stringBuffer.append(">= ").append(d).append("\t").append(this.larger).append("\n");
        return new String(stringBuffer);
    }

    private void init(double d, int n, double d2) {
        this.bins = new int[n];
        this.binSize = d2;
        this.smaller = 0.0;
        this.larger = 0.0;
        this.start = d;
    }
}

