/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;

abstract class AbstractSymmDenseMatrix
extends AbstractDenseMatrix {
    private BLASkernel.UpLo uplo;

    AbstractSymmDenseMatrix(int n, BLASkernel.UpLo uplo) {
        super(n, n);
        this.uplo = uplo;
    }

    AbstractSymmDenseMatrix(Matrix A, BLASkernel.UpLo uplo) {
        this(A, true, uplo);
    }

    AbstractSymmDenseMatrix(Matrix A, boolean deep, BLASkernel.UpLo uplo) {
        super(A, deep);
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Symmetric matrix must be square");
        }
        this.uplo = uplo;
    }

    public Matrix multAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.multAdd(alpha, B, C);
        }
        this.checkMultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        Interface.blas().symm(BLASkernel.Side.Left, this.uplo, C.numRows(), C.numColumns(), alpha, this.data, Math.max(1, C.numRows()), Bd, Math.max(1, C.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    public Matrix transAmultAdd(double alpha, Matrix B, Matrix C) {
        return this.multAdd(alpha, B, C);
    }

    public Matrix rank1(double alpha, Vector x, Vector y) {
        if (x != y) {
            throw new IllegalArgumentException("x != y");
        }
        if (!(x instanceof DenseVector)) {
            return super.rank1(alpha, x, y);
        }
        this.checkRank1(x, y);
        double[] xd = ((DenseVector)x).getData();
        Interface.blas().syr(this.uplo, this.numRows, alpha, xd, this.data, Math.max(1, this.numRows));
        return this;
    }

    public Matrix rank2(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.rank2(alpha, x, y);
        }
        this.checkRank2(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        Interface.blas().syr2(this.uplo, this.numRows, alpha, xd, yd, this.data, Math.max(1, this.numRows));
        return this;
    }

    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        Interface.blas().symv(this.uplo, this.numRows, alpha, this.data, Math.max(1, this.numRows), xd, 1.0, yd);
        return y;
    }

    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        return this.multAdd(alpha, x, y);
    }

    public Matrix rank1(double alpha, Matrix C) {
        if (!(C instanceof DenseMatrix)) {
            return super.rank1(alpha, C);
        }
        this.checkRank1(C);
        double[] Cd = ((DenseMatrix)C).getData();
        Interface.blas().syrk(this.uplo, BLASkernel.Transpose.NoTranspose, this.numRows, C.numColumns(), alpha, Cd, Math.max(1, this.numRows), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    public Matrix transRank1(double alpha, Matrix C) {
        if (!(C instanceof DenseMatrix)) {
            return super.transRank1(alpha, C);
        }
        this.checkTransRank1(C);
        double[] Cd = ((DenseMatrix)C).getData();
        Interface.blas().syrk(this.uplo, BLASkernel.Transpose.Transpose, this.numRows, this.numRows, alpha, Cd, Math.max(1, this.numRows), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    public Matrix rank2(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.rank2(alpha, B, C);
        }
        this.checkRank2(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        Interface.blas().syr2k(this.uplo, BLASkernel.Transpose.NoTranspose, this.numRows, B.numColumns(), alpha, Bd, Math.max(1, this.numRows), Cd, Math.max(1, this.numRows), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    public Matrix transRank2(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.transRank2(alpha, B, C);
        }
        this.checkTransRank2(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        Interface.blas().syr2k(this.uplo, BLASkernel.Transpose.Transpose, this.numRows, B.numRows(), alpha, Bd, Math.max(1, B.numRows()), Cd, Math.max(1, B.numRows()), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    public Matrix solve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        double[] newData = (double[])this.data.clone();
        int[] ipiv = new int[this.numRows];
        double[] work = new double[1];
        int info = Interface.lapack().sysv(this.uplo, this.numRows, X.numColumns(), newData, ipiv, Xd, work, -1);
        int lwork = -1;
        lwork = info != 0 ? 1 : Math.max((int)work[0], 1);
        work = new double[lwork];
        info = Interface.lapack().sysv(this.uplo, this.numRows, X.numColumns(), newData, ipiv, Xd, work, lwork);
        if (info > 0) {
            throw new MatrixSingularException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    public Matrix transSolve(Matrix B, Matrix X) {
        return this.solve(B, X);
    }

    public Vector transSolve(Vector b, Vector x) {
        return this.solve(b, x);
    }

    Matrix SPDsolve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int info = Interface.lapack().posv(this.uplo, this.numRows, X.numColumns(), (double[])this.data.clone(), Xd);
        if (info > 0) {
            throw new MatrixNotSPDException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    public Matrix transpose() {
        return this;
    }
}

