## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(rvec)
l <- list(c(3, 1, 0))
theta <- rvec(l)
theta

## -----------------------------------------------------------------------------
theta^2 + 1

## -----------------------------------------------------------------------------
beta <- theta + c(1, -1)
beta

## -----------------------------------------------------------------------------
draws_mean(beta)

## ----message = FALSE----------------------------------------------------------
library(dplyr)
library(tidyr)
library(ggplot2)

## -----------------------------------------------------------------------------
divorce

## -----------------------------------------------------------------------------
divorce_rv <- divorce |>
  collapse_to_rvec(value = rate)
divorce_rv

## -----------------------------------------------------------------------------
divorce_rv |>
  group_by(sex) |>
  summarise(TDR = sum(rate) * 5 / 1000)

## -----------------------------------------------------------------------------
divorce_rv |>
  group_by(sex) |>
  summarise(tdr = sum(rate) * 5 / 1000) |>
  mutate(draws_ci(tdr))

## -----------------------------------------------------------------------------
divorce_ratio <- divorce_rv |>
  pivot_wider(names_from = sex, values_from = rate) |>
  mutate(ratio = Female / Male) |>
  mutate(draws_ci(ratio))

## ----fig.width = 7, fig.height = 4--------------------------------------------
ggplot(divorce_ratio,
       aes(x = age, 
           ymin = ratio.lower, 
           y = ratio.mid,
           ymax = ratio.upper)) +
  geom_pointrange()

## -----------------------------------------------------------------------------
x <- list(LETTERS, letters)
rvec(x)

## -----------------------------------------------------------------------------
x <- matrix(rnorm(2000), nrow = 2)
rvec(x)

## -----------------------------------------------------------------------------
x <- c(TRUE, FALSE)
rvec(x)

## -----------------------------------------------------------------------------
x <- list(1:3)
rvec(x)
rvec_dbl(x)
rvec_chr(x)

## -----------------------------------------------------------------------------
x <- rvec(list(c(TRUE, FALSE),
               c(TRUE, TRUE)))
x	       
all(x)
any(x)

## -----------------------------------------------------------------------------
logit <- function(p) log(p / (1-p))
tibble(
  x = rvec(list(c(0.2, 0.4),
                c(0.6, 0.9))),
  y = logit(x)
)

## -----------------------------------------------------------------------------
m <- rbind(c(1, 1),
           c(0, 1))
x <- rvec(list(1:2,
               3:4))
m %*% x

## -----------------------------------------------------------------------------
divorce_ratio |> 
  select(age, ratio) |>
  mutate(rank = rank(ratio))

## -----------------------------------------------------------------------------
y <- rvec(list(c(-1, 0.2),
               c(3, -7)))
mu <- rvec(list(c(0, 1),
                c(0, -1)))
dnorm_rvec(y, mean = mu, sd = 3)
rbinom_rvec(n = 2, size = round(y+10), prob = 0.8)

## -----------------------------------------------------------------------------
rnorm_rvec(n = 3, mean = 100, sd = 10, n_draw = 2)

## -----------------------------------------------------------------------------
x <- rvec(list(a = 1:2,
               b = 3:4,
               c = 5:6))
x[1]  ## element number
x[c("a", "c")]  ## element name
x[c(TRUE, FALSE, TRUE)]  ## logical flag

## -----------------------------------------------------------------------------
x <- rvec(list(1:2,
               3:4))
if_else(condition = c(TRUE, FALSE), 
        true = x,
        false = -x)        

## -----------------------------------------------------------------------------
if_else_rvec(x <= 2, x, 2)

## -----------------------------------------------------------------------------
x <- rvec(list(c(1, 3.3),
               c(NA, -2)))
x
x_recode <- if_else_rvec(is.na(x), 99, x)
x_recode

## -----------------------------------------------------------------------------
x1 <- rvec(list(c(0.1, 0.2),
                c(0.3, 0.4)))
x2 <- rvec(list(c(0.5, 0.6),
                c(0.7, 0.8)))
c(x1, x2)

## -----------------------------------------------------------------------------
rbind(x1, x2)
cbind(x1, x2)

## -----------------------------------------------------------------------------
df1 <- data.frame(x1)
df2 <- data.frame(x2)
cbind(df1, df2)

## -----------------------------------------------------------------------------
library(vctrs, warn.conflicts = FALSE)
vec_cbind(a = x1, b = x2)

## -----------------------------------------------------------------------------
l <- list(a = rvec(list(c(1, 4))),
          b = rvec(list(c(9, 16))))
l
map_rvec(l, sqrt)

## -----------------------------------------------------------------------------
m <- matrix(1:6, nr = 2)
m
x <- rvec(m)
x
as.matrix(x)

## -----------------------------------------------------------------------------
as_list_col(x)

## -----------------------------------------------------------------------------
divorce |>
  head(2)
divorce |>
  collapse_to_rvec(values = rate) |>
  head(2)
divorce |>
  collapse_to_rvec(values = rate) |>
  expand_from_rvec() |>
  head(2)

## -----------------------------------------------------------------------------
divorce_rv <- divorce |>
  collapse_to_rvec(value = rate)
divorce_rv
divorce_rv |>
  mutate(draws_ci(rate))

## ----echo = FALSE-------------------------------------------------------------
set.seed(0)
mi_data <- tibble::tibble(
  sex = rep(c("Female", "Male"), each = 3),
  imputed_dataset = rep(1:3, times = 2),
  value = rnorm_rvec(n = 6,
                     mean = c(0.9, 1.2, 1.1, 0.8, 0.7, 0.5),
		     sd = 0.2,
		     n_draw = 1000)
  )

## -----------------------------------------------------------------------------
mi_data
mi_data |>
  pool_draws(by = sex)

