/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.Serializable;
import org.ejml.ops.ComplexMath64F;

public class Complex64F
implements Serializable {
    public double real;
    public double imaginary;

    public Complex64F(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public Complex64F() {
    }

    public double getReal() {
        return this.real;
    }

    public double getMagnitude() {
        return Math.sqrt(this.real * this.real + this.imaginary * this.imaginary);
    }

    public double getMagnitude2() {
        return this.real * this.real + this.imaginary * this.imaginary;
    }

    public void setReal(double real) {
        this.real = real;
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public void setImaginary(double imaginary) {
        this.imaginary = imaginary;
    }

    public void set(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public void set(Complex64F a) {
        this.real = a.real;
        this.imaginary = a.imaginary;
    }

    public boolean isReal() {
        return this.imaginary == 0.0;
    }

    public String toString() {
        if (this.imaginary == 0.0) {
            return "" + this.real;
        }
        return this.real + " " + this.imaginary + "i";
    }

    public Complex64F plus(Complex64F a) {
        Complex64F ret = new Complex64F();
        ComplexMath64F.plus(this, a, ret);
        return ret;
    }

    public Complex64F minus(Complex64F a) {
        Complex64F ret = new Complex64F();
        ComplexMath64F.minus(this, a, ret);
        return ret;
    }

    public Complex64F times(Complex64F a) {
        Complex64F ret = new Complex64F();
        ComplexMath64F.multiply(this, a, ret);
        return ret;
    }

    public Complex64F divide(Complex64F a) {
        Complex64F ret = new Complex64F();
        ComplexMath64F.divide(this, a, ret);
        return ret;
    }
}

