## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(graphonmix)
library(ggplot2)
library(igraph)
requireNamespace("gridExtra", quietly = TRUE)

## -----------------------------------------------------------------------------
g1 <- make_star(4,mode = "undirected")
g1 <- add_vertices(g1, 1)
g1 <- add_edges(g1,c(4,5))

lg1 <- make_line_graph(g1)

oldpar <- par(mfrow = c(1,2))
plot(g1, vertex.label = NA, edge.label = c(1,2,3,4), main = "Graph G")
plot(lg1, vertex.label = c(1,2,3,4), vertex.size = 20, main = "Line graph L(G)")
par(oldpar)

## -----------------------------------------------------------------------------
st <- make_star(10, mode = "undirected")
lgr_st <- make_line_graph(st)

oldpar <- par(mfrow = c(1,2))
plot(st, vertex.label = NA, main = "Star graph G")
plot(lgr_st, vertex.label = NA,  main = "Line graph L(G) of a star")
par(oldpar)

## -----------------------------------------------------------------------------
stardensity <- gnpdensity <- rep(0, 20)
 
for(i in 1:20){
  n <- i*100
  gr1 <- sample_gnp(n, p = 0.1)
  gnpdensity[i] <- edge_density(gr1)
  gr2 <- make_star(n, mode = "undirected")
  stardensity[i] <- edge_density(gr2)
}
gnpdensity
stardensity

## -----------------------------------------------------------------------------
gr <- make_star(10, mode = "undirected")
emp <- empirical_graphon(gr)
plot_graphon(emp) + coord_fixed()

## -----------------------------------------------------------------------------
gr <- make_star(20, mode = "undirected")
emp <- empirical_graphon(gr)
g1 <- plot_graphon(emp) + coord_fixed() + ggtitle('n = 10')

gr <- make_star(100, mode = "undirected") 
emp <- empirical_graphon(gr)
g2 <- plot_graphon(emp) + coord_fixed() + ggtitle('n = 100')

gr <- make_star(200, mode = "undirected")
emp <- empirical_graphon(gr)
g3 <- plot_graphon(emp) + coord_fixed() + ggtitle('n = 200')


gridExtra::grid.arrange(g1, g2, g3, nrow = 1)


## -----------------------------------------------------------------------------
gr1 <- make_star(10, mode = "undirected")
gr <- gr1 %du% gr1
lgr <- make_line_graph(gr)
emp <- empirical_graphon(lgr)
g1 <- plot_graphon(emp) + coord_fixed() + ggtitle('n = 20')


gr1 <- make_star(50, mode = "undirected")
gr <- gr1 %du% gr1
lgr <- make_line_graph(gr)
emp <- empirical_graphon(lgr)
g2 <- plot_graphon(emp) + coord_fixed() + ggtitle('n = 100')


gr1 <- make_star(100, mode = "undirected")
gr <- gr1 %du% gr1
lgr <- make_line_graph(gr)
emp <- empirical_graphon(lgr)
g3 <- plot_graphon(emp) + coord_fixed() + ggtitle('n = 200')


gridExtra::grid.arrange(g1, g2, g3, nrow = 1)



## -----------------------------------------------------------------------------
wts <- c(0.5, 0.3, 0.2)
U <-  line_graphon(wts)
gr <- sample_graphon(U, n = 100)
plot(gr,
     vertex.size = 1,
     edge.color = "lightgray",     # Light colored edges
     vertex.label = NA,
     vertex.color = "lightblue"
)

## -----------------------------------------------------------------------------
grsp <- generate_star_union(wts, n = 100)
plot(grsp,
     edge.curved = 0.3,
     vertex.size = 1,
     edge.color = "lightgray",     # Light colored edges
     vertex.label = NA,
     vertex.color = "lightblue"
)

