/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied. See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

// source: src/main/proto/TenantManagementService.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();


var TenantProfileService_pb = require('../../core-services/tenant-profile/TenantProfileService_pb.js');
goog.object.extend(proto, TenantProfileService_pb);
var google_protobuf_empty_pb = require('google-protobuf/google/protobuf/empty_pb.js');
goog.object.extend(proto, google_protobuf_empty_pb);
var IamAdminService_pb = require('../../core-services/iam-admin-service/IamAdminService_pb.js');
goog.object.extend(proto, IamAdminService_pb);
goog.exportSymbol('proto.org.apache.custos.tenant.management.service.CreateTenantResponse', null, global);
goog.exportSymbol('proto.org.apache.custos.tenant.management.service.Credentials', null, global);
goog.exportSymbol('proto.org.apache.custos.tenant.management.service.DeleteTenantRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.tenant.management.service.GetCredentialsRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.tenant.management.service.GetCredentialsResponse', null, global);
goog.exportSymbol('proto.org.apache.custos.tenant.management.service.GetTenantRequest', null, global);
goog.exportSymbol('proto.org.apache.custos.tenant.management.service.GetTenantResponse', null, global);
goog.exportSymbol('proto.org.apache.custos.tenant.management.service.UpdateTenantRequest', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.tenant.management.service.CreateTenantResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.tenant.management.service.CreateTenantResponse.displayName = 'proto.org.apache.custos.tenant.management.service.CreateTenantResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.org.apache.custos.tenant.management.service.GetTenantResponse.repeatedFields_, null);
};
goog.inherits(proto.org.apache.custos.tenant.management.service.GetTenantResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.tenant.management.service.GetTenantResponse.displayName = 'proto.org.apache.custos.tenant.management.service.GetTenantResponse';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.tenant.management.service.GetTenantRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.tenant.management.service.GetTenantRequest.displayName = 'proto.org.apache.custos.tenant.management.service.GetTenantRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.tenant.management.service.Credentials = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.tenant.management.service.Credentials, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.tenant.management.service.Credentials.displayName = 'proto.org.apache.custos.tenant.management.service.Credentials';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.tenant.management.service.UpdateTenantRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.displayName = 'proto.org.apache.custos.tenant.management.service.UpdateTenantRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.tenant.management.service.DeleteTenantRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.displayName = 'proto.org.apache.custos.tenant.management.service.DeleteTenantRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.tenant.management.service.GetCredentialsRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.displayName = 'proto.org.apache.custos.tenant.management.service.GetCredentialsRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.org.apache.custos.tenant.management.service.GetCredentialsResponse, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.displayName = 'proto.org.apache.custos.tenant.management.service.GetCredentialsResponse';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.tenant.management.service.CreateTenantResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
    clientId: jspb.Message.getFieldWithDefault(msg, 1, ""),
    clientSecret: jspb.Message.getFieldWithDefault(msg, 2, ""),
    isActivated: jspb.Message.getBooleanFieldWithDefault(msg, 3, false),
    clientIdIssuedAt: jspb.Message.getFloatingPointFieldWithDefault(msg, 4, 0.0),
    clientSecretExpiresAt: jspb.Message.getFloatingPointFieldWithDefault(msg, 5, 0.0),
    registrationClientUri: jspb.Message.getFieldWithDefault(msg, 6, ""),
    tokenEndpointAuthMethod: jspb.Message.getFieldWithDefault(msg, 17, ""),
    msg: jspb.Message.getFieldWithDefault(msg, 7, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.tenant.management.service.CreateTenantResponse;
  return proto.org.apache.custos.tenant.management.service.CreateTenantResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientId(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientSecret(value);
      break;
    case 3:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setIsActivated(value);
      break;
    case 4:
      var value = /** @type {number} */ (reader.readDouble());
      msg.setClientIdIssuedAt(value);
      break;
    case 5:
      var value = /** @type {number} */ (reader.readDouble());
      msg.setClientSecretExpiresAt(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setRegistrationClientUri(value);
      break;
    case 17:
      var value = /** @type {string} */ (reader.readString());
      msg.setTokenEndpointAuthMethod(value);
      break;
    case 7:
      var value = /** @type {string} */ (reader.readString());
      msg.setMsg(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.tenant.management.service.CreateTenantResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getClientId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getClientSecret();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getIsActivated();
  if (f) {
    writer.writeBool(
      3,
      f
    );
  }
  f = message.getClientIdIssuedAt();
  if (f !== 0.0) {
    writer.writeDouble(
      4,
      f
    );
  }
  f = message.getClientSecretExpiresAt();
  if (f !== 0.0) {
    writer.writeDouble(
      5,
      f
    );
  }
  f = message.getRegistrationClientUri();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getTokenEndpointAuthMethod();
  if (f.length > 0) {
    writer.writeString(
      17,
      f
    );
  }
  f = message.getMsg();
  if (f.length > 0) {
    writer.writeString(
      7,
      f
    );
  }
};


/**
 * optional string client_id = 1;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.getClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.setClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string client_secret = 2;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.getClientSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.setClientSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional bool is_activated = 3;
 * @return {boolean}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.getIsActivated = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 3, false));
};


/**
 * @param {boolean} value
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.setIsActivated = function(value) {
  return jspb.Message.setProto3BooleanField(this, 3, value);
};


/**
 * optional double client_id_issued_at = 4;
 * @return {number}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.getClientIdIssuedAt = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 4, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.setClientIdIssuedAt = function(value) {
  return jspb.Message.setProto3FloatField(this, 4, value);
};


/**
 * optional double client_secret_expires_at = 5;
 * @return {number}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.getClientSecretExpiresAt = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 5, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.setClientSecretExpiresAt = function(value) {
  return jspb.Message.setProto3FloatField(this, 5, value);
};


/**
 * optional string registration_client_uri = 6;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.getRegistrationClientUri = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.setRegistrationClientUri = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * optional string token_endpoint_auth_method = 17;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.getTokenEndpointAuthMethod = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 17, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.setTokenEndpointAuthMethod = function(value) {
  return jspb.Message.setProto3StringField(this, 17, value);
};


/**
 * optional string msg = 7;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.getMsg = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 7, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.CreateTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.CreateTenantResponse.prototype.setMsg = function(value) {
  return jspb.Message.setProto3StringField(this, 7, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.repeatedFields_ = [7,8,9];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.tenant.management.service.GetTenantResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
    clientId: jspb.Message.getFieldWithDefault(msg, 1, ""),
    clientName: jspb.Message.getFieldWithDefault(msg, 2, ""),
    requesterEmail: jspb.Message.getFieldWithDefault(msg, 3, ""),
    adminFirstName: jspb.Message.getFieldWithDefault(msg, 4, ""),
    adminLastName: jspb.Message.getFieldWithDefault(msg, 5, ""),
    adminEmail: jspb.Message.getFieldWithDefault(msg, 6, ""),
    contactsList: (f = jspb.Message.getRepeatedField(msg, 7)) == null ? undefined : f,
    redirectUrisList: (f = jspb.Message.getRepeatedField(msg, 8)) == null ? undefined : f,
    grantTypesList: (f = jspb.Message.getRepeatedField(msg, 9)) == null ? undefined : f,
    clientIdIssuedAt: jspb.Message.getFloatingPointFieldWithDefault(msg, 10, 0.0),
    clientUri: jspb.Message.getFieldWithDefault(msg, 11, ""),
    scope: jspb.Message.getFieldWithDefault(msg, 12, ""),
    domain: jspb.Message.getFieldWithDefault(msg, 13, ""),
    comment: jspb.Message.getFieldWithDefault(msg, 14, ""),
    logoUri: jspb.Message.getFieldWithDefault(msg, 15, ""),
    applicationType: jspb.Message.getFieldWithDefault(msg, 16, ""),
    jwksUri: jspb.Message.getFieldWithDefault(msg, 17, ""),
    exampleExtensionParameter: jspb.Message.getFieldWithDefault(msg, 18, ""),
    tosUri: jspb.Message.getFieldWithDefault(msg, 19, ""),
    policyUri: jspb.Message.getFieldWithDefault(msg, 20, ""),
    jwksMap: (f = msg.getJwksMap()) ? f.toObject(includeInstance, undefined) : [],
    softwareId: jspb.Message.getFieldWithDefault(msg, 22, ""),
    softwareVersion: jspb.Message.getFieldWithDefault(msg, 23, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.tenant.management.service.GetTenantResponse;
  return proto.org.apache.custos.tenant.management.service.GetTenantResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientId(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientName(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setRequesterEmail(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setAdminFirstName(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setAdminLastName(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setAdminEmail(value);
      break;
    case 7:
      var value = /** @type {string} */ (reader.readString());
      msg.addContacts(value);
      break;
    case 8:
      var value = /** @type {string} */ (reader.readString());
      msg.addRedirectUris(value);
      break;
    case 9:
      var value = /** @type {string} */ (reader.readString());
      msg.addGrantTypes(value);
      break;
    case 10:
      var value = /** @type {number} */ (reader.readDouble());
      msg.setClientIdIssuedAt(value);
      break;
    case 11:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientUri(value);
      break;
    case 12:
      var value = /** @type {string} */ (reader.readString());
      msg.setScope(value);
      break;
    case 13:
      var value = /** @type {string} */ (reader.readString());
      msg.setDomain(value);
      break;
    case 14:
      var value = /** @type {string} */ (reader.readString());
      msg.setComment(value);
      break;
    case 15:
      var value = /** @type {string} */ (reader.readString());
      msg.setLogoUri(value);
      break;
    case 16:
      var value = /** @type {string} */ (reader.readString());
      msg.setApplicationType(value);
      break;
    case 17:
      var value = /** @type {string} */ (reader.readString());
      msg.setJwksUri(value);
      break;
    case 18:
      var value = /** @type {string} */ (reader.readString());
      msg.setExampleExtensionParameter(value);
      break;
    case 19:
      var value = /** @type {string} */ (reader.readString());
      msg.setTosUri(value);
      break;
    case 20:
      var value = /** @type {string} */ (reader.readString());
      msg.setPolicyUri(value);
      break;
    case 21:
      var value = msg.getJwksMap();
      reader.readMessage(value, function(message, reader) {
        jspb.Map.deserializeBinary(message, reader, jspb.BinaryReader.prototype.readString, jspb.BinaryReader.prototype.readString, null, "", "");
         });
      break;
    case 22:
      var value = /** @type {string} */ (reader.readString());
      msg.setSoftwareId(value);
      break;
    case 23:
      var value = /** @type {string} */ (reader.readString());
      msg.setSoftwareVersion(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.tenant.management.service.GetTenantResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getClientId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getClientName();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getRequesterEmail();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getAdminFirstName();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
  f = message.getAdminLastName();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getAdminEmail();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getContactsList();
  if (f.length > 0) {
    writer.writeRepeatedString(
      7,
      f
    );
  }
  f = message.getRedirectUrisList();
  if (f.length > 0) {
    writer.writeRepeatedString(
      8,
      f
    );
  }
  f = message.getGrantTypesList();
  if (f.length > 0) {
    writer.writeRepeatedString(
      9,
      f
    );
  }
  f = message.getClientIdIssuedAt();
  if (f !== 0.0) {
    writer.writeDouble(
      10,
      f
    );
  }
  f = message.getClientUri();
  if (f.length > 0) {
    writer.writeString(
      11,
      f
    );
  }
  f = message.getScope();
  if (f.length > 0) {
    writer.writeString(
      12,
      f
    );
  }
  f = message.getDomain();
  if (f.length > 0) {
    writer.writeString(
      13,
      f
    );
  }
  f = message.getComment();
  if (f.length > 0) {
    writer.writeString(
      14,
      f
    );
  }
  f = message.getLogoUri();
  if (f.length > 0) {
    writer.writeString(
      15,
      f
    );
  }
  f = message.getApplicationType();
  if (f.length > 0) {
    writer.writeString(
      16,
      f
    );
  }
  f = message.getJwksUri();
  if (f.length > 0) {
    writer.writeString(
      17,
      f
    );
  }
  f = message.getExampleExtensionParameter();
  if (f.length > 0) {
    writer.writeString(
      18,
      f
    );
  }
  f = message.getTosUri();
  if (f.length > 0) {
    writer.writeString(
      19,
      f
    );
  }
  f = message.getPolicyUri();
  if (f.length > 0) {
    writer.writeString(
      20,
      f
    );
  }
  f = message.getJwksMap(true);
  if (f && f.getLength() > 0) {
    f.serializeBinary(21, writer, jspb.BinaryWriter.prototype.writeString, jspb.BinaryWriter.prototype.writeString);
  }
  f = message.getSoftwareId();
  if (f.length > 0) {
    writer.writeString(
      22,
      f
    );
  }
  f = message.getSoftwareVersion();
  if (f.length > 0) {
    writer.writeString(
      23,
      f
    );
  }
};


/**
 * optional string client_id = 1;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string client_name = 2;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getClientName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setClientName = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string requester_email = 3;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getRequesterEmail = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setRequesterEmail = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string admin_first_name = 4;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getAdminFirstName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setAdminFirstName = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


/**
 * optional string admin_last_name = 5;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getAdminLastName = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setAdminLastName = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string admin_email = 6;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getAdminEmail = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setAdminEmail = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * repeated string contacts = 7;
 * @return {!Array<string>}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getContactsList = function() {
  return /** @type {!Array<string>} */ (jspb.Message.getRepeatedField(this, 7));
};


/**
 * @param {!Array<string>} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setContactsList = function(value) {
  return jspb.Message.setField(this, 7, value || []);
};


/**
 * @param {string} value
 * @param {number=} opt_index
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.addContacts = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 7, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.clearContactsList = function() {
  return this.setContactsList([]);
};


/**
 * repeated string redirect_uris = 8;
 * @return {!Array<string>}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getRedirectUrisList = function() {
  return /** @type {!Array<string>} */ (jspb.Message.getRepeatedField(this, 8));
};


/**
 * @param {!Array<string>} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setRedirectUrisList = function(value) {
  return jspb.Message.setField(this, 8, value || []);
};


/**
 * @param {string} value
 * @param {number=} opt_index
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.addRedirectUris = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 8, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.clearRedirectUrisList = function() {
  return this.setRedirectUrisList([]);
};


/**
 * repeated string grant_types = 9;
 * @return {!Array<string>}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getGrantTypesList = function() {
  return /** @type {!Array<string>} */ (jspb.Message.getRepeatedField(this, 9));
};


/**
 * @param {!Array<string>} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setGrantTypesList = function(value) {
  return jspb.Message.setField(this, 9, value || []);
};


/**
 * @param {string} value
 * @param {number=} opt_index
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.addGrantTypes = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 9, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.clearGrantTypesList = function() {
  return this.setGrantTypesList([]);
};


/**
 * optional double client_id_issued_at = 10;
 * @return {number}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getClientIdIssuedAt = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 10, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setClientIdIssuedAt = function(value) {
  return jspb.Message.setProto3FloatField(this, 10, value);
};


/**
 * optional string client_uri = 11;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getClientUri = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 11, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setClientUri = function(value) {
  return jspb.Message.setProto3StringField(this, 11, value);
};


/**
 * optional string scope = 12;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getScope = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 12, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setScope = function(value) {
  return jspb.Message.setProto3StringField(this, 12, value);
};


/**
 * optional string domain = 13;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getDomain = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 13, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setDomain = function(value) {
  return jspb.Message.setProto3StringField(this, 13, value);
};


/**
 * optional string comment = 14;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getComment = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 14, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setComment = function(value) {
  return jspb.Message.setProto3StringField(this, 14, value);
};


/**
 * optional string logo_uri = 15;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getLogoUri = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 15, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setLogoUri = function(value) {
  return jspb.Message.setProto3StringField(this, 15, value);
};


/**
 * optional string application_type = 16;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getApplicationType = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 16, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setApplicationType = function(value) {
  return jspb.Message.setProto3StringField(this, 16, value);
};


/**
 * optional string jwks_uri = 17;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getJwksUri = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 17, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setJwksUri = function(value) {
  return jspb.Message.setProto3StringField(this, 17, value);
};


/**
 * optional string example_extension_parameter = 18;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getExampleExtensionParameter = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 18, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setExampleExtensionParameter = function(value) {
  return jspb.Message.setProto3StringField(this, 18, value);
};


/**
 * optional string tos_uri = 19;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getTosUri = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 19, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setTosUri = function(value) {
  return jspb.Message.setProto3StringField(this, 19, value);
};


/**
 * optional string policy_uri = 20;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getPolicyUri = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 20, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setPolicyUri = function(value) {
  return jspb.Message.setProto3StringField(this, 20, value);
};


/**
 * map<string, string> jwks = 21;
 * @param {boolean=} opt_noLazyCreate Do not create the map if
 * empty, instead returning `undefined`
 * @return {!jspb.Map<string,string>}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getJwksMap = function(opt_noLazyCreate) {
  return /** @type {!jspb.Map<string,string>} */ (
      jspb.Message.getMapField(this, 21, opt_noLazyCreate,
      null));
};


/**
 * Clears values from the map. The map will be non-null.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.clearJwksMap = function() {
  this.getJwksMap().clear();
  return this;};


/**
 * optional string software_id = 22;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getSoftwareId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 22, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setSoftwareId = function(value) {
  return jspb.Message.setProto3StringField(this, 22, value);
};


/**
 * optional string software_version = 23;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.getSoftwareVersion = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 23, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantResponse.prototype.setSoftwareVersion = function(value) {
  return jspb.Message.setProto3StringField(this, 23, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.tenant.management.service.GetTenantRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.tenant.management.service.GetTenantRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    clientId: jspb.Message.getFieldWithDefault(msg, 1, ""),
    tenantId: jspb.Message.getFieldWithDefault(msg, 2, 0),
    tenant: (f = msg.getTenant()) && TenantProfileService_pb.Tenant.toObject(includeInstance, f),
    credentials: (f = msg.getCredentials()) && proto.org.apache.custos.tenant.management.service.Credentials.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantRequest}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.tenant.management.service.GetTenantRequest;
  return proto.org.apache.custos.tenant.management.service.GetTenantRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.tenant.management.service.GetTenantRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantRequest}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientId(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantId(value);
      break;
    case 4:
      var value = new TenantProfileService_pb.Tenant;
      reader.readMessage(value,TenantProfileService_pb.Tenant.deserializeBinaryFromReader);
      msg.setTenant(value);
      break;
    case 5:
      var value = new proto.org.apache.custos.tenant.management.service.Credentials;
      reader.readMessage(value,proto.org.apache.custos.tenant.management.service.Credentials.deserializeBinaryFromReader);
      msg.setCredentials(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.tenant.management.service.GetTenantRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.tenant.management.service.GetTenantRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getClientId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getTenantId();
  if (f !== 0) {
    writer.writeInt64(
      2,
      f
    );
  }
  f = message.getTenant();
  if (f != null) {
    writer.writeMessage(
      4,
      f,
      TenantProfileService_pb.Tenant.serializeBinaryToWriter
    );
  }
  f = message.getCredentials();
  if (f != null) {
    writer.writeMessage(
      5,
      f,
      proto.org.apache.custos.tenant.management.service.Credentials.serializeBinaryToWriter
    );
  }
};


/**
 * optional string client_id = 1;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.getClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.setClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional int64 tenant_id = 2;
 * @return {number}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.getTenantId = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.setTenantId = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};


/**
 * optional org.apache.custos.tenant.profile.service.Tenant tenant = 4;
 * @return {?proto.org.apache.custos.tenant.profile.service.Tenant}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.getTenant = function() {
  return /** @type{?proto.org.apache.custos.tenant.profile.service.Tenant} */ (
    jspb.Message.getWrapperField(this, TenantProfileService_pb.Tenant, 4));
};


/**
 * @param {?proto.org.apache.custos.tenant.profile.service.Tenant|undefined} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantRequest} returns this
*/
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.setTenant = function(value) {
  return jspb.Message.setWrapperField(this, 4, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.clearTenant = function() {
  return this.setTenant(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.hasTenant = function() {
  return jspb.Message.getField(this, 4) != null;
};


/**
 * optional Credentials credentials = 5;
 * @return {?proto.org.apache.custos.tenant.management.service.Credentials}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.getCredentials = function() {
  return /** @type{?proto.org.apache.custos.tenant.management.service.Credentials} */ (
    jspb.Message.getWrapperField(this, proto.org.apache.custos.tenant.management.service.Credentials, 5));
};


/**
 * @param {?proto.org.apache.custos.tenant.management.service.Credentials|undefined} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantRequest} returns this
*/
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.setCredentials = function(value) {
  return jspb.Message.setWrapperField(this, 5, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.tenant.management.service.GetTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.clearCredentials = function() {
  return this.setCredentials(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.tenant.management.service.GetTenantRequest.prototype.hasCredentials = function() {
  return jspb.Message.getField(this, 5) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.tenant.management.service.Credentials.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.tenant.management.service.Credentials} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.Credentials.toObject = function(includeInstance, msg) {
  var f, obj = {
    iamClientId: jspb.Message.getFieldWithDefault(msg, 1, ""),
    iamClientSecret: jspb.Message.getFieldWithDefault(msg, 2, ""),
    ciLogonClientId: jspb.Message.getFieldWithDefault(msg, 3, ""),
    ciLogonClientSecret: jspb.Message.getFieldWithDefault(msg, 4, ""),
    custosClientId: jspb.Message.getFieldWithDefault(msg, 5, ""),
    custosClientSecret: jspb.Message.getFieldWithDefault(msg, 6, ""),
    custosClientIdIssuedAt: jspb.Message.getFloatingPointFieldWithDefault(msg, 7, 0.0),
    custosClientSecretExpiredAt: jspb.Message.getFloatingPointFieldWithDefault(msg, 8, 0.0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials}
 */
proto.org.apache.custos.tenant.management.service.Credentials.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.tenant.management.service.Credentials;
  return proto.org.apache.custos.tenant.management.service.Credentials.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.tenant.management.service.Credentials} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials}
 */
proto.org.apache.custos.tenant.management.service.Credentials.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamClientId(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamClientSecret(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setCiLogonClientId(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setCiLogonClientSecret(value);
      break;
    case 5:
      var value = /** @type {string} */ (reader.readString());
      msg.setCustosClientId(value);
      break;
    case 6:
      var value = /** @type {string} */ (reader.readString());
      msg.setCustosClientSecret(value);
      break;
    case 7:
      var value = /** @type {number} */ (reader.readDouble());
      msg.setCustosClientIdIssuedAt(value);
      break;
    case 8:
      var value = /** @type {number} */ (reader.readDouble());
      msg.setCustosClientSecretExpiredAt(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.tenant.management.service.Credentials.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.tenant.management.service.Credentials} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.Credentials.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getIamClientId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getIamClientSecret();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getCiLogonClientId();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getCiLogonClientSecret();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
  f = message.getCustosClientId();
  if (f.length > 0) {
    writer.writeString(
      5,
      f
    );
  }
  f = message.getCustosClientSecret();
  if (f.length > 0) {
    writer.writeString(
      6,
      f
    );
  }
  f = message.getCustosClientIdIssuedAt();
  if (f !== 0.0) {
    writer.writeDouble(
      7,
      f
    );
  }
  f = message.getCustosClientSecretExpiredAt();
  if (f !== 0.0) {
    writer.writeDouble(
      8,
      f
    );
  }
};


/**
 * optional string iam_client_id = 1;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.getIamClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials} returns this
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.setIamClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string iam_client_secret = 2;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.getIamClientSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials} returns this
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.setIamClientSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string ci_logon_client_id = 3;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.getCiLogonClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials} returns this
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.setCiLogonClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string ci_logon_client_secret = 4;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.getCiLogonClientSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials} returns this
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.setCiLogonClientSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


/**
 * optional string custos_client_id = 5;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.getCustosClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials} returns this
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.setCustosClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 5, value);
};


/**
 * optional string custos_client_secret = 6;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.getCustosClientSecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials} returns this
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.setCustosClientSecret = function(value) {
  return jspb.Message.setProto3StringField(this, 6, value);
};


/**
 * optional double custos_client_id_issued_at = 7;
 * @return {number}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.getCustosClientIdIssuedAt = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 7, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials} returns this
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.setCustosClientIdIssuedAt = function(value) {
  return jspb.Message.setProto3FloatField(this, 7, value);
};


/**
 * optional double custos_client_secret_expired_at = 8;
 * @return {number}
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.getCustosClientSecretExpiredAt = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 8, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.tenant.management.service.Credentials} returns this
 */
proto.org.apache.custos.tenant.management.service.Credentials.prototype.setCustosClientSecretExpiredAt = function(value) {
  return jspb.Message.setProto3FloatField(this, 8, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    clientId: jspb.Message.getFieldWithDefault(msg, 1, ""),
    tenantId: jspb.Message.getFieldWithDefault(msg, 2, 0),
    credentials: (f = msg.getCredentials()) && proto.org.apache.custos.tenant.management.service.Credentials.toObject(includeInstance, f),
    body: (f = msg.getBody()) && TenantProfileService_pb.Tenant.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.tenant.management.service.UpdateTenantRequest;
  return proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientId(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantId(value);
      break;
    case 3:
      var value = new proto.org.apache.custos.tenant.management.service.Credentials;
      reader.readMessage(value,proto.org.apache.custos.tenant.management.service.Credentials.deserializeBinaryFromReader);
      msg.setCredentials(value);
      break;
    case 4:
      var value = new TenantProfileService_pb.Tenant;
      reader.readMessage(value,TenantProfileService_pb.Tenant.deserializeBinaryFromReader);
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getClientId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getTenantId();
  if (f !== 0) {
    writer.writeInt64(
      2,
      f
    );
  }
  f = message.getCredentials();
  if (f != null) {
    writer.writeMessage(
      3,
      f,
      proto.org.apache.custos.tenant.management.service.Credentials.serializeBinaryToWriter
    );
  }
  f = message.getBody();
  if (f != null) {
    writer.writeMessage(
      4,
      f,
      TenantProfileService_pb.Tenant.serializeBinaryToWriter
    );
  }
};


/**
 * optional string client_id = 1;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.getClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.setClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional int64 tenant_id = 2;
 * @return {number}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.getTenantId = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.setTenantId = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};


/**
 * optional Credentials credentials = 3;
 * @return {?proto.org.apache.custos.tenant.management.service.Credentials}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.getCredentials = function() {
  return /** @type{?proto.org.apache.custos.tenant.management.service.Credentials} */ (
    jspb.Message.getWrapperField(this, proto.org.apache.custos.tenant.management.service.Credentials, 3));
};


/**
 * @param {?proto.org.apache.custos.tenant.management.service.Credentials|undefined} value
 * @return {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest} returns this
*/
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.setCredentials = function(value) {
  return jspb.Message.setWrapperField(this, 3, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.clearCredentials = function() {
  return this.setCredentials(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.hasCredentials = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional org.apache.custos.tenant.profile.service.Tenant body = 4;
 * @return {?proto.org.apache.custos.tenant.profile.service.Tenant}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.getBody = function() {
  return /** @type{?proto.org.apache.custos.tenant.profile.service.Tenant} */ (
    jspb.Message.getWrapperField(this, TenantProfileService_pb.Tenant, 4));
};


/**
 * @param {?proto.org.apache.custos.tenant.profile.service.Tenant|undefined} value
 * @return {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest} returns this
*/
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.setBody = function(value) {
  return jspb.Message.setWrapperField(this, 4, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.tenant.management.service.UpdateTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.clearBody = function() {
  return this.setBody(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.tenant.management.service.UpdateTenantRequest.prototype.hasBody = function() {
  return jspb.Message.getField(this, 4) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    clientId: jspb.Message.getFieldWithDefault(msg, 1, ""),
    tenantId: jspb.Message.getFieldWithDefault(msg, 2, 0),
    credentials: (f = msg.getCredentials()) && proto.org.apache.custos.tenant.management.service.Credentials.toObject(includeInstance, f),
    body: (f = msg.getBody()) && TenantProfileService_pb.Tenant.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.tenant.management.service.DeleteTenantRequest;
  return proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setClientId(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantId(value);
      break;
    case 3:
      var value = new proto.org.apache.custos.tenant.management.service.Credentials;
      reader.readMessage(value,proto.org.apache.custos.tenant.management.service.Credentials.deserializeBinaryFromReader);
      msg.setCredentials(value);
      break;
    case 4:
      var value = new TenantProfileService_pb.Tenant;
      reader.readMessage(value,TenantProfileService_pb.Tenant.deserializeBinaryFromReader);
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getClientId();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getTenantId();
  if (f !== 0) {
    writer.writeInt64(
      2,
      f
    );
  }
  f = message.getCredentials();
  if (f != null) {
    writer.writeMessage(
      3,
      f,
      proto.org.apache.custos.tenant.management.service.Credentials.serializeBinaryToWriter
    );
  }
  f = message.getBody();
  if (f != null) {
    writer.writeMessage(
      4,
      f,
      TenantProfileService_pb.Tenant.serializeBinaryToWriter
    );
  }
};


/**
 * optional string client_id = 1;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.getClientId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.setClientId = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional int64 tenant_id = 2;
 * @return {number}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.getTenantId = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.setTenantId = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};


/**
 * optional Credentials credentials = 3;
 * @return {?proto.org.apache.custos.tenant.management.service.Credentials}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.getCredentials = function() {
  return /** @type{?proto.org.apache.custos.tenant.management.service.Credentials} */ (
    jspb.Message.getWrapperField(this, proto.org.apache.custos.tenant.management.service.Credentials, 3));
};


/**
 * @param {?proto.org.apache.custos.tenant.management.service.Credentials|undefined} value
 * @return {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest} returns this
*/
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.setCredentials = function(value) {
  return jspb.Message.setWrapperField(this, 3, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.clearCredentials = function() {
  return this.setCredentials(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.hasCredentials = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional org.apache.custos.tenant.profile.service.Tenant body = 4;
 * @return {?proto.org.apache.custos.tenant.profile.service.Tenant}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.getBody = function() {
  return /** @type{?proto.org.apache.custos.tenant.profile.service.Tenant} */ (
    jspb.Message.getWrapperField(this, TenantProfileService_pb.Tenant, 4));
};


/**
 * @param {?proto.org.apache.custos.tenant.profile.service.Tenant|undefined} value
 * @return {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest} returns this
*/
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.setBody = function(value) {
  return jspb.Message.setWrapperField(this, 4, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.org.apache.custos.tenant.management.service.DeleteTenantRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.clearBody = function() {
  return this.setBody(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.org.apache.custos.tenant.management.service.DeleteTenantRequest.prototype.hasBody = function() {
  return jspb.Message.getField(this, 4) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.tenant.management.service.GetCredentialsRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    tenantid: jspb.Message.getFieldWithDefault(msg, 1, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.tenant.management.service.GetCredentialsRequest}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.tenant.management.service.GetCredentialsRequest;
  return proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.tenant.management.service.GetCredentialsRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.tenant.management.service.GetCredentialsRequest}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt64());
      msg.setTenantid(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.tenant.management.service.GetCredentialsRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getTenantid();
  if (f !== 0) {
    writer.writeInt64(
      1,
      f
    );
  }
};


/**
 * optional int64 tenantId = 1;
 * @return {number}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.prototype.getTenantid = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetCredentialsRequest} returns this
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsRequest.prototype.setTenantid = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.toObject = function(opt_includeInstance) {
  return proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.org.apache.custos.tenant.management.service.GetCredentialsResponse} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.toObject = function(includeInstance, msg) {
  var f, obj = {
    iamclientid: jspb.Message.getFieldWithDefault(msg, 1, ""),
    iamclientsecret: jspb.Message.getFieldWithDefault(msg, 2, ""),
    cilogonclientid: jspb.Message.getFieldWithDefault(msg, 3, ""),
    cilogonclientsecret: jspb.Message.getFieldWithDefault(msg, 4, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.org.apache.custos.tenant.management.service.GetCredentialsResponse}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.org.apache.custos.tenant.management.service.GetCredentialsResponse;
  return proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.org.apache.custos.tenant.management.service.GetCredentialsResponse} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.org.apache.custos.tenant.management.service.GetCredentialsResponse}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamclientid(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setIamclientsecret(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setCilogonclientid(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setCilogonclientsecret(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.org.apache.custos.tenant.management.service.GetCredentialsResponse} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getIamclientid();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getIamclientsecret();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getCilogonclientid();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getCilogonclientsecret();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
};


/**
 * optional string iamClientId = 1;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.getIamclientid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetCredentialsResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.setIamclientid = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string iamClientSecret = 2;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.getIamclientsecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetCredentialsResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.setIamclientsecret = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string ciLogonClientId = 3;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.getCilogonclientid = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetCredentialsResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.setCilogonclientid = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string ciLogonClientSecret = 4;
 * @return {string}
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.getCilogonclientsecret = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.org.apache.custos.tenant.management.service.GetCredentialsResponse} returns this
 */
proto.org.apache.custos.tenant.management.service.GetCredentialsResponse.prototype.setCilogonclientsecret = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};


goog.object.extend(exports, proto.org.apache.custos.tenant.management.service);
