/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.axis2.jaxws.sample.parallelasync.server;

import org.test.parallelasync.AnotherResponse;
import org.test.parallelasync.CustomAsyncResponse;
import org.test.parallelasync.InvokeAsyncResponse;
import org.test.parallelasync.IsAsleepResponse;
import org.test.parallelasync.PingResponse;
import org.test.parallelasync.SleepResponse;
import org.test.parallelasync.WakeUpResponse;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.Response;
import javax.xml.ws.ResponseWrapper;
import java.util.concurrent.Future;

/**
 * This class was generated by the JAXWS SI.
 * JAX-WS RI 2.0.1-jaxws-rearch-2005-nightly_2006-08-16_02-32-03-M1
 * Generated source version: 2.0
 * 
 */
@WebService(name = "AsyncPort", targetNamespace = "http://org/test/parallelasync")
public interface AsyncPort {


    /**
     * 
     * @param request
     * @return
     *     returns java.lang.String
     */
    @WebMethod(action = "http://org/test/parallelasync/ping")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "ping", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.Ping")
    @ResponseWrapper(localName = "pingResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.PingResponse")
    public String ping(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param message
     * @return
     *     returns javax.xml.ws.Response<org.test.parallelasync.SleepResponse>
     */
    @WebMethod(operationName = "sleep", action = "http://org/test/parallelasync/sleep")
    @RequestWrapper(localName = "sleep", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.Sleep")
    @ResponseWrapper(localName = "sleepResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.SleepResponse")
    public Response<SleepResponse> sleepAsync(
        @WebParam(name = "message", targetNamespace = "")
        String message);

    /**
     * 
     * @param message
     * @param asyncHandler
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "sleep", action = "http://org/test/parallelasync/sleep")
    @RequestWrapper(localName = "sleep", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.Sleep")
    @ResponseWrapper(localName = "sleepResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.SleepResponse")
    public Future<?> sleepAsync(
        @WebParam(name = "message", targetNamespace = "")
        String message,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<SleepResponse> asyncHandler);

    /**
     * 
     * @param message
     */
    @WebMethod(action = "http://org/test/parallelasync/sleep")
    @RequestWrapper(localName = "sleep", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.Sleep")
    @ResponseWrapper(localName = "sleepResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.SleepResponse")
    public void sleep(
        @WebParam(name = "message", targetNamespace = "", mode = WebParam.Mode.INOUT)
        Holder<String> message);


    /**
     * 
     * @return
     *     returns java.lang.String
     */
    @WebMethod(action = "http://org/test/parallelasync/isAsleep")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "isAsleep", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.IsAsleep")
    @ResponseWrapper(localName = "isAsleepResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.IsAsleepResponse")
    public String isAsleep(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @return
     *     returns java.lang.String
     */
    @WebMethod(action = "http://org/test/parallelasync/wakeUp")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "wakeUp", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.WakeUp")
    @ResponseWrapper(localName = "wakeUpResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.WakeUpResponse")
    public String wakeUp(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param request
     * @return
     *     returns javax.xml.ws.Response<org.test.parallelasync.InvokeAsyncResponse>
     */
    @WebMethod(operationName = "invokeAsync", action = "http://org/test/parallelasync/invokeAsync")
    @RequestWrapper(localName = "invokeAsync", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.InvokeAsync")
    @ResponseWrapper(localName = "invokeAsyncResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.InvokeAsyncResponse")
    public Response<InvokeAsyncResponse> invokeAsyncAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param asyncHandler
     * @param request
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "invokeAsync", action = "http://org/test/parallelasync/invokeAsync")
    @RequestWrapper(localName = "invokeAsync", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.InvokeAsync")
    @ResponseWrapper(localName = "invokeAsyncResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.InvokeAsyncResponse")
    public Future<?> invokeAsyncAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<InvokeAsyncResponse> asyncHandler);

    /**
     * 
     * @param request
     * @return
     *     returns java.lang.String
     */
    @WebMethod(action = "http://org/test/parallelasync/invokeAsync")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "invokeAsync", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.InvokeAsync")
    @ResponseWrapper(localName = "invokeAsyncResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.InvokeAsyncResponse")
    public String invokeAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param request
     * @return
     *     returns javax.xml.ws.Response<org.test.parallelasync.CustomAsyncResponse>
     */
    @WebMethod(operationName = "customAsync", action = "http://org/test/parallelasync/customAsync")
    @RequestWrapper(localName = "customAsync", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.CustomAsync")
    @ResponseWrapper(localName = "customAsyncResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.CustomAsyncResponse")
    public Response<CustomAsyncResponse> remappedAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param asyncHandler
     * @param request
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "customAsync", action = "http://org/test/parallelasync/customAsync")
    @RequestWrapper(localName = "customAsync", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.CustomAsync")
    @ResponseWrapper(localName = "customAsyncResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.CustomAsyncResponse")
    public Future<?> remappedAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<CustomAsyncResponse> asyncHandler);

    /**
     * 
     * @param request
     * @return
     *     returns java.lang.String
     */
    @WebMethod(operationName = "customAsync", action = "http://org/test/parallelasync/customAsync")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "customAsync", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.CustomAsync")
    @ResponseWrapper(localName = "customAsyncResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.CustomAsyncResponse")
    public String remapped(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param request
     * @return
     *     returns javax.xml.ws.Response<org.test.parallelasync.AnotherResponse>
     */
    @WebMethod(operationName = "another", action = "http://org/test/parallelasync/another")
    @RequestWrapper(localName = "another", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.Another")
    @ResponseWrapper(localName = "anotherResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.AnotherResponse")
    public Response<AnotherResponse> anotherAsyncAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);

    /**
     * 
     * @param asyncHandler
     * @param request
     * @return
     *     returns java.util.concurrent.Future<? extends java.lang.Object>
     */
    @WebMethod(operationName = "another", action = "http://org/test/parallelasync/another")
    @RequestWrapper(localName = "another", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.Another")
    @ResponseWrapper(localName = "anotherResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.AnotherResponse")
    public Future<?> anotherAsyncAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request,
        @WebParam(name = "asyncHandler", targetNamespace = "")
        AsyncHandler<AnotherResponse> asyncHandler);

    /**
     * 
     * @param request
     * @return
     *     returns java.lang.String
     */
    @WebMethod(operationName = "another", action = "http://org/test/parallelasync/another")
    @WebResult(name = "response", targetNamespace = "")
    @RequestWrapper(localName = "another", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.Another")
    @ResponseWrapper(localName = "anotherResponse", targetNamespace = "http://org/test/parallelasync", className = "org.test.parallelasync.AnotherResponse")
    public String anotherAsync(
        @WebParam(name = "request", targetNamespace = "")
        String request);
    
    /**
     * 
     * @param request
     * @return
     *     returns java.lang.String
     */
    @WebMethod(exclude=true)
    public String customAsync(
        String request);

}
