/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp2.managed.ManagedConnection;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.dbcp2.managed.TransactionRegistry;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestManagedDataSource
extends TestConnectionPool {
    protected PoolingDataSource<PoolableConnection> ds;
    protected GenericObjectPool<PoolableConnection> pool;
    protected TransactionManager transactionManager;

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.transactionManager = new TransactionManagerImpl();
        Properties properties = new Properties();
        properties.setProperty("user", "userName");
        properties.setProperty("password", "password");
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", properties);
        LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.transactionManager, (ConnectionFactory)connectionFactory);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
        this.pool.setMaxTotal(this.getMaxTotal());
        this.pool.setMaxWait(this.getMaxWaitDuration());
        this.ds = new ManagedDataSource(this.pool, xaConnectionFactory.getTransactionRegistry());
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.pool.close();
        super.tearDown();
    }

    @Test
    public void testAccessToUnderlyingConnectionAllowed() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        try (ManagedConnection connection = (ManagedConnection)this.newConnection();){
            Assertions.assertTrue((boolean)connection.isAccessToUnderlyingConnectionAllowed());
            Assertions.assertNotNull((Object)connection.getDelegate());
            Assertions.assertNotNull((Object)connection.getInnermostDelegate());
        }
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        connection = (ManagedConnection)this.newConnection();
        try {
            Assertions.assertFalse((boolean)connection.isAccessToUnderlyingConnectionAllowed());
            Assertions.assertNull((Object)connection.getDelegate());
            Assertions.assertNull((Object)connection.getInnermostDelegate());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testConnectionReturnOnCommit() throws Exception {
        this.transactionManager.begin();
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        if (connectionA != null) {
            connectionA.close();
        }
        this.transactionManager.commit();
        Assertions.assertEquals((long)1L, (long)this.pool.getBorrowedCount());
        Assertions.assertEquals((long)1L, (long)this.pool.getReturnedCount());
        Assertions.assertEquals((int)0, (int)this.pool.getNumActive());
    }

    @Test
    public void testManagedConnectionEqualInnermost() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        try (DelegatingConnection con = (DelegatingConnection)this.getConnection();){
            Connection inner = con.getInnermostDelegate();
            this.ds.setAccessToUnderlyingConnectionAllowed(false);
            DelegatingConnection con2 = new DelegatingConnection(inner);
            Assertions.assertNotEquals((Object)con2, (Object)con);
            Assertions.assertTrue((boolean)con.innermostDelegateEquals(con2.getInnermostDelegate()));
            Assertions.assertTrue((boolean)con2.innermostDelegateEquals(inner));
            Assertions.assertNotEquals((Object)con, (Object)con2);
        }
    }

    @Test
    public void testManagedConnectionEqualsFail() throws Exception {
        try (Connection con1 = this.getConnection();
             Connection con2 = this.getConnection();){
            Assertions.assertNotEquals((Object)con1, (Object)con2);
        }
    }

    @Test
    public void testManagedConnectionEqualsNull() throws Exception {
        try (Connection con1 = this.getConnection();){
            Object con2 = null;
            Assertions.assertNotEquals(con2, (Object)con1);
        }
    }

    @Test
    public void testManagedConnectionEqualsReflexive() throws Exception {
        try (Connection con = this.getConnection();){
            Connection con2 = con;
            Assertions.assertEquals((Object)con2, (Object)con);
            Assertions.assertEquals((Object)con, (Object)con2);
        }
    }

    @Test
    public void testManagedConnectionEqualsSameDelegate() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        ((DelegatingConnection)c[0]).getDelegate().close();
        try (Connection con = this.newConnection();){
            Assertions.assertNotEquals((Object)c[0], (Object)con);
            Assertions.assertEquals((Object)((DelegatingConnection)c[0]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)con).getInnermostDelegateInternal());
            for (Connection element : c) {
                element.close();
            }
        }
    }

    @Test
    public void testManagedConnectionEqualsSameDelegateNoUnderlyingAccess() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        ((DelegatingConnection)c[0]).getDelegate().close();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        try (Connection con = this.newConnection();){
            Assertions.assertNotEquals((Object)c[0], (Object)con);
            Assertions.assertEquals((Object)((DelegatingConnection)c[0]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)con).getInnermostDelegateInternal());
            for (Connection element : c) {
                element.close();
            }
            this.ds.setAccessToUnderlyingConnectionAllowed(true);
        }
    }

    @Test
    public void testManagedConnectionEqualsType() throws Exception {
        try (Connection con1 = this.getConnection();){
            Integer con2 = 0;
            Assertions.assertNotEquals((Object)con2, (Object)con1);
        }
    }

    @Test
    public void testNestedConnections() throws Exception {
        this.transactionManager.begin();
        try (Connection c1 = this.newConnection();
             Connection c2 = this.newConnection();){
            this.transactionManager.commit();
        }
    }

    @Test
    public void testSetNullTransactionRegistry() throws Exception {
        try (ManagedDataSource ds = new ManagedDataSource(this.pool, null);){
            Assertions.assertThrows(NullPointerException.class, () -> ds.setTransactionRegistry(null));
        }
    }

    @Test
    public void testSetTransactionRegistry() throws Exception {
        try (ManagedDataSource ds = new ManagedDataSource(this.pool, null);){
            ds.setTransactionRegistry(new TransactionRegistry(this.transactionManager));
        }
    }

    @Test
    public void testSetTransactionRegistryAlreadySet() {
        ManagedDataSource managed = (ManagedDataSource)this.ds;
        Assertions.assertThrows(IllegalStateException.class, () -> managed.setTransactionRegistry(null));
    }

    @Test
    public void testSharedConnection() throws Exception {
        try (DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
             DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();){
            Assertions.assertNotEquals((Object)connectionA, (Object)connectionB);
            Assertions.assertNotEquals((Object)connectionB, (Object)connectionA);
            Assertions.assertFalse((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
            Assertions.assertFalse((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        }
    }

    @Test
    public void testTransactionRegistryNotInitialized() throws Exception {
        try (ManagedDataSource ds = new ManagedDataSource(this.pool, null);){
            Assertions.assertThrows(IllegalStateException.class, () -> ((ManagedDataSource)ds).getConnection());
        }
    }
}

