/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDriverManagerConnectionFactory {
    private static final String KEY_JDBC_DRIVERS = "jdbc.drivers";

    @BeforeClass
    public static void beforeClass() {
        System.setProperty(KEY_JDBC_DRIVERS, "org.apache.commons.dbcp2.TesterDriver");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty(KEY_JDBC_DRIVERS);
    }

    @Test
    public void testDriverManagerInitWithEmptyProperties() throws Exception {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver;user=foo;password=bar");
        connectionFactory.createConnection();
    }

    @Test
    public void testDriverManagerInitWithProperties() throws Exception {
        this.testDriverManagerInit(true);
    }

    @Test
    public void testDriverManagerInitWithCredentials() throws Exception {
        this.testDriverManagerInit(false);
    }

    public void testDriverManagerInit(boolean withProperties) throws Exception {
        int i;
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(10);
        config.setMaxIdle(0);
        Properties properties = new Properties();
        properties.put("user", "foo");
        properties.put("password", "bar");
        DriverManagerConnectionFactory connectionFactory = withProperties ? new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", properties) : new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "foo", "bar");
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        poolableConnectionFactory.setDefaultReadOnly(Boolean.FALSE);
        poolableConnectionFactory.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, config);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        ConnectionThread[] connectionThreads = new ConnectionThread[10];
        Thread[] threads = new Thread[10];
        for (i = 0; i < 10; ++i) {
            connectionThreads[i] = new ConnectionThread((DataSource)dataSource);
            threads[i] = new Thread(connectionThreads[i]);
        }
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            while (threads[i].isAlive()) {
                Thread.sleep(100L);
            }
            if (connectionThreads[i].getResult()) continue;
            Assert.fail((String)("Exception during getConnection(): " + connectionThreads[i]));
        }
    }

    private static final class ConnectionThread
    implements Runnable {
        private final DataSource ds;
        private volatile boolean result = true;

        private ConnectionThread(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public void run() {
            Connection conn = null;
            try {
                conn = this.ds.getConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.result = false;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.result = false;
                    }
                }
            }
        }

        public boolean getResult() {
            return this.result;
        }

        public String toString() {
            return "ConnectionThread [ds=" + this.ds + ", result=" + this.result + "]";
        }
    }
}

