/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.primes;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.primes.Primes;
import org.apache.commons.math3.primes.SmallPrimes;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimesTest {
    public static final int[] PRIMES = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 43, 47, 53, 71, 73, 79, 89, 97, 107, 137, 151, 157, 271, 293, 331, 409, 607, 617, 683, 829, 1049, 1103, 1229, 1657, 2039, 2053, 2251, 2389, 2473, 2699, 3271, 3389, 3449, 5653, 6449, 6869, 9067, 9091, 11251, 12433, 12959, 22961, 41047, 46337, 65413, 80803, 91577, 92693, 118423, 656519, 795659, 1373639, 1373677, 588977, 952381, 1013041, 1205999, 2814001, 22605091, 25325981, 25326023, 100000007, 0x2AAAAAA9, Integer.MAX_VALUE};
    public static final int[] NOT_PRIMES = new int[]{4, 6, 8, 9, 10, 12, 14, 15, 16, 18, 20, 21, 22, 24, 25, 275, 2037, 2041, 2045, 2046, 2047, 2048, 2049, 2051, 2055, 9095, 463465, 1373637, 1373641, 1373651, 1373652, 1373653, 1373654, 1373655, 1373673, 1373675, 1373679, 25325979, 25325983, 25325993, 25325997, 25325999, 25326001, 25326003, 25326007, 25326009, 25326011, 25326021, 25326025, 100000005, 1073741341, 0x3FFFFFFF, 2147473649, 0x7FFFFFF9, 0x7FFFFFFB, 0x7FFFFFFD, 0x7FFFFFFE};
    public static final int[] BELOW_2 = new int[]{Integer.MIN_VALUE, -1, 0, 1};
    static final HashSet<Integer> PRIMES_SET = new HashSet();

    void assertPrimeFactorsException(int n, Throwable expected) {
        block2: {
            try {
                Primes.primeFactors((int)n);
                Assert.fail((String)"Exception not thrown");
            }
            catch (Throwable e) {
                Assert.assertEquals(expected.getClass(), e.getClass());
                if (expected.getMessage() == null) break block2;
                Assert.assertEquals((Object)expected.getMessage(), (Object)e.getMessage());
            }
        }
    }

    void assertNextPrimeException(int n, Throwable expected) {
        block2: {
            try {
                Primes.nextPrime((int)n);
                Assert.fail((String)"Exception not thrown");
            }
            catch (Throwable e) {
                Assert.assertEquals(expected.getClass(), e.getClass());
                if (expected.getMessage() == null) break block2;
                Assert.assertEquals((Object)expected.getMessage(), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testNextPrime() {
        int i;
        Assert.assertEquals((long)2L, (long)Primes.nextPrime((int)0));
        Assert.assertEquals((long)2L, (long)Primes.nextPrime((int)1));
        Assert.assertEquals((long)2L, (long)Primes.nextPrime((int)2));
        Assert.assertEquals((long)3L, (long)Primes.nextPrime((int)3));
        Assert.assertEquals((long)5L, (long)Primes.nextPrime((int)4));
        Assert.assertEquals((long)5L, (long)Primes.nextPrime((int)5));
        for (i = 0; i < SmallPrimes.PRIMES.length - 1; ++i) {
            for (int j = SmallPrimes.PRIMES[i] + 1; j <= SmallPrimes.PRIMES[i + 1]; ++j) {
                Assert.assertEquals((long)SmallPrimes.PRIMES[i + 1], (long)Primes.nextPrime((int)j));
            }
        }
        Assert.assertEquals((long)25325981L, (long)Primes.nextPrime((int)25325981));
        for (i = 25325982; i <= 25326023; ++i) {
            Assert.assertEquals((long)25326023L, (long)Primes.nextPrime((int)i));
        }
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Primes.nextPrime((int)0x7FFFFFF5));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Primes.nextPrime((int)0x7FFFFFFE));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Primes.nextPrime((int)Integer.MAX_VALUE));
        this.assertNextPrimeException(Integer.MIN_VALUE, new MathIllegalArgumentException((Localizable)LocalizedFormats.NUMBER_TOO_SMALL, new Object[]{Integer.MIN_VALUE, 0}));
        this.assertNextPrimeException(-1, new MathIllegalArgumentException((Localizable)LocalizedFormats.NUMBER_TOO_SMALL, new Object[]{-1, 0}));
        this.assertNextPrimeException(-13, new MathIllegalArgumentException((Localizable)LocalizedFormats.NUMBER_TOO_SMALL, new Object[]{-13, 0}));
    }

    @Test
    public void testIsPrime() throws Exception {
        for (int i : BELOW_2) {
            Assert.assertFalse((boolean)Primes.isPrime((int)i));
        }
        for (int i : NOT_PRIMES) {
            Assert.assertFalse((boolean)Primes.isPrime((int)i));
        }
        for (int i : PRIMES) {
            Assert.assertTrue((boolean)Primes.isPrime((int)i));
        }
    }

    static int sum(List<Integer> numbers) {
        int out = 0;
        for (int i : numbers) {
            out += i;
        }
        return out;
    }

    static int product(List<Integer> numbers) {
        int out = 1;
        for (int i : numbers) {
            out *= i;
        }
        return out;
    }

    static void checkPrimeFactors(List<Integer> factors) {
        for (int p : factors) {
            if (PRIMES_SET.contains(p)) continue;
            Assert.fail((String)("Not found in primes list: " + p));
        }
    }

    @Test
    public void testPrimeFactors() throws Exception {
        List factors;
        for (int i : BELOW_2) {
            this.assertPrimeFactorsException(i, new MathIllegalArgumentException((Localizable)LocalizedFormats.NUMBER_TOO_SMALL, new Object[]{i, 2}));
        }
        for (int i : NOT_PRIMES) {
            factors = Primes.primeFactors((int)i);
            PrimesTest.checkPrimeFactors(factors);
            int prod = PrimesTest.product(factors);
            Assert.assertEquals((long)i, (long)prod);
        }
        for (int i : PRIMES) {
            factors = Primes.primeFactors((int)i);
            Assert.assertEquals((long)i, (long)((Integer)factors.get(0)).intValue());
            Assert.assertEquals((long)1L, (long)factors.size());
        }
    }

    static {
        for (int p : PRIMES) {
            PRIMES_SET.add(p);
        }
    }
}

