/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.clustering;

import java.util.ArrayList;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.stat.clustering.EuclideanDoublePoint;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class EuclideanDoublePointTest {
    @Test
    public void testArrayIsReference() {
        double[] array = new double[]{-3.0, -2.0, -1.0, 0.0, 1.0};
        Assert.assertArrayEquals((double[])array, (double[])new EuclideanDoublePoint(array).getPoint(), (double)1.0E-15);
    }

    @Test
    public void testDistance() {
        EuclideanDoublePoint e1 = new EuclideanDoublePoint(new double[]{-3.0, -2.0, -1.0, 0.0, 1.0});
        EuclideanDoublePoint e2 = new EuclideanDoublePoint(new double[]{1.0, 0.0, -1.0, 1.0, 1.0});
        Assert.assertEquals((double)FastMath.sqrt((double)21.0), (double)e1.distanceFrom(e2), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)e1.distanceFrom(e1), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)e2.distanceFrom(e2), (double)1.0E-15);
    }

    @Test
    public void testCentroid() {
        ArrayList<EuclideanDoublePoint> list = new ArrayList<EuclideanDoublePoint>();
        list.add(new EuclideanDoublePoint(new double[]{1.0, 3.0}));
        list.add(new EuclideanDoublePoint(new double[]{2.0, 2.0}));
        list.add(new EuclideanDoublePoint(new double[]{3.0, 3.0}));
        list.add(new EuclideanDoublePoint(new double[]{2.0, 4.0}));
        EuclideanDoublePoint c = ((EuclideanDoublePoint)list.get(0)).centroidOf(list);
        Assert.assertEquals((double)2.0, (double)c.getPoint()[0], (double)1.0E-15);
        Assert.assertEquals((double)3.0, (double)c.getPoint()[1], (double)1.0E-15);
    }

    @Test
    public void testSerial() {
        EuclideanDoublePoint p = new EuclideanDoublePoint(new double[]{-3.0, -2.0, -1.0, 0.0, 1.0});
        Assert.assertEquals((Object)p, (Object)TestUtils.serializeAndRecover(p));
    }
}

