/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.inference.ChiSquareTest;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTestTest;
import org.apache.commons.math3.stat.inference.OneWayAnova;
import org.apache.commons.math3.stat.inference.TestUtils;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class TestUtilsTest {
    private double[] tooShortObs = new double[]{1.0};
    private double[] emptyObs = new double[0];
    private SummaryStatistics emptyStats = new SummaryStatistics();
    private double[] classA = new double[]{93.0, 103.0, 95.0, 101.0};
    private double[] classB = new double[]{99.0, 92.0, 102.0, 100.0, 102.0};
    private double[] classC = new double[]{110.0, 115.0, 111.0, 117.0, 128.0};
    private List<double[]> classes = new ArrayList<double[]>();
    private OneWayAnova oneWayAnova = new OneWayAnova();

    @Test
    public void testChiSquare() {
        long[] observed = new long[]{10L, 9L, 11L};
        double[] expected = new double[]{10.0, 10.0, 10.0};
        Assert.assertEquals((String)"chi-square statistic", (double)0.2, (double)TestUtils.chiSquare((double[])expected, (long[])observed), (double)1.0E-11);
        Assert.assertEquals((String)"chi-square p-value", (double)0.904837418036, (double)TestUtils.chiSquareTest((double[])expected, (long[])observed), (double)1.0E-10);
        long[] observed1 = new long[]{500L, 623L, 72L, 70L, 31L};
        double[] expected1 = new double[]{485.0, 541.0, 82.0, 61.0, 37.0};
        Assert.assertEquals((String)"chi-square test statistic", (double)9.023307936427388, (double)TestUtils.chiSquare((double[])expected1, (long[])observed1), (double)1.0E-10);
        Assert.assertEquals((String)"chi-square p-value", (double)0.06051952647453607, (double)TestUtils.chiSquareTest((double[])expected1, (long[])observed1), (double)1.0E-9);
        Assert.assertTrue((String)"chi-square test reject", (boolean)TestUtils.chiSquareTest((double[])expected1, (long[])observed1, (double)0.07));
        Assert.assertTrue((String)"chi-square test accept", (!TestUtils.chiSquareTest((double[])expected1, (long[])observed1, (double)0.05) ? 1 : 0) != 0);
        try {
            TestUtils.chiSquareTest((double[])expected1, (long[])observed1, (double)95.0);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        long[] tooShortObs = new long[]{0L};
        double[] tooShortEx = new double[]{1.0};
        try {
            TestUtils.chiSquare((double[])tooShortEx, (long[])tooShortObs);
            Assert.fail((String)"arguments too short, DimensionMismatchException expected");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        long[] unMatchedObs = new long[]{0L, 1L, 2L, 3L};
        double[] unMatchedEx = new double[]{1.0, 1.0, 2.0};
        try {
            TestUtils.chiSquare((double[])unMatchedEx, (long[])unMatchedObs);
            Assert.fail((String)"arrays have different lengths, DimensionMismatchException expected");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        expected[0] = 0.0;
        try {
            TestUtils.chiSquareTest((double[])expected, (long[])observed, (double)0.01);
            Assert.fail((String)"bad expected count, NotStrictlyPositiveException expected");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        expected[0] = 1.0;
        observed[0] = -1L;
        try {
            TestUtils.chiSquareTest((double[])expected, (long[])observed, (double)0.01);
            Assert.fail((String)"bad expected count, NotPositiveException expected");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testChiSquareIndependence() {
        long[][] counts = new long[][]{{40L, 22L, 43L}, {91L, 21L, 28L}, {60L, 10L, 22L}};
        Assert.assertEquals((String)"chi-square test statistic", (double)22.709027688, (double)TestUtils.chiSquare((long[][])counts), (double)1.0E-9);
        Assert.assertEquals((String)"chi-square p-value", (double)1.44751460134E-4, (double)TestUtils.chiSquareTest((long[][])counts), (double)1.0E-9);
        Assert.assertTrue((String)"chi-square test reject", (boolean)TestUtils.chiSquareTest((long[][])counts, (double)2.0E-4));
        Assert.assertTrue((String)"chi-square test accept", (!TestUtils.chiSquareTest((long[][])counts, (double)1.0E-4) ? 1 : 0) != 0);
        long[][] counts2 = new long[][]{{10L, 15L}, {30L, 40L}, {60L, 90L}};
        Assert.assertEquals((String)"chi-square test statistic", (double)0.168965517241, (double)TestUtils.chiSquare((long[][])counts2), (double)1.0E-9);
        Assert.assertEquals((String)"chi-square p-value", (double)0.918987499852, (double)TestUtils.chiSquareTest((long[][])counts2), (double)1.0E-9);
        Assert.assertTrue((String)"chi-square test accept", (!TestUtils.chiSquareTest((long[][])counts2, (double)0.1) ? 1 : 0) != 0);
        long[][] counts3 = new long[][]{{40L, 22L, 43L}, {91L, 21L, 28L}, {60L, 10L}};
        try {
            TestUtils.chiSquare((long[][])counts3);
            Assert.fail((String)"Expecting DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        long[][] counts4 = new long[][]{{40L, 22L, 43L}};
        try {
            TestUtils.chiSquare((long[][])counts4);
            Assert.fail((String)"Expecting DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        long[][] counts5 = new long[][]{{40L}, {40L}, {30L}, {10L}};
        try {
            TestUtils.chiSquare((long[][])counts5);
            Assert.fail((String)"Expecting DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        long[][] counts6 = new long[][]{{10L, -2L}, {30L, 40L}, {60L, 90L}};
        try {
            TestUtils.chiSquare((long[][])counts6);
            Assert.fail((String)"Expecting NotPositiveException");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
        try {
            TestUtils.chiSquareTest((long[][])counts, (double)0.0);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testChiSquareLargeTestStatistic() {
        double[] exp = new double[]{3389119.5, 649136.6, 285745.4, 2.535736476E7, 1.129118978E7, 543628.0, 232921.0, 437665.75};
        long[] obs = new long[]{2372383L, 584222L, 257170L, 17750155L, 7903832L, 489265L, 209628L, 393899L};
        ChiSquareTest csti = new ChiSquareTest();
        double cst = csti.chiSquareTest(exp, obs);
        Assert.assertEquals((String)"chi-square p-value", (double)0.0, (double)cst, (double)0.001);
        Assert.assertEquals((String)"chi-square test statistic", (double)114875.90421929007, (double)TestUtils.chiSquare((double[])exp, (long[])obs), (double)1.0E-9);
    }

    @Test
    public void testChiSquareZeroCount() {
        long[][] counts = new long[][]{{40L, 0L, 4L}, {91L, 1L, 2L}, {60L, 2L, 0L}};
        Assert.assertEquals((String)"chi-square test statistic", (double)9.67444662263, (double)TestUtils.chiSquare((long[][])counts), (double)1.0E-9);
        Assert.assertEquals((String)"chi-square p-value", (double)0.0462835770603, (double)TestUtils.chiSquareTest((long[][])counts), (double)1.0E-9);
    }

    @Test
    public void testOneSampleT() {
        double[] observed = new double[]{93.0, 103.0, 95.0, 101.0, 91.0, 105.0, 96.0, 94.0, 101.0, 88.0, 98.0, 94.0, 101.0, 92.0, 95.0};
        double mu = 100.0;
        SummaryStatistics sampleStats = null;
        sampleStats = new SummaryStatistics();
        for (int i = 0; i < observed.length; ++i) {
            sampleStats.addValue(observed[i]);
        }
        Assert.assertEquals((String)"t statistic", (double)-2.81976445346, (double)TestUtils.t((double)mu, (double[])observed), (double)1.0E-9);
        Assert.assertEquals((String)"t statistic", (double)-2.81976445346, (double)TestUtils.t((double)mu, (StatisticalSummary)sampleStats), (double)1.0E-9);
        Assert.assertEquals((String)"p value", (double)0.0136390585873, (double)TestUtils.tTest((double)mu, (double[])observed), (double)1.0E-9);
        Assert.assertEquals((String)"p value", (double)0.0136390585873, (double)TestUtils.tTest((double)mu, (StatisticalSummary)sampleStats), (double)1.0E-9);
        try {
            TestUtils.t((double)mu, (double[])null);
            Assert.fail((String)"arguments too short, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            TestUtils.t((double)mu, (StatisticalSummary)((SummaryStatistics)null));
            Assert.fail((String)"arguments too short, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            TestUtils.t((double)mu, (double[])this.emptyObs);
            Assert.fail((String)"arguments too short, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            TestUtils.t((double)mu, (StatisticalSummary)this.emptyStats);
            Assert.fail((String)"arguments too short, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            TestUtils.t((double)mu, (double[])this.tooShortObs);
            Assert.fail((String)"insufficient data to compute t statistic, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            TestUtils.tTest((double)mu, (double[])this.tooShortObs);
            Assert.fail((String)"insufficient data to perform t test, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            TestUtils.t((double)mu, (StatisticalSummary)((SummaryStatistics)null));
            Assert.fail((String)"insufficient data to compute t statistic, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            TestUtils.tTest((double)mu, (StatisticalSummary)((SummaryStatistics)null));
            Assert.fail((String)"insufficient data to perform t test, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOneSampleTTest() {
        double[] oneSidedP = new double[]{2.0, 0.0, 6.0, 6.0, 3.0, 3.0, 2.0, 3.0, -6.0, 6.0, 6.0, 6.0, 3.0, 0.0, 1.0, 1.0, 0.0, 2.0, 3.0, 3.0};
        SummaryStatistics oneSidedPStats = new SummaryStatistics();
        for (int i = 0; i < oneSidedP.length; ++i) {
            oneSidedPStats.addValue(oneSidedP[i]);
        }
        Assert.assertEquals((String)"one sample t stat", (double)3.86485535541, (double)TestUtils.t((double)0.0, (double[])oneSidedP), (double)1.0E-9);
        Assert.assertEquals((String)"one sample t stat", (double)3.86485535541, (double)TestUtils.t((double)0.0, (StatisticalSummary)oneSidedPStats), (double)1.0E-10);
        Assert.assertEquals((String)"one sample p value", (double)5.21637019637E-4, (double)(TestUtils.tTest((double)0.0, (double[])oneSidedP) / 2.0), (double)1.0E-9);
        Assert.assertEquals((String)"one sample p value", (double)5.21637019637E-4, (double)(TestUtils.tTest((double)0.0, (StatisticalSummary)oneSidedPStats) / 2.0), (double)1.0E-4);
        Assert.assertTrue((String)"one sample t-test reject", (boolean)TestUtils.tTest((double)0.0, (double[])oneSidedP, (double)0.01));
        Assert.assertTrue((String)"one sample t-test reject", (boolean)TestUtils.tTest((double)0.0, (StatisticalSummary)oneSidedPStats, (double)0.01));
        Assert.assertTrue((String)"one sample t-test accept", (!TestUtils.tTest((double)0.0, (double[])oneSidedP, (double)1.0E-4) ? 1 : 0) != 0);
        Assert.assertTrue((String)"one sample t-test accept", (!TestUtils.tTest((double)0.0, (StatisticalSummary)oneSidedPStats, (double)1.0E-4) ? 1 : 0) != 0);
        try {
            TestUtils.tTest((double)0.0, (double[])oneSidedP, (double)95.0);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            TestUtils.tTest((double)0.0, (StatisticalSummary)oneSidedPStats, (double)95.0);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoSampleTHeterscedastic() {
        double[] sample1 = new double[]{7.0, -4.0, 18.0, 17.0, -3.0, -5.0, 1.0, 10.0, 11.0, -2.0};
        double[] sample2 = new double[]{-1.0, 12.0, -1.0, -3.0, 3.0, -5.0, 5.0, 2.0, -11.0, -1.0, -3.0};
        SummaryStatistics sampleStats1 = new SummaryStatistics();
        for (int i = 0; i < sample1.length; ++i) {
            sampleStats1.addValue(sample1[i]);
        }
        SummaryStatistics sampleStats2 = new SummaryStatistics();
        for (int i = 0; i < sample2.length; ++i) {
            sampleStats2.addValue(sample2[i]);
        }
        Assert.assertEquals((String)"two sample heteroscedastic t stat", (double)1.60371728768, (double)TestUtils.t((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample heteroscedastic t stat", (double)1.60371728768, (double)TestUtils.t((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample heteroscedastic p value", (double)0.128839369622, (double)TestUtils.tTest((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample heteroscedastic p value", (double)0.128839369622, (double)TestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10);
        Assert.assertTrue((String)"two sample heteroscedastic t-test reject", (boolean)TestUtils.tTest((double[])sample1, (double[])sample2, (double)0.2));
        Assert.assertTrue((String)"two sample heteroscedastic t-test reject", (boolean)TestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, (double)0.2));
        Assert.assertTrue((String)"two sample heteroscedastic t-test accept", (!TestUtils.tTest((double[])sample1, (double[])sample2, (double)0.1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"two sample heteroscedastic t-test accept", (!TestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, (double)0.1) ? 1 : 0) != 0);
        try {
            TestUtils.tTest((double[])sample1, (double[])sample2, (double)0.95);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            TestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2, (double)0.95);
            Assert.fail((String)"alpha out of range, OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            TestUtils.tTest((double[])sample1, (double[])this.tooShortObs, (double)0.01);
            Assert.fail((String)"insufficient data, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            TestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)((SummaryStatistics)null), (double)0.01);
            Assert.fail((String)"insufficient data, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            TestUtils.tTest((double[])sample1, (double[])this.tooShortObs);
            Assert.fail((String)"insufficient data, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            TestUtils.tTest((StatisticalSummary)sampleStats1, (StatisticalSummary)((SummaryStatistics)null));
            Assert.fail((String)"insufficient data, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            TestUtils.t((double[])sample1, (double[])this.tooShortObs);
            Assert.fail((String)"insufficient data, NumberIsTooSmallException expected");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            TestUtils.t((StatisticalSummary)sampleStats1, (StatisticalSummary)((SummaryStatistics)null));
            Assert.fail((String)"insufficient data, NullArgumentException expected");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoSampleTHomoscedastic() {
        double[] sample1 = new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 97.0};
        double[] sample2 = new double[]{4.0, 6.0, 8.0, 10.0, 16.0};
        SummaryStatistics sampleStats1 = new SummaryStatistics();
        for (int i = 0; i < sample1.length; ++i) {
            sampleStats1.addValue(sample1[i]);
        }
        SummaryStatistics sampleStats2 = new SummaryStatistics();
        for (int i = 0; i < sample2.length; ++i) {
            sampleStats2.addValue(sample2[i]);
        }
        Assert.assertEquals((String)"two sample homoscedastic t stat", (double)0.73096310086, (double)TestUtils.homoscedasticT((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((String)"two sample homoscedastic p value", (double)0.4833963785, (double)TestUtils.homoscedasticTTest((StatisticalSummary)sampleStats1, (StatisticalSummary)sampleStats2), (double)1.0E-10);
        Assert.assertTrue((String)"two sample homoscedastic t-test reject", (boolean)TestUtils.homoscedasticTTest((double[])sample1, (double[])sample2, (double)0.49));
        Assert.assertTrue((String)"two sample homoscedastic t-test accept", (!TestUtils.homoscedasticTTest((double[])sample1, (double[])sample2, (double)0.48) ? 1 : 0) != 0);
    }

    @Test
    public void testSmallSamples() {
        double[] sample1 = new double[]{1.0, 3.0};
        double[] sample2 = new double[]{4.0, 5.0};
        Assert.assertEquals((double)-2.2360679775, (double)TestUtils.t((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((double)0.198727388935, (double)TestUtils.tTest((double[])sample1, (double[])sample2), (double)1.0E-10);
    }

    @Test
    public void testPaired() {
        double[] sample1 = new double[]{1.0, 3.0, 5.0, 7.0};
        double[] sample2 = new double[]{0.0, 6.0, 11.0, 2.0};
        double[] sample3 = new double[]{5.0, 7.0, 8.0, 10.0};
        Assert.assertEquals((double)-0.3133, (double)TestUtils.pairedT((double[])sample1, (double[])sample2), (double)1.0E-4);
        Assert.assertEquals((double)0.774544295819, (double)TestUtils.pairedTTest((double[])sample1, (double[])sample2), (double)1.0E-10);
        Assert.assertEquals((double)0.001208, (double)TestUtils.pairedTTest((double[])sample1, (double[])sample3), (double)1.0E-6);
        Assert.assertFalse((boolean)TestUtils.pairedTTest((double[])sample1, (double[])sample3, (double)0.001));
        Assert.assertTrue((boolean)TestUtils.pairedTTest((double[])sample1, (double[])sample3, (double)0.002));
    }

    @Test
    public void testOneWayAnovaUtils() {
        this.classes.add(this.classA);
        this.classes.add(this.classB);
        this.classes.add(this.classC);
        Assert.assertEquals((double)this.oneWayAnova.anovaFValue(this.classes), (double)TestUtils.oneWayAnovaFValue(this.classes), (double)1.0E-11);
        Assert.assertEquals((double)this.oneWayAnova.anovaPValue(this.classes), (double)TestUtils.oneWayAnovaPValue(this.classes), (double)1.0E-11);
        Assert.assertEquals((Object)this.oneWayAnova.anovaTest(this.classes, 0.01), (Object)TestUtils.oneWayAnovaTest(this.classes, (double)0.01));
    }

    @Test
    public void testGTestGoodnesOfFit() throws Exception {
        double[] exp = new double[]{0.54, 0.4, 0.05, 0.01};
        long[] obs = new long[]{70L, 79L, 3L, 4L};
        Assert.assertEquals((String)"G test statistic", (double)13.144799, (double)TestUtils.g((double[])exp, (long[])obs), (double)1.0E-5);
        double p_gtgf = TestUtils.gTest((double[])exp, (long[])obs);
        Assert.assertEquals((String)"g-Test p-value", (double)0.004333, (double)p_gtgf, (double)1.0E-5);
        Assert.assertTrue((boolean)TestUtils.gTest((double[])exp, (long[])obs, (double)0.05));
    }

    @Test
    public void testGTestIndependance() throws Exception {
        long[] obs1 = new long[]{268L, 199L, 42L};
        long[] obs2 = new long[]{807L, 759L, 184L};
        double g = TestUtils.gDataSetsComparison((long[])obs1, (long[])obs2);
        Assert.assertEquals((String)"G test statistic", (double)7.300817, (double)g, (double)1.0E-4);
        double p_gti = TestUtils.gTestDataSetsComparison((long[])obs1, (long[])obs2);
        Assert.assertEquals((String)"g-Test p-value", (double)0.0259805, (double)p_gti, (double)1.0E-4);
        Assert.assertTrue((boolean)TestUtils.gTestDataSetsComparison((long[])obs1, (long[])obs2, (double)0.05));
    }

    @Test
    public void testRootLogLikelihood() {
        Assert.assertTrue((TestUtils.rootLogLikelihoodRatio((long)904L, (long)21060L, (long)1144L, (long)283012L) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((TestUtils.rootLogLikelihoodRatio((long)36L, (long)21928L, (long)60280L, (long)623876L) < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)FastMath.sqrt((double)2.772589), (double)TestUtils.rootLogLikelihoodRatio((long)1L, (long)0L, (long)0L, (long)1L), (double)1.0E-6);
        Assert.assertEquals((double)(-FastMath.sqrt((double)2.772589)), (double)TestUtils.rootLogLikelihoodRatio((long)0L, (long)1L, (long)1L, (long)0L), (double)1.0E-6);
        Assert.assertEquals((double)FastMath.sqrt((double)27.72589), (double)TestUtils.rootLogLikelihoodRatio((long)10L, (long)0L, (long)0L, (long)10L), (double)1.0E-5);
        Assert.assertEquals((double)FastMath.sqrt((double)39.33052), (double)TestUtils.rootLogLikelihoodRatio((long)5L, (long)1995L, (long)0L, (long)100000L), (double)1.0E-5);
        Assert.assertEquals((double)(-FastMath.sqrt((double)39.33052)), (double)TestUtils.rootLogLikelihoodRatio((long)0L, (long)100000L, (long)5L, (long)1995L), (double)1.0E-5);
        Assert.assertEquals((double)FastMath.sqrt((double)4730.737), (double)TestUtils.rootLogLikelihoodRatio((long)1000L, (long)1995L, (long)1000L, (long)100000L), (double)0.001);
        Assert.assertEquals((double)(-FastMath.sqrt((double)4730.737)), (double)TestUtils.rootLogLikelihoodRatio((long)1000L, (long)100000L, (long)1000L, (long)1995L), (double)0.001);
        Assert.assertEquals((double)FastMath.sqrt((double)5734.343), (double)TestUtils.rootLogLikelihoodRatio((long)1000L, (long)1000L, (long)1000L, (long)100000L), (double)0.001);
        Assert.assertEquals((double)FastMath.sqrt((double)5714.932), (double)TestUtils.rootLogLikelihoodRatio((long)1000L, (long)1000L, (long)1000L, (long)99000L), (double)0.001);
    }

    @Test
    public void testKSOneSample() throws Exception {
        NormalDistribution unitNormal = new NormalDistribution(0.0, 1.0);
        double[] sample = KolmogorovSmirnovTestTest.gaussian;
        double tol = 1.0E-9;
        Assert.assertEquals((double)0.3172069207622391, (double)TestUtils.kolmogorovSmirnovTest((RealDistribution)unitNormal, (double[])sample), (double)1.0E-9);
        Assert.assertEquals((double)0.0932947561266756, (double)TestUtils.kolmogorovSmirnovStatistic((RealDistribution)unitNormal, (double[])sample), (double)1.0E-9);
    }

    @Test
    public void testKSTwoSample() throws Exception {
        double tol = 1.0E-9;
        double[] smallSample1 = new double[]{6.0, 7.0, 9.0, 13.0, 19.0, 21.0, 22.0, 23.0, 24.0};
        double[] smallSample2 = new double[]{10.0, 11.0, 12.0, 16.0, 20.0, 27.0, 28.0, 32.0, 44.0, 54.0};
        Assert.assertEquals((double)0.105577085453247, (double)TestUtils.kolmogorovSmirnovTest((double[])smallSample1, (double[])smallSample2, (boolean)false), (double)1.0E-9);
        double d = TestUtils.kolmogorovSmirnovStatistic((double[])smallSample1, (double[])smallSample2);
        Assert.assertEquals((double)0.5, (double)d, (double)1.0E-9);
        Assert.assertEquals((double)0.105577085453247, (double)TestUtils.exactP((double)d, (int)smallSample1.length, (int)smallSample2.length, (boolean)false), (double)1.0E-9);
    }
}

