/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.MethodCall;
import org.apache.commons.pool2.MethodCallPoolableObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.PrivateException;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractTestObjectPool {
    private final Integer ZERO = 0;
    private final Integer ONE = 1;

    private static void clear(MethodCallPoolableObjectFactory factory, List<MethodCall> expectedMethods) {
        factory.getMethodCalls().clear();
        expectedMethods.clear();
    }

    static void removeDestroyObjectCall(List<MethodCall> calls) {
        calls.removeIf(call -> "destroyObject".equals(call.getName()));
    }

    private static void reset(ObjectPool<Object> pool, MethodCallPoolableObjectFactory factory, List<MethodCall> expectedMethods) throws Exception {
        pool.clear();
        AbstractTestObjectPool.clear(factory, expectedMethods);
        factory.reset();
    }

    protected abstract <E extends Exception> ObjectPool<Object> makeEmptyPool(PooledObjectFactory<Object> var1) throws UnsupportedOperationException;

    @Test
    void testClosedPoolBehavior() throws Exception {
        ObjectPool<Object> pool;
        try {
            pool = this.makeEmptyPool(new MethodCallPoolableObjectFactory());
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        Object o1 = pool.borrowObject();
        Object o2 = pool.borrowObject();
        pool.close();
        Assertions.assertThrows(IllegalStateException.class, () -> pool.addObject(), (String)"A closed pool must throw an IllegalStateException when addObject is called.");
        Assertions.assertThrows(IllegalStateException.class, () -> pool.borrowObject(), (String)"A closed pool must throw an IllegalStateException when borrowObject is called.");
        if (pool.getNumIdle() >= 0) {
            Assertions.assertEquals((int)0, (int)pool.getNumIdle(), (String)"A closed pool shouldn't have any idle objects.");
        }
        if (pool.getNumActive() >= 0) {
            Assertions.assertEquals((int)2, (int)pool.getNumActive(), (String)"A closed pool should still keep count of active objects.");
        }
        pool.returnObject(o1);
        if (pool.getNumIdle() >= 0) {
            Assertions.assertEquals((int)0, (int)pool.getNumIdle(), (String)"returnObject should not add items back into the idle object pool for a closed pool.");
        }
        if (pool.getNumActive() >= 0) {
            Assertions.assertEquals((int)1, (int)pool.getNumActive(), (String)"A closed pool should still keep count of active objects.");
        }
        pool.invalidateObject(o2);
        if (pool.getNumActive() >= 0) {
            Assertions.assertEquals((int)0, (int)pool.getNumActive(), (String)"A closed pool should still keep count of active objects.");
        }
        pool.clear();
        pool.close();
    }

    @Test
    void testPOFAddObjectUsage() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Assertions.assertEquals((int)0, (int)pool.getNumActive());
        Assertions.assertEquals((int)0, (int)pool.getNumIdle());
        pool.addObject();
        Assertions.assertEquals((int)0, (int)pool.getNumActive());
        Assertions.assertEquals((int)1, (int)pool.getNumIdle());
        expectedMethods.add(new MethodCall("makeObject").returned(this.ZERO));
        if (pool instanceof SoftReferenceObjectPool) {
            expectedMethods.add(new MethodCall("validateObject", this.ZERO).returned(Boolean.TRUE));
        }
        expectedMethods.add(new MethodCall("passivateObject", this.ZERO));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        AbstractTestObjectPool.reset(pool, factory, expectedMethods);
        factory.setMakeObjectFail(true);
        Assertions.assertThrows(PrivateException.class, () -> pool.addObject(), (String)"Expected addObject to propagate makeObject exception.");
        expectedMethods.add(new MethodCall("makeObject"));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        AbstractTestObjectPool.clear(factory, expectedMethods);
        factory.setMakeObjectFail(false);
        factory.setPassivateObjectFail(true);
        Assertions.assertThrows(PrivateException.class, () -> pool.addObject(), (String)"Expected addObject to propagate passivateObject exception.");
        expectedMethods.add(new MethodCall("makeObject").returned(this.ONE));
        if (pool instanceof SoftReferenceObjectPool) {
            expectedMethods.add(new MethodCall("validateObject", this.ONE).returned(Boolean.TRUE));
        }
        expectedMethods.add(new MethodCall("passivateObject", this.ONE));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    void testPOFBorrowObjectUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        if (pool instanceof GenericObjectPool) {
            ((GenericObjectPool)pool).setTestOnBorrow(true);
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObject();
        AbstractTestObjectPool.clear(factory, expectedMethods);
        Object obj = pool.borrowObject();
        expectedMethods.add(new MethodCall("activateObject", this.ZERO));
        expectedMethods.add(new MethodCall("validateObject", this.ZERO).returned(Boolean.TRUE));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.returnObject(obj);
        AbstractTestObjectPool.reset(pool, factory, expectedMethods);
        factory.setMakeObjectFail(true);
        Assertions.assertThrows(PrivateException.class, () -> pool.borrowObject(), (String)"Expected borrowObject to propagate makeObject exception.");
        expectedMethods.add(new MethodCall("makeObject"));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        AbstractTestObjectPool.reset(pool, factory, expectedMethods);
        pool.addObject();
        AbstractTestObjectPool.clear(factory, expectedMethods);
        factory.setActivateObjectFail(true);
        expectedMethods.add(new MethodCall("activateObject", obj));
        Assertions.assertThrows(NoSuchElementException.class, () -> pool.borrowObject(), (String)"Expecting NoSuchElementException");
        expectedMethods.add(new MethodCall("makeObject").returned(this.ONE));
        expectedMethods.add(new MethodCall("activateObject", this.ONE));
        AbstractTestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        AbstractTestObjectPool.reset(pool, factory, expectedMethods);
        pool.addObject();
        AbstractTestObjectPool.clear(factory, expectedMethods);
        factory.setValidateObjectFail(true);
        expectedMethods.add(new MethodCall("activateObject", this.ZERO));
        expectedMethods.add(new MethodCall("validateObject", this.ZERO));
        Assertions.assertThrows(NoSuchElementException.class, () -> pool.borrowObject(), (String)"Expecting NoSuchElementException");
        expectedMethods.add(new MethodCall("makeObject").returned(this.ONE));
        expectedMethods.add(new MethodCall("activateObject", this.ONE));
        expectedMethods.add(new MethodCall("validateObject", this.ONE));
        AbstractTestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assertions.assertTrue((boolean)factory.getMethodCalls().containsAll(expectedMethods));
        pool.close();
    }

    @Test
    void testPOFClearUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObjects(5);
        pool.clear();
        AbstractTestObjectPool.reset(pool, factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        pool.addObjects(5);
        pool.clear();
        pool.close();
    }

    @Test
    void testPOFCloseUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        pool.addObjects(5);
        pool.close();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        AbstractTestObjectPool.reset(pool, factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        pool.addObjects(5);
        pool.close();
    }

    @Test
    void testPOFInvalidateObjectUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Object obj = pool.borrowObject();
        AbstractTestObjectPool.clear(factory, expectedMethods);
        pool.invalidateObject(obj);
        expectedMethods.add(new MethodCall("destroyObject", obj));
        Assertions.assertTrue((boolean)factory.getMethodCalls().containsAll(expectedMethods));
        AbstractTestObjectPool.reset(pool, factory, expectedMethods);
        Object obj2 = pool.borrowObject();
        AbstractTestObjectPool.clear(factory, expectedMethods);
        factory.setDestroyObjectFail(true);
        Assertions.assertThrows(PrivateException.class, () -> pool.invalidateObject(obj2));
        Thread.sleep(250L);
        AbstractTestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        pool.close();
    }

    @Test
    void testPOFReturnObjectUsages() throws Exception {
        ObjectPool<Object> pool;
        MethodCallPoolableObjectFactory factory = new MethodCallPoolableObjectFactory();
        try {
            pool = this.makeEmptyPool(factory);
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        ArrayList<MethodCall> expectedMethods = new ArrayList<MethodCall>();
        Object obj = pool.borrowObject();
        AbstractTestObjectPool.clear(factory, expectedMethods);
        pool.returnObject(obj);
        if (pool instanceof SoftReferenceObjectPool) {
            expectedMethods.add(new MethodCall("validateObject", obj).returned(Boolean.TRUE));
        }
        expectedMethods.add(new MethodCall("passivateObject", obj));
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        AbstractTestObjectPool.reset(pool, factory, expectedMethods);
        pool.addObject();
        pool.addObject();
        pool.addObject();
        Assertions.assertEquals((int)3, (int)pool.getNumIdle());
        obj = pool.borrowObject();
        pool.borrowObject();
        Assertions.assertEquals((int)1, (int)pool.getNumIdle());
        Assertions.assertEquals((int)2, (int)pool.getNumActive());
        AbstractTestObjectPool.clear(factory, expectedMethods);
        factory.setPassivateObjectFail(true);
        pool.returnObject(obj);
        if (pool instanceof SoftReferenceObjectPool) {
            expectedMethods.add(new MethodCall("validateObject", obj).returned(Boolean.TRUE));
        }
        expectedMethods.add(new MethodCall("passivateObject", obj));
        AbstractTestObjectPool.removeDestroyObjectCall(factory.getMethodCalls());
        Assertions.assertEquals(expectedMethods, factory.getMethodCalls());
        Assertions.assertEquals((int)1, (int)pool.getNumIdle());
        Assertions.assertEquals((int)1, (int)pool.getNumActive());
        AbstractTestObjectPool.reset(pool, factory, expectedMethods);
        obj = pool.borrowObject();
        AbstractTestObjectPool.clear(factory, expectedMethods);
        factory.setPassivateObjectFail(true);
        factory.setDestroyObjectFail(true);
        pool.returnObject(obj);
        pool.close();
    }

    @Test
    void testToString() {
        ObjectPool<Object> pool;
        try {
            pool = this.makeEmptyPool(new MethodCallPoolableObjectFactory());
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        pool.toString();
        pool.close();
    }
}

