/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.pool407;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.pool407.AbstractPool407Factory;
import org.apache.commons.pool2.pool407.AbstractPool407Test;
import org.apache.commons.pool2.pool407.Pool407;
import org.apache.commons.pool2.pool407.Pool407Constants;
import org.apache.commons.pool2.pool407.Pool407Fixture;
import org.apache.commons.pool2.pool407.Pool407NormalFactory;
import org.apache.commons.pool2.pool407.Pool407NullObjectFactory;
import org.apache.commons.pool2.pool407.Pool407NullPoolableObjectFactory;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class Pool407Test
extends AbstractPool407Test {
    Pool407Test() {
    }

    protected void assertShutdown(ExecutorService executor, Duration poolConfigMaxWait, AbstractPool407Factory factory) throws Exception {
        executor.shutdown();
        boolean termination = executor.awaitTermination(10L, TimeUnit.SECONDS);
        Pool407Fixture obj = (Pool407Fixture)factory.create();
        PooledObject pooledObject = obj != null ? factory.makeObject() : null;
        this.assertShutdown(termination, poolConfigMaxWait, obj, pooledObject);
    }

    private void test(AbstractPool407Factory factory, int poolSize, Duration poolConfigMaxWait) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(poolSize);
        try (Pool407 pool = new Pool407(factory, poolConfigMaxWait);){
            for (int i = 0; i < poolSize; ++i) {
                executor.execute(new Pool407RoundtripRunnable(pool));
            }
            this.assertShutdown(executor, poolConfigMaxWait, factory);
        }
    }

    @Test
    void testNormalFactoryNonNullFixtureWaitMax() throws Exception {
        this.test(new Pool407NormalFactory(new Pool407Fixture()), 3, Pool407Constants.WAIT_FOREVER);
    }

    @Test
    @Disabled
    void testNormalFactoryNullFixtureWaitMax() throws Exception {
        this.test(new Pool407NormalFactory(null), 3, Pool407Constants.WAIT_FOREVER);
    }

    @Disabled
    @Test
    void testNullObjectFactoryWaitMax() throws Exception {
        this.test(new Pool407NullObjectFactory(), 3, Pool407Constants.WAIT_FOREVER);
    }

    @Test
    @Disabled
    void testNullObjectFactoryWaitShort() throws Exception {
        this.test(new Pool407NullObjectFactory(), 3, Pool407Constants.WAIT_SHORT);
    }

    @Test
    @Disabled
    void testNullPoolableFactoryWaitMax() throws Exception {
        this.test(new Pool407NullPoolableObjectFactory(), 3, Pool407Constants.WAIT_FOREVER);
    }

    @Test
    @Disabled
    void testNullPoolableFactoryWaitShort() throws Exception {
        this.test(new Pool407NullPoolableObjectFactory(), 3, Pool407Constants.WAIT_SHORT);
    }

    private static final class Pool407RoundtripRunnable
    implements Runnable {
        private final Pool407 pool;

        Pool407RoundtripRunnable(Pool407 pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            try {
                Pool407Fixture object = (Pool407Fixture)this.pool.borrowObject();
                if (object != null) {
                    this.pool.returnObject(object);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

