/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacketI;

public class SessionReceiveLargeMessage
extends PacketImpl
implements MessagePacketI {
    private Message message;
    private long largeMessageSize;
    private long consumerID;
    private int deliveryCount;

    public SessionReceiveLargeMessage(Message message) {
        super((byte)76);
        this.message = message;
    }

    public SessionReceiveLargeMessage(long consumerID, Message message, long largeMessageSize, int deliveryCount) {
        super((byte)76);
        this.consumerID = consumerID;
        this.message = message;
        this.deliveryCount = deliveryCount;
        this.largeMessageSize = largeMessageSize;
    }

    @Override
    public MessagePacketI replaceMessage(Message message) {
        this.message = message;
        return this;
    }

    public Message getLargeMessage() {
        return this.message;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public long getLargeMessageSize() {
        return this.largeMessageSize;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.deliveryCount);
        buffer.writeLong(this.largeMessageSize);
        if (this.message != null) {
            ((CoreMessage)this.message).encodeHeadersAndProperties(buffer.byteBuf());
        }
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.deliveryCount = buffer.readInt();
        this.largeMessageSize = buffer.readLong();
        ((CoreMessage)this.message).decodeHeadersAndProperties(buffer.byteBuf());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.consumerID, this.deliveryCount, this.largeMessageSize, this.message);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", consumerID=" + this.consumerID);
        sb.append(", deliveryCount=" + this.deliveryCount);
        sb.append(", largeMessageSize=" + this.largeMessageSize);
        sb.append(", message=" + String.valueOf(this.message));
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionReceiveLargeMessage)) {
            return false;
        }
        SessionReceiveLargeMessage other = (SessionReceiveLargeMessage)obj;
        return this.consumerID == other.consumerID && this.deliveryCount == other.deliveryCount && this.largeMessageSize == other.largeMessageSize && Objects.equals(this.message, other.message);
    }
}

