/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.criteria.role.impl;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.criteria.role.EvaluableRoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

public class EvaluableProtocolRoleDescriptorCriterion
implements EvaluableRoleDescriptorCriterion {
    @Nonnull
    @NotEmpty
    private String protocol;

    public EvaluableProtocolRoleDescriptorCriterion(@Nonnull ProtocolCriterion criterion) {
        Constraint.isNotNull((Object)criterion, (String)"ProtocolCriterion was null");
        this.protocol = (String)Constraint.isNotNull((Object)criterion.getProtocol(), (String)"Criterion protocol was null");
    }

    public EvaluableProtocolRoleDescriptorCriterion(@Nonnull String roleProtocol) {
        this.protocol = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)roleProtocol), (String)"Entity Role protocol was null or empty");
    }

    public boolean test(@Nullable RoleDescriptor input) {
        if (input == null) {
            return false;
        }
        return input.isSupportedProtocol(this.protocol);
    }

    public int hashCode() {
        return this.protocol.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EvaluableProtocolRoleDescriptorCriterion) {
            EvaluableProtocolRoleDescriptorCriterion other = (EvaluableProtocolRoleDescriptorCriterion)obj;
            return Objects.equals(this.protocol, other.protocol);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("protocol", (Object)this.protocol).toString();
    }
}

