/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CompactSketchWithDoubleSummaryTest {
    private final DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;

    @Test
    public void emptyFromNonPublicConstructorNullArray() {
        CompactSketch sketch = new CompactSketch(null, null, Long.MAX_VALUE, true);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)0.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        TupleSketchIterator it = sketch.iterator();
        Assert.assertNotNull((Object)it);
        Assert.assertFalse((boolean)it.next());
        sketch.toString();
    }

    @Test
    public void emptyFromNonPublicConstructor() {
        long[] keys = new long[]{};
        DoubleSummary[] summaries = (DoubleSummary[])Array.newInstance(DoubleSummary.class, 0);
        CompactSketch sketch = new CompactSketch(keys, (Summary[])summaries, Long.MAX_VALUE, true);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)0.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        TupleSketchIterator it = sketch.iterator();
        Assert.assertNotNull((Object)it);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void emptyFromQuickSelectSketch() {
        UpdatableSketch us = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        CompactSketch sketch = us.compact();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)0.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        TupleSketchIterator it = sketch.iterator();
        Assert.assertNotNull((Object)it);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void exactModeFromQuickSelectSketch() {
        UpdatableSketch us = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        us.update(1L, (Object)1.0);
        us.update(2L, (Object)1.0);
        us.update(3L, (Object)1.0);
        us.update(1L, (Object)1.0);
        us.update(2L, (Object)1.0);
        us.update(3L, (Object)1.0);
        CompactSketch sketch = us.compact();
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)3.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)3.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)3);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        TupleSketchIterator it = sketch.iterator();
        int count = 0;
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)3);
    }

    @Test
    public void serializeDeserializeSmallExact() {
        UpdatableSketch us = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        us.update("a", (Object)1.0);
        us.update("b", (Object)1.0);
        us.update("c", (Object)1.0);
        CompactSketch sketch1 = us.compact();
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])sketch1.toByteArray()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertFalse((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)3.0);
        Assert.assertEquals((double)sketch2.getLowerBound(1), (double)3.0);
        Assert.assertEquals((double)sketch2.getUpperBound(1), (double)3.0);
        Assert.assertEquals((int)sketch2.getRetainedEntries(), (int)3);
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch2.getTheta(), (double)1.0);
        TupleSketchIterator it = sketch2.iterator();
        int count = 0;
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)3);
    }

    @Test
    public void serializeDeserializeEstimation() throws Exception {
        UpdatableSketch us = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            us.update((long)i, (Object)1.0);
        }
        us.trim();
        CompactSketch sketch1 = us.compact();
        byte[] bytes = sketch1.toByteArray();
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertTrue((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)sketch1.getEstimate());
        Assert.assertEquals((long)sketch2.getThetaLong(), (long)sketch1.getThetaLong());
        TupleSketchIterator it = sketch2.iterator();
        int count = 0;
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)4096);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void deserializeWrongType() {
        UpdatableSketch us = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        for (int i = 0; i < 8192; ++i) {
            us.update((long)i, (Object)1.0);
        }
        CompactSketch sketch1 = us.compact();
        Sketches.heapifyUpdatableSketch((Memory)Memory.wrap((byte[])sketch1.toByteArray()), (SummaryDeserializer)new DoubleSummaryDeserializer(), (SummaryFactory)new DoubleSummaryFactory(this.mode));
    }
}

