/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.strings;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.DeserializeResult;
import org.apache.datasketches.tuple.strings.ArrayOfStringsSummary;
import org.apache.datasketches.tuple.strings.ArrayOfStringsSummaryDeserializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfStringsSummaryTest {
    @Test
    public void checkToByteArray() {
        String[] nodesArr;
        String[] strArr = new String[]{"abcd", "abcd", "abcd"};
        ArrayOfStringsSummary nsum = new ArrayOfStringsSummary(strArr);
        ArrayOfStringsSummary copy = nsum.copy();
        Assert.assertTrue((boolean)copy.equals((Object)nsum));
        byte[] out = nsum.toByteArray();
        Memory mem = Memory.wrap((byte[])out);
        ArrayOfStringsSummary nsum2 = new ArrayOfStringsSummary(mem);
        for (String s : nodesArr = nsum2.getValue()) {
            ArrayOfStringsSummaryTest.println(s);
        }
        ArrayOfStringsSummaryTest.println("\nfromMemory(mem)");
        DeserializeResult dres = ArrayOfStringsSummaryDeserializer.fromMemory((Memory)mem);
        ArrayOfStringsSummary nsum3 = (ArrayOfStringsSummary)dres.getObject();
        for (String s : nodesArr = nsum3.getValue()) {
            ArrayOfStringsSummaryTest.println(s);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNumNodes() {
        ArrayOfStringsSummary.checkNumNodes((int)200);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInBytes() {
        Memory mem = Memory.wrap((byte[])new byte[100]);
        ArrayOfStringsSummary.checkInBytes((Memory)mem, (int)200);
    }

    @Test
    public void checkHashCode() {
        String[] strArr = new String[]{"abcd", "abcd", "abcd"};
        ArrayOfStringsSummary sum1 = new ArrayOfStringsSummary(strArr);
        ArrayOfStringsSummary sum2 = new ArrayOfStringsSummary(strArr);
        int hc1 = sum1.hashCode();
        int hc2 = sum2.hashCode();
        Assert.assertEquals((int)hc1, (int)hc2);
        Assert.assertTrue((boolean)sum1.equals((Object)sum2));
        Assert.assertFalse((boolean)sum1.equals((Object)hc2));
        Assert.assertFalse((boolean)sum1.equals(null));
    }

    @Test
    public void printlnTest() {
        ArrayOfStringsSummaryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

