/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;

public final class LongsAsOrderableStrings {
    public static String getString(long value, int numDigits) {
        return Util.characterPad((String)Long.toString(value), (int)numDigits, (char)' ', (boolean)false);
    }

    public static long getLong(String value) {
        long out;
        try {
            out = Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            throw new SketchesArgumentException(e.toString());
        }
        return out;
    }

    public static int digits(long maxValue) {
        if (maxValue <= 0L) {
            return 1;
        }
        return (int)Math.ceil(Math.log(maxValue + 1L) / Math.log(10.0));
    }
}

