/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.QuickSelect;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapHashIterator;
import org.apache.datasketches.theta.HeapUpdateSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdateReturnState;
import org.apache.datasketches.thetacommon.HashOperations;
import org.apache.datasketches.thetacommon.ThetaUtil;

class HeapQuickSelectSketch
extends HeapUpdateSketch {
    private final Family MY_FAMILY;
    private final int preambleLongs_;
    private int lgArrLongs_;
    private int hashTableThreshold_;
    int curCount_;
    long thetaLong_;
    boolean empty_;
    private long[] cache_;

    private HeapQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, int preambleLongs, Family family) {
        super(lgNomLongs, seed, p, rf);
        this.preambleLongs_ = preambleLongs;
        this.MY_FAMILY = family;
    }

    HeapQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, boolean unionGadget) {
        super(lgNomLongs, seed, p, rf);
        if (unionGadget) {
            this.preambleLongs_ = Family.UNION.getMinPreLongs();
            this.MY_FAMILY = Family.UNION;
        } else {
            this.preambleLongs_ = Family.QUICKSELECT.getMinPreLongs();
            this.MY_FAMILY = Family.QUICKSELECT;
        }
        this.lgArrLongs_ = ThetaUtil.startingSubMultiple(lgNomLongs + 1, rf.lg(), 5);
        this.hashTableThreshold_ = HeapQuickSelectSketch.getHashTableThreshold(lgNomLongs, this.lgArrLongs_);
        this.curCount_ = 0;
        this.thetaLong_ = (long)((double)p * 9.223372036854776E18);
        this.empty_ = true;
        this.cache_ = new long[1 << this.lgArrLongs_];
    }

    static HeapQuickSelectSketch heapifyInstance(MemorySegment srcSeg, long seed) {
        int preambleLongs = ThetaSketch.getPreambleLongs(srcSeg);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcSeg);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcSeg);
        HeapQuickSelectSketch.checkUnionAndQuickSelectFamily(srcSeg, preambleLongs, lgNomLongs);
        HeapQuickSelectSketch.checkSegIntegrity(srcSeg, seed, preambleLongs, lgNomLongs, lgArrLongs);
        float p = PreambleUtil.extractP(srcSeg);
        int seglgRF = PreambleUtil.extractLgResizeFactor(srcSeg);
        ResizeFactor segRF = ResizeFactor.getRF(seglgRF);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        Family family = Family.idToFamily(familyID);
        if (HeapQuickSelectSketch.isResizeFactorIncorrect(srcSeg, lgNomLongs, lgArrLongs)) {
            segRF = ResizeFactor.X2;
        }
        HeapQuickSelectSketch hqss = new HeapQuickSelectSketch(lgNomLongs, seed, p, segRF, preambleLongs, family);
        hqss.lgArrLongs_ = lgArrLongs;
        hqss.hashTableThreshold_ = HeapQuickSelectSketch.getHashTableThreshold(lgNomLongs, lgArrLongs);
        hqss.curCount_ = PreambleUtil.extractCurCount(srcSeg);
        hqss.thetaLong_ = PreambleUtil.extractThetaLong(srcSeg);
        hqss.empty_ = PreambleUtil.isEmptyFlag(srcSeg);
        hqss.cache_ = new long[1 << lgArrLongs];
        MemorySegment.copy(srcSeg, ValueLayout.JAVA_LONG_UNALIGNED, preambleLongs << 3, hqss.cache_, 0, 1 << lgArrLongs);
        return hqss;
    }

    @Override
    public double getEstimate() {
        return ThetaSketch.estimate(this.thetaLong_, this.curCount_);
    }

    @Override
    public Family getFamily() {
        return this.MY_FAMILY;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public long getThetaLong() {
        return this.empty_ ? Long.MAX_VALUE : this.thetaLong_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public HashIterator iterator() {
        return new HeapHashIterator(this.cache_, this.thetaLong_);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(this.preambleLongs_, (byte)this.MY_FAMILY.getID());
    }

    @Override
    public UpdatableThetaSketch rebuild() {
        if (this.getRetainedEntries(true) > 1 << this.getLgNomLongs()) {
            this.quickSelectAndRebuild();
        }
        return this;
    }

    @Override
    public void reset() {
        ResizeFactor rf = this.getResizeFactor();
        int lgArrLongsSM = ThetaUtil.startingSubMultiple(this.lgNomLongs_ + 1, rf.lg(), 5);
        if (lgArrLongsSM == this.lgArrLongs_) {
            int arrLongs = this.cache_.length;
            assert (1 << this.lgArrLongs_ == arrLongs);
            Arrays.fill(this.cache_, 0L);
        } else {
            this.cache_ = new long[1 << lgArrLongsSM];
            this.lgArrLongs_ = lgArrLongsSM;
        }
        this.hashTableThreshold_ = HeapQuickSelectSketch.getHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        this.empty_ = true;
        this.curCount_ = 0;
        this.thetaLong_ = (long)((double)this.getP() * 9.223372036854776E18);
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    int getCompactPreambleLongs() {
        return CompactOperations.computeCompactPreLongs(this.empty_, this.curCount_, this.thetaLong_);
    }

    @Override
    int getCurrentPreambleLongs() {
        return this.preambleLongs_;
    }

    int getHashTableThreshold() {
        return this.hashTableThreshold_;
    }

    @Override
    int getLgArrLongs() {
        return this.lgArrLongs_;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        HashOperations.checkHashCorruption(hash);
        this.empty_ = false;
        if (HashOperations.continueCondition(this.thetaLong_, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        if (HashOperations.hashSearchOrInsert(this.cache_, this.lgArrLongs_, hash) >= 0) {
            return UpdateReturnState.RejectedDuplicate;
        }
        ++this.curCount_;
        if (this.isOutOfSpace(this.curCount_)) {
            if (this.lgArrLongs_ <= this.lgNomLongs_) {
                this.resizeCache();
                return UpdateReturnState.InsertedCountIncrementedResized;
            }
            assert (this.lgArrLongs_ == this.lgNomLongs_ + 1) : "lgArr: " + this.lgArrLongs_ + ", lgNom: " + this.lgNomLongs_;
            this.quickSelectAndRebuild();
            return UpdateReturnState.InsertedCountIncrementedRebuilt;
        }
        return UpdateReturnState.InsertedCountIncremented;
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    boolean isOutOfSpace(int numEntries) {
        return numEntries > this.hashTableThreshold_;
    }

    private final void resizeCache() {
        ResizeFactor rf = this.getResizeFactor();
        int lgMaxArrLongs = this.lgNomLongs_ + 1;
        int lgDeltaLongs = lgMaxArrLongs - this.lgArrLongs_;
        int lgResizeFactor = Math.max(Math.min(rf.lg(), lgDeltaLongs), 1);
        this.lgArrLongs_ += lgResizeFactor;
        long[] tgtArr = new long[1 << this.lgArrLongs_];
        int newCount = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        assert (newCount == this.curCount_);
        this.curCount_ = newCount;
        this.cache_ = tgtArr;
        this.hashTableThreshold_ = HeapQuickSelectSketch.getHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
    }

    private final void quickSelectAndRebuild() {
        int arrLongs = 1 << this.lgArrLongs_;
        int pivot = (1 << this.lgNomLongs_) + 1;
        this.thetaLong_ = QuickSelect.selectExcludingZeros(this.cache_, this.curCount_, pivot);
        long[] tgtArr = new long[arrLongs];
        this.curCount_ = HashOperations.hashArrayInsert(this.cache_, tgtArr, this.lgArrLongs_, this.thetaLong_);
        this.cache_ = tgtArr;
    }

    private static final int getHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.5 : 0.9375;
        return (int)(fraction * (double)(1 << lgArrLongs));
    }
}

