/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DProtocol;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import java.util.HashMap;
import java.util.Map;

public class DMessageCounter
implements DProtocolNotifierIF {
    long[] m_inCounts = new long[66];
    long[] m_outCounts = new long[58];
    long m_lastIsolate = 1L;
    Object m_isolateLock;
    boolean m_isolate;
    Map<Long, DMessageCounter> m_isolateCounterMap = new HashMap<Long, DMessageCounter>();

    public DMessageCounter() {
        this.m_isolateLock = new Object();
        this.clearArray(this.m_inCounts);
        this.clearArray(this.m_outCounts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        Object outLock;
        Object inLock;
        Object object = inLock = this.getInLock();
        synchronized (object) {
            inLock.notifyAll();
        }
        Object object2 = outLock = this.getOutLock();
        synchronized (object2) {
            outLock.notifyAll();
        }
    }

    public Object getInLock() {
        return this.m_inCounts;
    }

    public Object getOutLock() {
        return this.m_outCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageSent(DMessage msg) {
        DMessageCounter counter;
        Object object;
        int type = msg.getType();
        if (type < 0 || type >= 57) {
            type = 57;
        }
        long targetIsolate = msg.getTargetIsolate();
        Object outLock = this.getOutLock();
        if (!this.m_isolate) {
            object = this.m_isolateLock;
            synchronized (object) {
                if (this.m_lastIsolate != 1L) {
                    counter = this.m_isolateCounterMap.get(this.m_lastIsolate);
                    outLock = counter.getOutLock();
                }
            }
        }
        object = outLock;
        synchronized (object) {
            if (!this.m_isolate && targetIsolate != 1L) {
                counter = this.m_isolateCounterMap.get(targetIsolate);
                counter.messageSent(msg);
                int n = type;
                this.m_outCounts[n] = this.m_outCounts[n] + 1L;
                outLock.notifyAll();
            } else {
                int n = type;
                this.m_outCounts[n] = this.m_outCounts[n] + 1L;
                outLock.notifyAll();
            }
        }
    }

    public void setIsolate(boolean value) {
        this.m_isolate = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(DMessage msg, DProtocol which) {
        DMessageCounter counter;
        Object object;
        int type = msg.getType();
        if (type < 0 || type >= 65) {
            type = 65;
        }
        Object inLock = this.getInLock();
        if (!this.m_isolate) {
            object = this.m_isolateLock;
            synchronized (object) {
                if (this.m_lastIsolate != 1L) {
                    counter = this.m_isolateCounterMap.get(this.m_lastIsolate);
                    inLock = counter.getInLock();
                }
            }
        }
        object = inLock;
        synchronized (object) {
            if (type == 62) {
                long isolate = msg.getDWord();
                if (isolate != 1L && !this.m_isolateCounterMap.containsKey(isolate)) {
                    DMessageCounter isolateCounter = new DMessageCounter();
                    isolateCounter.setIsolate(true);
                    this.m_isolateCounterMap.put(isolate, isolateCounter);
                }
                Object object2 = this.m_isolateLock;
                synchronized (object2) {
                    this.m_lastIsolate = isolate;
                }
                int n = type;
                this.m_inCounts[n] = this.m_inCounts[n] + 1L;
                inLock.notifyAll();
            } else if (!this.m_isolate && this.m_lastIsolate != 1L) {
                counter = this.m_isolateCounterMap.get(this.m_lastIsolate);
                counter.messageArrived(msg, which);
                Object object3 = counter.getInLock();
                synchronized (object3) {
                    counter.getInLock().notifyAll();
                }
            } else {
                int n = type;
                this.m_inCounts[n] = this.m_inCounts[n] + 1L;
                inLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInCount(int type) {
        Object object = this.getInLock();
        synchronized (object) {
            return this.m_inCounts[type];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOutCount(int type) {
        Object object = this.getOutLock();
        synchronized (object) {
            return this.m_outCounts[type];
        }
    }

    public long getIsolateInCount(long isolate, int type) {
        DMessageCounter counter = this.m_isolateCounterMap.get(isolate);
        return counter.getInCount(type);
    }

    public long getIsolateOutCount(long isolate, int type) {
        DMessageCounter counter = this.m_isolateCounterMap.get(isolate);
        return counter.getOutCount(type);
    }

    public Object getIsolateInLock(long isolate) {
        DMessageCounter counter = this.m_isolateCounterMap.get(isolate);
        return counter.getInLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInCounts() {
        Object object = this.getInLock();
        synchronized (object) {
            this.clearArray(this.m_inCounts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOutCounts() {
        Object object = this.getOutLock();
        synchronized (object) {
            this.clearArray(this.m_outCounts);
        }
    }

    void clearArray(long[] ar) {
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = 0L;
        }
    }
}

