/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.swf.Action;
import flash.swf.MovieMetaData;
import flash.swf.actions.DefineFunction;
import flash.swf.debug.LineRecord;
import flash.swf.types.ActionList;
import flash.tools.ActionLocation;
import flash.tools.SwfActionContainer;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.util.Trace;

public class LineFunctionContainer
extends SwfActionContainer {
    public LineFunctionContainer(byte[] swf, byte[] swd) {
        super(swf, swd);
        this.buildFunctionNames(this.getMasterList(), this.getHeader().version);
    }

    public ActionLocation endOfSourceLine(ActionLocation l) {
        ActionLocation current = new ActionLocation(l);
        int size = l.actions.size();
        int i = l.at + 1;
        while (i < size) {
            Action a = l.actions.getAction(i);
            if (a.code == 257 || a.code == 155 || a.code == 142) break;
            current.at = i++;
        }
        return current;
    }

    public void combForLineRecords(DSwfInfo info) {
        this.probeForLineRecords(this.getMasterList(), new ActionLocation(), info);
    }

    void probeForLineRecords(ActionList list, ActionLocation where, DSwfInfo info) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            try {
                where.at = i;
                where.actions = list;
                Action a = list.getAction(i);
                if (a.code == 155 || a.code == 142) {
                    where.function = (DefineFunction)a;
                    this.probeForLineRecords(((DefineFunction)a).actionList, where, info);
                    where.function = null;
                    continue;
                }
                if (a.code == 257) {
                    info.processLineRecord(where, (LineRecord)a);
                    continue;
                }
                if (!(a instanceof SwfActionContainer.DummyAction)) continue;
                where.className = ((SwfActionContainer.DummyAction)a).getClassName();
                this.probeForLineRecords(((SwfActionContainer.DummyAction)a).getActionList(), where, info);
                where.className = null;
                continue;
            }
            catch (Exception e) {
                if (!Trace.error) continue;
                Trace.trace("Error processing ActionList at " + where.at + " at offset " + where.actions.getOffset(where.at) + " in swf " + info.getUrl());
                e.printStackTrace();
            }
        }
    }

    void buildFunctionNames(ActionList list, int version) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            SwfActionContainer.DummyAction a = (SwfActionContainer.DummyAction)list.getAction(i);
            MovieMetaData.walkActions(a.getActionList(), version, null, a.getClassName(), null);
        }
    }
}

