/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.batik.script;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flex.forks.batik.dom.svg.SVGOMDocument;
import org.apache.flex.forks.batik.script.Interpreter;
import org.apache.flex.forks.batik.script.InterpreterFactory;
import org.apache.flex.forks.batik.util.Service;
import org.w3c.dom.Document;

public class InterpreterPool {
    public static final String BIND_NAME_DOCUMENT = "document";
    protected static Map defaultFactories = new HashMap(7);
    protected Map factories = new HashMap(7);

    public InterpreterPool() {
        this.factories.putAll(defaultFactories);
    }

    public Interpreter createInterpreter(Document document, String language) {
        InterpreterFactory factory = (InterpreterFactory)this.factories.get(language);
        if (factory == null) {
            return null;
        }
        Interpreter interpreter = null;
        SVGOMDocument svgDoc = (SVGOMDocument)document;
        try {
            URL url = new URL(svgDoc.getDocumentURI());
            interpreter = factory.createInterpreter(url, svgDoc.isSVG12());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (interpreter == null) {
            return null;
        }
        if (document != null) {
            interpreter.bindObject(BIND_NAME_DOCUMENT, document);
        }
        return interpreter;
    }

    public void putInterpreterFactory(String language, InterpreterFactory factory) {
        this.factories.put(language, factory);
    }

    public void removeInterpreterFactory(String language) {
        this.factories.remove(language);
    }

    static {
        Iterator iter = Service.providers(InterpreterFactory.class);
        while (iter.hasNext()) {
            InterpreterFactory factory = null;
            factory = (InterpreterFactory)iter.next();
            String[] mimeTypes = factory.getMimeTypes();
            for (int i = 0; i < mimeTypes.length; ++i) {
                defaultFactories.put(mimeTypes[i], factory);
            }
        }
    }
}

