/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ModuleReaderProxy;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import io.github.classgraph.Scanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.concurrency.SingletonMap;
import nonapi.io.github.classgraph.concurrency.WorkQueue;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.recycler.RecycleOnClose;
import nonapi.io.github.classgraph.recycler.Recycler;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.CollectionUtils;
import nonapi.io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import nonapi.io.github.classgraph.utils.LogNode;

class ClasspathElementModule
extends ClasspathElement {
    final ModuleRef moduleRef;
    private final NestedJarHandler nestedJarHandler;
    private Recycler<ModuleReaderProxy, IOException> moduleReaderProxyRecycler;
    private final Set<String> allResourcePaths = new HashSet<String>();

    ClasspathElementModule(ModuleRef moduleRef, ClassLoader classLoader, NestedJarHandler nestedJarHandler, ScanSpec scanSpec) {
        super(classLoader, scanSpec);
        this.moduleRef = moduleRef;
        this.nestedJarHandler = nestedJarHandler;
    }

    @Override
    void open(WorkQueue<Scanner.ClasspathEntryWorkUnit> workQueueIgnored, int classpathElementIdx, LogNode log) throws InterruptedException {
        if (!this.scanSpec.scanModules) {
            if (log != null) {
                this.log(classpathElementIdx, "Skipping module, since module scanning is disabled: " + this.getModuleName(), log);
            }
            this.skipClasspathElement = true;
            return;
        }
        try {
            this.moduleReaderProxyRecycler = this.nestedJarHandler.moduleRefToModuleReaderProxyRecyclerMap.get(this.moduleRef, null);
        }
        catch (IOException | SingletonMap.NullSingletonException e) {
            if (log != null) {
                this.log(classpathElementIdx, "Skipping invalid module " + this.getModuleName() + " : " + e, log);
            }
            this.skipClasspathElement = true;
            return;
        }
    }

    private Resource newResource(final String resourcePath) {
        return new Resource(this, -1L){
            private ModuleReaderProxy moduleReaderProxy;

            @Override
            public String getPath() {
                return resourcePath;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return resourcePath;
            }

            @Override
            public synchronized ByteBuffer read() throws IOException {
                if (ClasspathElementModule.this.skipClasspathElement) {
                    throw new IOException("Module could not be opened");
                }
                this.markAsOpen();
                try {
                    this.moduleReaderProxy = (ModuleReaderProxy)ClasspathElementModule.this.moduleReaderProxyRecycler.acquire();
                    this.byteBuffer = this.moduleReaderProxy.read(resourcePath);
                    this.length = this.byteBuffer.remaining();
                    return this.byteBuffer;
                }
                catch (OutOfMemoryError | SecurityException e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            synchronized InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                return new InputStreamOrByteBufferAdapter(this.open());
            }

            @Override
            public synchronized InputStream open() throws IOException {
                if (ClasspathElementModule.this.skipClasspathElement) {
                    throw new IOException("Module could not be opened");
                }
                this.markAsOpen();
                try {
                    this.moduleReaderProxy = (ModuleReaderProxy)ClasspathElementModule.this.moduleReaderProxyRecycler.acquire();
                    this.inputStream = new Resource.InputStreamResourceCloser(this, this.moduleReaderProxy.open(resourcePath));
                    this.length = -1L;
                    return this.inputStream;
                }
                catch (SecurityException e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            public synchronized byte[] load() throws IOException {
                try {
                    this.read();
                    byte[] byteArray = this.byteBufferToByteArray();
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public synchronized void close() {
                super.close();
                if (this.byteBuffer != null) {
                    if (this.moduleReaderProxy != null) {
                        this.moduleReaderProxy.release(this.byteBuffer);
                    }
                    this.byteBuffer = null;
                }
                if (this.moduleReaderProxy != null) {
                    ClasspathElementModule.this.moduleReaderProxyRecycler.recycle(this.moduleReaderProxy);
                    this.moduleReaderProxy = null;
                }
                this.markAsClosed();
            }
        };
    }

    @Override
    Resource getResource(String relativePath) {
        return this.allResourcePaths.contains(relativePath) ? this.newResource(relativePath) : null;
    }

    @Override
    void scanPaths(int classpathElementIdx, LogNode log) {
        if (this.skipClasspathElement) {
            return;
        }
        if (this.scanned.getAndSet(true)) {
            throw new IllegalArgumentException("Already scanned classpath element " + this.toString());
        }
        LogNode subLog = log == null ? null : this.log(classpathElementIdx, "Scanning module " + this.moduleRef.getName(), log);
        try {
            RecycleOnClose<ModuleReaderProxy, IOException> moduleReaderProxyRecycleOnClose = this.moduleReaderProxyRecycler.acquireRecycleOnClose();
            try {
                List<String> resourceRelativePaths;
                try {
                    resourceRelativePaths = moduleReaderProxyRecycleOnClose.get().list();
                }
                catch (SecurityException e) {
                    if (subLog != null) {
                        subLog.log("Could not get resource list for module " + this.moduleRef.getName(), e);
                    }
                    if (moduleReaderProxyRecycleOnClose != null) {
                        moduleReaderProxyRecycleOnClose.close();
                    }
                    return;
                }
                CollectionUtils.sortIfNotEmpty(resourceRelativePaths);
                String prevParentRelativePath = null;
                ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
                for (String relativePath : resourceRelativePaths) {
                    if (relativePath.endsWith("/")) continue;
                    if (relativePath.startsWith("META-INF/versions/")) {
                        if (subLog == null) continue;
                        subLog.log("Found unexpected nested versioned entry in module -- skipping: " + relativePath);
                        continue;
                    }
                    this.checkResourcePathWhiteBlackList(relativePath, log);
                    if (this.skipClasspathElement) {
                        return;
                    }
                    int lastSlashIdx = relativePath.lastIndexOf(47);
                    String parentRelativePath = lastSlashIdx < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
                    boolean parentRelativePathChanged = !parentRelativePath.equals(prevParentRelativePath);
                    ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || parentRelativePathChanged ? this.scanSpec.dirWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
                    prevParentRelativePath = parentRelativePath;
                    prevParentMatchStatus = parentMatchStatus;
                    if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX) {
                        if (subLog == null) continue;
                        subLog.log("Skipping blacklisted path: " + relativePath);
                        continue;
                    }
                    if (!this.allResourcePaths.add(relativePath)) continue;
                    if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE && this.scanSpec.classfileIsSpecificallyWhitelisted(relativePath)) {
                        this.addWhitelistedResource(this.newResource(relativePath), parentMatchStatus, false, subLog);
                        continue;
                    }
                    if (!this.scanSpec.enableClassInfo || !relativePath.equals("module-info.class")) continue;
                    this.addWhitelistedResource(this.newResource(relativePath), parentMatchStatus, true, subLog);
                }
                File moduleFile = this.moduleRef.getLocationFile();
                if (moduleFile != null && moduleFile.exists()) {
                    this.fileToLastModified.put(moduleFile, moduleFile.lastModified());
                }
            }
            finally {
                if (moduleReaderProxyRecycleOnClose != null) {
                    try {
                        moduleReaderProxyRecycleOnClose.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            if (subLog != null) {
                subLog.log("Exception opening module " + this.moduleRef.getName(), e);
            }
            this.skipClasspathElement = true;
        }
        this.finishScanPaths(subLog);
    }

    ModuleRef getModuleRef() {
        return this.moduleRef;
    }

    @Override
    public String getModuleName() {
        String moduleName = this.moduleRef.getName();
        if (moduleName == null || moduleName.isEmpty()) {
            moduleName = this.moduleNameFromModuleDescriptor;
        }
        return moduleName == null || moduleName.isEmpty() ? null : moduleName;
    }

    private String getModuleNameOrEmpty() {
        String moduleName = this.getModuleName();
        return moduleName == null ? "" : moduleName;
    }

    @Override
    URI getURI() {
        URI uri = this.moduleRef.getLocation();
        if (uri == null) {
            throw new IllegalArgumentException("Module " + this.getModuleName() + " has a null location");
        }
        return uri;
    }

    @Override
    File getFile() {
        try {
            File file;
            URI uri = this.moduleRef.getLocation();
            if (uri != null && !uri.getScheme().equals("jrt") && (file = new File(uri)).exists()) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return this.moduleRef.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClasspathElementModule)) {
            return false;
        }
        ClasspathElementModule other = (ClasspathElementModule)obj;
        return this.getModuleNameOrEmpty().equals(other.getModuleNameOrEmpty());
    }

    public int hashCode() {
        return this.getModuleNameOrEmpty().hashCode();
    }
}

