/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode;

import org.apache.geode.DataSerializable;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;

public abstract class Instantiator {
    private Class<? extends DataSerializable> clazz;
    private int id;
    private EventID eventId;
    private ClientProxyMembershipID context;

    public static synchronized void register(Instantiator instantiator) {
        InternalInstantiator.register(instantiator, true);
    }

    @Deprecated
    public static synchronized void register(Instantiator instantiator, boolean distribute) {
        InternalInstantiator.register(instantiator, distribute);
    }

    public Instantiator(Class<? extends DataSerializable> c, int classId) {
        if (c == null) {
            throw new NullPointerException("Cannot register a null class.");
        }
        if (!DataSerializable.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(String.format("Class %s does not implement DataSerializable", c.getName()));
        }
        if (classId == 0) {
            throw new IllegalArgumentException(String.format("Class id %s must not be 0.", classId));
        }
        this.clazz = c;
        this.id = classId;
    }

    public abstract DataSerializable newInstance();

    public Class<? extends DataSerializable> getInstantiatedClass() {
        return this.clazz;
    }

    public int getId() {
        return this.id;
    }

    public void setEventId(Object eventId) {
        this.eventId = (EventID)eventId;
    }

    public Object getEventId() {
        return this.eventId;
    }

    public void setContext(Object context) {
        this.context = (ClientProxyMembershipID)context;
    }

    public Object getContext() {
        return this.context;
    }
}

