/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.annotations.Immutable;

@Immutable
public class ResumptionAction
implements Serializable {
    private static final long serialVersionUID = 6632254151314915610L;
    @Immutable
    public static final ResumptionAction NONE = new ResumptionAction("NONE", 0);
    @Immutable
    public static final ResumptionAction REINITIALIZE = new ResumptionAction("REINITIALIZE", 1);
    private final transient String name;
    public final byte ordinal;
    @Immutable
    private static final ResumptionAction[] PRIVATE_VALUES = new ResumptionAction[]{NONE, REINITIALIZE};
    @Immutable
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));

    private Object readResolve() throws ObjectStreamException {
        return PRIVATE_VALUES[this.ordinal];
    }

    private ResumptionAction(String name, int ordinal) {
        this.name = name;
        this.ordinal = (byte)ordinal;
    }

    public static ResumptionAction fromOrdinal(byte ordinal) {
        return PRIVATE_VALUES[ordinal];
    }

    public static ResumptionAction fromName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(String.format("Invalid ResumptionAction name: %s", name));
        }
        for (int i = 0; i < PRIVATE_VALUES.length; ++i) {
            if (!name.equals(ResumptionAction.PRIVATE_VALUES[i].name)) continue;
            return PRIVATE_VALUES[i];
        }
        throw new IllegalArgumentException(String.format("Invalid ResumptionAction name: %s", name));
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean isReinitialize() {
        return this == REINITIALIZE;
    }

    public String toString() {
        return this.name;
    }
}

