/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RemoteCacheInfo;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class CacheConfigResponse
extends AdminResponse {
    private RemoteCacheInfo info;
    private Exception exception;

    public static CacheConfigResponse create(DistributionManager dm, InternalDistributedMember recipient, int cacheId, byte attributeCode, int newValue) {
        CacheConfigResponse m = new CacheConfigResponse();
        m.setRecipient(recipient);
        try {
            InternalCache c = (InternalCache)CacheFactory.getInstanceCloseOk(dm.getSystem());
            if (cacheId != System.identityHashCode(c)) {
                m.info = null;
            } else {
                switch (attributeCode) {
                    case 1: {
                        c.setLockTimeout(newValue);
                        break;
                    }
                    case 2: {
                        c.setLockLease(newValue);
                        break;
                    }
                    case 3: {
                        c.setSearchTimeout(newValue);
                        break;
                    }
                    default: {
                        Assert.assertTrue(false, "Unknown config code: " + attributeCode);
                    }
                }
            }
            m.info = new RemoteCacheInfo(c);
        }
        catch (CancelException ignore) {
            m.info = null;
        }
        catch (Exception ex) {
            m.exception = ex;
            m.info = null;
        }
        return m;
    }

    RemoteCacheInfo getCacheInfo() {
        return this.info;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getDSFID() {
        return 1013;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.info, out);
        DataSerializer.writeObject(this.exception, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.info = (RemoteCacheInfo)DataSerializer.readObject(in);
        this.exception = (Exception)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "CacheConfigResponse from " + this.getSender() + " info=" + this.info;
    }
}

