/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ProcessorKeeper21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class InitialImageFlowControl
implements MembershipListener {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static final ProcessorKeeper21 keeper = new ProcessorKeeper21(false);
    private int id;
    private int maxPermits = InitialImageOperation.CHUNK_PERMITS;
    private final Semaphore permits = new Semaphore(this.maxPermits);
    private final DistributionManager dm;
    private final InternalDistributedMember target;
    private final AtomicBoolean aborted = new AtomicBoolean();

    public static InitialImageFlowControl register(DistributionManager dm, InternalDistributedMember target) {
        int id;
        InitialImageFlowControl control = new InitialImageFlowControl(dm, target);
        control.id = id = keeper.put(control);
        Set<InternalDistributedMember> availableIds = dm.addMembershipListenerAndGetDistributionManagerIds(control);
        if (!availableIds.contains(target)) {
            control.abort();
        }
        return control;
    }

    private InitialImageFlowControl(DistributionManager dm, InternalDistributedMember target) {
        this.dm = dm;
        this.target = target;
    }

    private void releasePermit() {
        this.permits.release();
        this.incMessagesInFlight(-1);
    }

    private void incMessagesInFlight(int val) {
        this.dm.getStats().incInitialImageMessagesInFlight(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquirePermit() {
        long startWaitTime = System.currentTimeMillis();
        while (!this.aborted.get()) {
            this.checkCancellation();
            boolean interrupted = false;
            try {
                this.basicWait(startWaitTime);
                break;
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.checkCancellation();
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
            }
        }
        if (!this.aborted.get()) {
            this.incMessagesInFlight(1);
        }
    }

    private void basicWait(long startWaitTime) throws InterruptedException {
        long timeout = (long)this.getAckWaitThreshold() * 1000L;
        long timeSoFar = System.currentTimeMillis() - startWaitTime;
        if (timeout <= 0L) {
            timeout = Long.MAX_VALUE;
        }
        if (!this.aborted.get() && !this.permits.tryAcquire(timeout - timeSoFar - 1L, TimeUnit.MILLISECONDS)) {
            this.checkCancellation();
            Set<InternalDistributedMember> activeMembers = this.dm.getDistributionManagerIds();
            logger.warn("{} seconds have elapsed while waiting for replies: {} on {} whose current membership list is: [{}]", (Object)this.getAckWaitThreshold(), (Object)this, (Object)this.dm.getId(), activeMembers);
            this.permits.acquire();
            logger.info("{} wait for replies completed", (Object)"InitialImageFlowControl");
        }
    }

    private int getAckWaitThreshold() {
        return this.dm.getConfig().getAckWaitThreshold();
    }

    private void checkCancellation() {
        this.dm.getCancelCriterion().checkCancelInProgress(null);
    }

    public void unregister() {
        this.dm.removeMembershipListener(this);
        keeper.remove(this.id);
        this.abort();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        if (id.equals(this.target)) {
            this.abort();
        }
    }

    private void abort() {
        if (!this.aborted.getAndSet(true)) {
            this.incMessagesInFlight(-(this.maxPermits - this.permits.availablePermits()));
            this.permits.release(0x3FFFFFFF);
        }
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    public String toString() {
        return "<InitialImageFlowControl for GII to " + this.target + " with " + this.permits.availablePermits() + " available permits>";
    }

    public static class FlowControlPermitMessage
    extends DistributionMessage
    implements DataSerializableFixedID {
        private int keeperId;

        private FlowControlPermitMessage(int keeperId2) {
            this.keeperId = keeperId2;
        }

        public FlowControlPermitMessage() {
        }

        public static void send(DistributionManager dm, InternalDistributedMember recipient, int keeperId) {
            FlowControlPermitMessage message = new FlowControlPermitMessage(keeperId);
            message.setRecipient(recipient);
            dm.putOutgoing(message);
        }

        @Override
        public int getProcessorType() {
            return 73;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            InitialImageFlowControl control = (InitialImageFlowControl)keeper.retrieve(this.keeperId);
            if (control != null) {
                control.releasePermit();
            }
        }

        public int getDSFID() {
            return 2120;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.keeperId = in.readInt();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.keeperId);
        }
    }
}

