/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class InvalidateRegionOperation
extends DistributedCacheOperation {
    public InvalidateRegionOperation(RegionEventImpl event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        InvalidateRegionMessage msg = new InvalidateRegionMessage();
        RegionEventImpl regionEvent = (RegionEventImpl)this.event;
        msg.eventID = regionEvent.getEventId();
        return msg;
    }

    @Override
    protected Set getRecipients() {
        CacheDistributionAdvisor advisor = this.getRegion().getCacheDistributionAdvisor();
        return advisor.adviseInvalidateRegion();
    }

    @Override
    protected boolean supportsAdjunctMessaging() {
        return false;
    }

    public static class InvalidateRegionMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected EventID eventID;

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            RegionEventImpl event = new RegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, this.getSender());
            event.setEventID(this.eventID);
            if (this.filterRouting != null) {
                event.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
            }
            return event;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, ClusterDistributionManager dm) throws EntryNotFoundException {
            RegionEventImpl ev = (RegionEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.region;
            rgn.basicInvalidateRegion(ev);
            this.appliedOperation = true;
            return true;
        }

        public int getDSFID() {
            return -82;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.eventID = (EventID)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeObject(this.eventID, out);
        }
    }
}

